/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryAmmoItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.entity.FluxArrowEntity;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxQuiverItem
extends ItemCoFH
implements IMultiModeFluxItem {
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;
    protected int energyPerUse = 500;
    protected int energyPerUseEmpowered = 2000;

    public FluxQuiverItem(int enchantability, Item.Properties builder, int energy, int xfer) {
        this(enchantability, builder, energy, xfer, 1.0f);
    }

    public FluxQuiverItem(int enchantability, Item.Properties builder, int energy, int xfer, float energyUseMod) {
        super(builder);
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        this.energyPerUse = (int)((float)this.energyPerUse * energyUseMod);
        this.energyPerUseEmpowered = (int)((float)this.energyPerUseEmpowered * energyUseMod);
        this.setEnchantability(enchantability);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IMultiModeFluxItem.super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluxQuiverItemWrapper(stack, this);
    }

    @Override
    public int getEnergyPerUse(boolean empowered) {
        return empowered ? this.energyPerUseEmpowered : this.energyPerUse;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxQuiverItemWrapper
    extends EnergyContainerItemWrapper
    implements IArcheryAmmoItem {
        private final LazyOptional<IArcheryAmmoItem> holder;
        final ItemStack quiverItem;

        FluxQuiverItemWrapper(ItemStack quiverItemContainer, IEnergyContainerItem item) {
            super(quiverItemContainer, item, item.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
            this.quiverItem = quiverItemContainer;
        }

        public void onArrowLoosed(PlayerEntity shooter) {
            FluxQuiverItem.this.useEnergy(this.quiverItem, FluxQuiverItem.this.isEmpowered(this.quiverItem), shooter != null && shooter.field_71075_bZ.field_75098_d);
        }

        public AbstractArrowEntity createArrowEntity(World world, PlayerEntity shooter) {
            FluxArrowEntity arrow = new FluxArrowEntity(world, (LivingEntity)shooter);
            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
            if (FluxQuiverItem.this.isEmpowered(this.quiverItem)) {
                ItemStack weapon;
                ItemStack itemStack = weapon = shooter.func_184614_ca().func_190926_b() ? shooter.func_184592_cb() : shooter.func_184614_ca();
                if (!weapon.func_190926_b()) {
                    if (weapon.func_77973_b() instanceof CrossbowItem) {
                        arrow.setExplodeArrow(true);
                        arrow.func_70239_b(8.0);
                    } else {
                        arrow.func_189654_d(true);
                    }
                }
            }
            return arrow;
        }

        public boolean isEmpty(PlayerEntity shooter) {
            return !FluxQuiverItem.this.hasEnergy(this.quiverItem, FluxQuiverItem.this.isEmpowered(this.quiverItem));
        }

        public boolean isInfinite(ItemStack bow, PlayerEntity shooter) {
            return shooter != null && shooter.field_71075_bZ.field_75098_d || Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityArchery.AMMO_ITEM_CAPABILITY) {
                return CapabilityArchery.AMMO_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

