/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.capability.CapabilityShieldItem;
import cofh.lib.capability.IShieldItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.impl.ShieldItemCoFH;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxShieldItem
extends ShieldItemCoFH
implements IMultiModeFluxItem {
    protected float repelRange = 4.0f;
    protected float repelStrength = 1.5f;
    protected int maxEnergy;
    protected int extract;
    protected int receive;

    public FluxShieldItem(int enchantability, Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder);
        this.maxEnergy = maxEnergy;
        this.extract = maxTransfer;
        this.receive = maxTransfer;
        this.setEnchantability(enchantability);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu().equals(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluxShieldItemWrapper(stack, this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isEmpowered(stack)) {
            this.repel(world, (LivingEntity)player, stack);
        }
        if (this.hasEnergy(stack, true)) {
            return super.func_77659_a(world, player, hand);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void repel(World world, LivingEntity living, ItemStack stack) {
        if (this.useEnergy(stack, true, (Entity)living)) {
            float range = this.getRepelRange(stack);
            double r2 = range * range;
            float strength = this.getRepelStrength(stack);
            AxisAlignedBB searchArea = living.func_174813_aQ().func_186662_g((double)range);
            for (Entity entity : world.func_175674_a((Entity)living, searchArea, EntityPredicates.field_188444_d)) {
                if (!(living.func_70068_e(entity) < r2)) continue;
                Vector3d knockback = entity.func_213303_ch().func_178788_d(living.func_213303_ch());
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_233627_a_(strength, -knockback.func_82615_a(), -knockback.func_82616_c());
                    continue;
                }
                entity.func_213317_d(knockback.func_72432_b().func_186678_a((double)strength));
                entity.field_70160_al = true;
            }
        }
    }

    public float getRepelRange(ItemStack stack) {
        return this.repelRange;
    }

    public float getRepelStrength(ItemStack stack) {
        return this.repelStrength;
    }

    public void func_219972_a(World world, LivingEntity living, ItemStack stack, int useDuration) {
        if (!this.hasEnergy(stack, true)) {
            living.func_184597_cx();
        }
    }

    public boolean isShield(ItemStack stack, @Nullable LivingEntity entity) {
        return stack.func_77973_b() instanceof FluxShieldItem;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxShieldItemWrapper
    extends EnergyContainerItemWrapper
    implements IShieldItem {
        private final LazyOptional<IShieldItem> holder;
        final ItemStack shieldItem;

        FluxShieldItemWrapper(ItemStack shieldItem, IEnergyContainerItem container) {
            super(shieldItem, container, container.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
            this.shieldItem = shieldItem;
        }

        public void onBlock(LivingEntity entity, DamageSource source, float amount) {
            if (FluxShieldItem.this.isEmpowered(this.shieldItem)) {
                FluxShieldItem.this.repel(entity.field_70170_p, entity, this.shieldItem);
            }
            if (!(!(amount >= 3.0f) || entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d)) {
                int extract = FluxShieldItem.this.getExtract(this.shieldItem);
                for (int energy = Math.min(this.getEnergyStored(), MathHelper.func_76123_f((float)amount) * FluxShieldItem.this.getEnergyPerUse(false)); energy > 0; energy -= extract) {
                    FluxShieldItem.this.useEnergy(this.shieldItem, Math.min(extract, energy), false);
                }
            }
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityShieldItem.SHIELD_ITEM_CAPABILITY) {
                return CapabilityShieldItem.SHIELD_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

