/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.item.ILeftClickHandlerItem;
import cofh.lib.item.impl.TridentItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.references.CoreReferences;
import cofh.redstonearsenal.entity.FluxTridentEntity;
import cofh.redstonearsenal.item.IFluxItem;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluxTridentItem
extends TridentItemCoFH
implements IMultiModeFluxItem,
ILeftClickHandlerItem {
    public static final double PLUNGE_RANGE = 3.5;
    public static final double PLUNGE_SPEED = 3.0;
    protected final float damage;
    protected final float attackSpeed;
    protected final float addedReach;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxTridentItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, float reachIn, Item.Properties builder, int energy, int xfer) {
        super(tier, builder);
        this.damage = (float)attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
        this.addedReach = reachIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("throwing"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu().equals(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public FluxTridentItem(IItemTier tier, int enchantability, int attackDamageIn, float attackSpeedIn, float reachIn, Item.Properties builder, int energy, int xfer) {
        this(tier, attackDamageIn, attackSpeedIn, reachIn, builder, energy, xfer);
        this.enchantability = enchantability;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        LivingEntity living;
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).func_204805_cN() && (living.func_233570_aj_() || living.func_204231_K() && living.func_213322_ci().func_189985_c() < (double)0.09f)) {
            FluxTridentItem.stopSpinAttack(living);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasEnergy(stack, false) && !player.func_204805_cN() && (EnchantmentHelper.func_203190_g((ItemStack)stack) <= 0 || player.func_70026_G())) {
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int remainingDuration) {
        if (entity instanceof PlayerEntity) {
            int riptideLevel;
            PlayerEntity player = (PlayerEntity)entity;
            int i = this.func_77626_a(stack) - remainingDuration;
            if (i >= 10 && ((riptideLevel = EnchantmentHelper.func_203190_g((ItemStack)stack)) <= 0 || player.func_70026_G())) {
                if (!world.field_72995_K && this.useEnergy(stack, false, player.field_71075_bZ.field_75098_d) && riptideLevel == 0) {
                    FluxTridentEntity tridentEntity = new FluxTridentEntity(world, (LivingEntity)player, stack);
                    tridentEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
                    if (player.field_71075_bZ.field_75098_d) {
                        tridentEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_217376_c((Entity)tridentEntity);
                    world.func_217384_a(null, (Entity)tridentEntity, SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                if (riptideLevel > 0) {
                    float degToRad = (float)Math.PI / 180;
                    float xRotRad = player.field_70125_A * degToRad;
                    float yRotRad = player.field_70177_z * degToRad;
                    float xPush = -MathHelper.func_76126_a((float)yRotRad) * MathHelper.func_76134_b((float)xRotRad);
                    float yPush = -MathHelper.func_76126_a((float)xRotRad);
                    float zPush = MathHelper.func_76134_b((float)yRotRad) * MathHelper.func_76134_b((float)xRotRad);
                    float riptideMult = (1.0f + (float)riptideLevel) * 0.75f / MathHelper.func_76129_c((float)(xPush * xPush + yPush * yPush + zPush * zPush));
                    player.func_70024_g((double)(xPush * riptideMult), (double)(yPush * riptideMult), (double)(zPush * riptideMult));
                    player.func_204803_n(20);
                    if (player.func_233570_aj_()) {
                        player.func_213315_a(MoverType.SELF, new Vector3d(0.0, 1.1999999, 0.0));
                    }
                    SoundEvent soundevent = riptideLevel >= 3 ? SoundEvents.field_203273_io : (riptideLevel == 2 ? SoundEvents.field_203272_in : SoundEvents.field_203271_im);
                    world.func_217384_a(null, (Entity)player, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public boolean startPlunge(LivingEntity living) {
        if (!FluxTridentItem.canStartPlunging(living)) {
            return false;
        }
        if (living instanceof PlayerEntity) {
            ((PlayerEntity)living).func_226568_ek_();
            ((PlayerEntity)living).field_71075_bZ.field_75100_b = false;
        }
        living.func_204803_n(200);
        Vector3d motion = FluxTridentItem.getPlungeVector(living.func_70040_Z(), this.getPlungeSpeed());
        living.func_70024_g(motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c());
        return true;
    }

    public static boolean canStartPlunging(LivingEntity living) {
        if (living.func_233570_aj_() || living.func_204805_cN()) {
            return false;
        }
        RayTraceContext context = new RayTraceContext(living.func_213303_ch(), living.func_213303_ch().func_72441_c(0.0, -3.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)living);
        return living.field_70170_p.func_217299_a(context).func_216346_c().equals((Object)RayTraceResult.Type.MISS);
    }

    public boolean plungeAttack(World world, LivingEntity attacker, ItemStack stack) {
        if (attacker.field_70143_R <= (float)attacker.func_82143_as() || !this.isEmpowered(stack) || !this.useEnergy(stack, true, (Entity)attacker)) {
            return false;
        }
        if (Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_203196_F, (ItemStack)stack) > 0 && world.func_226660_f_(attacker.func_233580_cy_()) && world instanceof ServerWorld && world.func_72911_I()) {
            attacker.func_195064_c(new EffectInstance(CoreReferences.LIGHTNING_RESISTANCE, 40, 0, false, false));
            Utils.spawnLightningBolt((World)world, (BlockPos)attacker.func_233580_cy_(), (Entity)attacker);
        }
        double range = this.getPlungeRange();
        double r2 = range * range;
        AxisAlignedBB searchArea = attacker.func_174813_aQ().func_72314_b(range, 1.0, range);
        Predicate<Entity> filter = EntityPredicates.field_188444_d.and(entity -> entity instanceof LivingEntity);
        boolean hit = false;
        for (Entity target : world.func_175674_a((Entity)attacker, searchArea, filter)) {
            if (!(attacker.func_70068_e(target) <= r2)) continue;
            hit |= target.func_70097_a(IFluxItem.fluxDirectDamage(attacker), this.getPlungeAttackDamage(attacker, stack));
        }
        if (hit) {
            world.func_184148_a(null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_203270_il, SoundCategory.PLAYERS, 10.0f, 1.0f);
        }
        return hit;
    }

    public static void stopSpinAttack(LivingEntity living) {
        if (living.func_204805_cN()) {
            living.field_204807_bs = 0;
            AxisAlignedBB noVolume = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            living.func_204801_a(noVolume, noVolume);
        }
    }

    public static Vector3d getPlungeVector(Vector3d lookVector, double magnitude) {
        double x = lookVector.func_82615_a();
        double y = lookVector.func_82617_b();
        double z = lookVector.func_82616_c();
        double compSqr = lookVector.func_189985_c() * 0.5;
        if (x < (double)1.0E-4f && z < (double)1.0E-4f) {
            return new Vector3d(0.0, -magnitude, 0.0);
        }
        if (compSqr > y * y || y > 0.0) {
            double comp = MathHelper.func_76133_a((double)compSqr);
            double horzSum = Math.abs(x) + Math.abs(z);
            return new Vector3d(x / horzSum * comp, -comp, z / horzSum * comp).func_186678_a(magnitude);
        }
        return new Vector3d(x, y, z).func_186678_a(magnitude);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((World)worldIn) && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getPlungeAttackDamage(LivingEntity living, ItemStack stack) {
        return this.hasEnergy(stack, true) && living.field_70143_R > (float)living.func_82143_as() ? 2.5f * MathHelper.func_76129_c((float)living.field_70143_R) : 0.0f;
    }

    public double getPlungeRange() {
        return 3.5;
    }

    public double getPlungeSpeed() {
        return 3.0;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    protected float getAddedReach(ItemStack stack) {
        return this.addedReach;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    public void onLeftClick(PlayerEntity player, ItemStack stack) {
        if (this.isEmpowered(stack) && this.hasEnergy(stack, true)) {
            this.startPlunge((LivingEntity)player);
        }
    }
}

