/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.block.IDismantleable;
import cofh.lib.block.IWrenchable;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.references.CoreReferences;
import cofh.redstonearsenal.entity.FluxWrenchEntity;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluxWrenchItem
extends ItemCoFH
implements IMultiModeFluxItem {
    protected static final Set<Enchantment> VALID_ENCHANTS = new ObjectOpenHashSet();
    protected final float damage;
    protected final float attackSpeed;
    protected final int throwCooldown;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxWrenchItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(builder);
        this.damage = tier.func_200929_c() + attackDamageIn;
        this.attackSpeed = attackSpeedIn;
        this.throwCooldown = (int)(20.0f / (4.0f + attackSpeedIn)) + 2;
        this.setEnchantability(tier.func_200927_e());
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IMultiModeFluxItem.super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public static void initEnchants() {
        VALID_ENCHANTS.add(Enchantments.field_185302_k);
        VALID_ENCHANTS.add(Enchantments.field_77334_n);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || VALID_ENCHANTS.contains(enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasEnergy(stack, false)) {
            if (!world.func_201670_d()) {
                world.func_217376_c((Entity)new FluxWrenchEntity(world, (LivingEntity)player, stack));
                player.field_71071_by.func_184437_d(stack);
                player.func_184811_cZ().func_185145_a((Item)this, this.getRangedAttackCooldown(stack));
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    protected boolean useDelegate(ItemStack stack, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (player == null || world.func_175623_d(pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (player.func_226563_dT_() && block instanceof IDismantleable && ((IDismantleable)block).canDismantle(world, pos, state, player)) {
            if (Utils.isServerWorld((World)world)) {
                BlockRayTraceResult target = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k());
                ((IDismantleable)block).dismantleBlock(world, pos, state, (RayTraceResult)target, player, false);
            }
            player.func_184609_a(context.func_221531_n());
            return true;
        }
        if (!player.func_226563_dT_()) {
            if (block instanceof IWrenchable && ((IWrenchable)block).canWrench(world, pos, state, player)) {
                BlockRayTraceResult target = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k());
                ((IWrenchable)block).wrenchBlock(world, pos, state, (RayTraceResult)target, player);
                return true;
            }
            return BlockHelper.attemptRotateBlock((BlockState)state, (World)world, (BlockPos)pos);
        }
        return false;
    }

    public boolean useRanged(World world, ItemStack stack, PlayerEntity player, BlockRayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.MISS) {
            return false;
        }
        BlockPos pos = result.func_216350_a();
        if (player == null || world.func_175623_d(pos) || !this.hasEnergy(stack, false) && !player.field_71075_bZ.field_75098_d || !player.func_175151_a(pos, result.func_216354_b(), stack)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IWrenchable && ((IWrenchable)block).canWrench(world, pos, state, player)) {
            ((IWrenchable)block).wrenchBlock(world, pos, state, (RayTraceResult)result, player);
            this.useEnergy(stack, false, player.field_71075_bZ.field_75098_d);
            return true;
        }
        if (BlockHelper.attemptRotateBlock((BlockState)state, (World)world, (BlockPos)pos)) {
            this.useEnergy(stack, false, player.field_71075_bZ.field_75098_d);
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        return player.func_175151_a(context.func_195995_a(), context.func_196000_l(), context.func_195996_i()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        return player.func_175151_a(context.func_195995_a(), context.func_196000_l(), stack) && this.useDelegate(stack, context) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.func_195064_c(new EffectInstance(CoreReferences.WRENCHED, 60, 0, false, false));
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((World)worldIn) && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    public float getRangedAttackDamage(ItemStack stack) {
        return this.getAttackDamage(stack);
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    protected int getRangedAttackCooldown(ItemStack stack) {
        return this.throwCooldown;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

