/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.item.ICoFHItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.util.RSAEnergyHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public interface IFluxItem
extends ICoFHItem,
IEnergyContainerItem {
    public static final int ENERGY_PER_USE = 500;
    public static final int ENERGY_PER_USE_EMPOWERED = 2000;

    default public Capability<? extends IEnergyStorage> getEnergyCapability() {
        return RSAEnergyHelper.getBaseEnergySystem();
    }

    default public int getEnergyPerUse(boolean empowered) {
        return empowered ? 2000 : 500;
    }

    default public boolean hasEnergy(ItemStack stack, int amount) {
        return this.getEnergyStored(stack) >= amount;
    }

    default public boolean hasEnergy(ItemStack stack, boolean empowered) {
        return this.hasEnergy(stack, this.getEnergyPerUse(empowered));
    }

    default public boolean useEnergy(ItemStack stack, int amount, boolean simulate) {
        if (simulate) {
            return true;
        }
        if (this.hasEnergy(stack, amount)) {
            this.extractEnergy(stack, amount, false);
            return true;
        }
        return false;
    }

    default public boolean useEnergy(ItemStack stack, int amount, Entity entity) {
        return this.useEnergy(stack, amount, Utils.isCreativePlayer((Entity)entity));
    }

    default public boolean useEnergy(ItemStack stack, boolean empowered, boolean simulate) {
        return this.useEnergy(stack, this.getEnergyPerUse(empowered), simulate);
    }

    default public boolean useEnergy(ItemStack stack, boolean empowered, Entity entity) {
        return this.useEnergy(stack, this.getEnergyPerUse(empowered), Utils.isCreativePlayer((Entity)entity));
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0;
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    default public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) > 0;
    }

    default public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    default public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0.0;
        }
        return MathHelper.clamp((double)(1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack)), (double)0.0, (double)1.0);
    }

    default public float getChargedModelProperty(ItemStack stack, World world, LivingEntity entity) {
        return this.getEnergyStored(stack) > 0 ? 1.0f : 0.0f;
    }

    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this, this.getEnergyCapability());
    }

    default public void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean creative = this.isCreative(stack, ContainerType.ENERGY);
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.energy") + ": " + (creative ? StringHelper.localize((String)"info.cofh.infinite") : StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF"))));
        this.addEnergyTooltip(stack, worldIn, tooltip, flagIn, this.getExtract(stack), this.getReceive(stack), creative);
    }

    public static DamageSource fluxDirectDamage(LivingEntity attacker) {
        return new EntityDamageSource("flux", (Entity)attacker).func_76348_h();
    }

    public static DamageSource fluxRangedDamage(ProjectileEntity projectile, @Nullable Entity shooter) {
        return new IndirectEntityDamageSource("flux", (Entity)projectile, shooter).func_76349_b().func_76348_h();
    }
}

