/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.util.helpers.ChatHelper;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public interface IMultiModeFluxItem
extends IFluxItem,
IMultiModeItem {
    default public boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) > 0;
    }

    default public float getEmpoweredModelProperty(ItemStack stack, World world, LivingEntity entity) {
        return this.getEnergyStored(stack) > 0 && this.isEmpowered(stack) ? 1.0f : 0.0f;
    }

    default public void onModeChange(PlayerEntity player, ItemStack stack) {
        if (this.isEmpowered(stack)) {
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
        }
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.redstone_arsenal.mode." + this.getMode(stack)));
    }

    @Override
    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this, this.getEnergyCapability());
    }

    @Override
    default public void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isEmpowered(stack)) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.redstone_arsenal.mode.1").func_240699_a_(TextFormatting.RED));
        } else {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.redstone_arsenal.mode.0").func_240699_a_(TextFormatting.GRAY));
        }
        if (this.getNumModes(stack) > 1) {
            this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
        }
        IFluxItem.super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }
}

