/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.network.client;

import cofh.core.util.ProxyUtils;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.redstonearsenal.RedstoneArsenal;
import cofh.redstonearsenal.util.FluxShieldingScheduler;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class FluxShieldingPacket
extends PacketBase
implements IPacketClient {
    protected int currCharges;
    protected int maxCharges;

    public FluxShieldingPacket() {
        super(1, RedstoneArsenal.PACKET_HANDLER);
    }

    public void handleClient() {
        if (ProxyUtils.isClient()) {
            FluxShieldingScheduler.updateHUD(this.currCharges, this.maxCharges);
        }
    }

    public void write(PacketBuffer buf) {
        buf.writeByte(this.currCharges);
        buf.writeByte(this.maxCharges);
    }

    public void read(PacketBuffer buf) {
        this.currCharges = buf.readByte();
        this.maxCharges = buf.readByte();
    }

    public static void sendToClient(int currCharges, int maxCharges, ServerPlayerEntity player) {
        FluxShieldingPacket packet = new FluxShieldingPacket();
        packet.currCharges = currCharges;
        packet.maxCharges = maxCharges;
        packet.sendToPlayer(player);
    }

    public static void sendToClient(int[] charges, ServerPlayerEntity player) {
        FluxShieldingPacket.sendToClient(charges[0], charges[1], player);
    }
}

