/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.util;

import cofh.core.compat.curios.CuriosProxy;
import cofh.redstonearsenal.capability.CapabilityFluxShielding;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;

public class FluxShieldingHelper {
    public static final String TAG_FLUX_SHIELD = "FluxShield";

    public static ItemStack findShieldedItem(LivingEntity entity) {
        Predicate<ItemStack> isShieldedItem = i -> i.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY).map(cap -> cap.currCharges(entity) > 0).orElse(false);
        ItemStack mainHand = entity.func_184614_ca();
        if (isShieldedItem.test(mainHand)) {
            return mainHand;
        }
        ItemStack offHand = entity.func_184592_cb();
        if (isShieldedItem.test(offHand)) {
            return offHand;
        }
        for (ItemStack piece : entity.func_184193_aE()) {
            if (!isShieldedItem.test(piece)) continue;
            return piece;
        }
        ItemStack[] retStack = new ItemStack[]{ItemStack.field_190927_a};
        CuriosProxy.getAllWorn((LivingEntity)entity).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ItemStack slot = c.getStackInSlot(i);
                if (!isShieldedItem.test(slot)) continue;
                retStack[0] = slot;
                return;
            }
        });
        return retStack[0];
    }

    public static int[] countCharges(LivingEntity entity) {
        if (entity == null) {
            return new int[]{0, 0};
        }
        int[] counter = new int[]{0, 0};
        Consumer<ItemStack> count = i -> {
            counter[0] = counter[0] + FluxShieldingHelper.getCurrCharges(entity, i);
            counter[1] = counter[1] + FluxShieldingHelper.getMaxCharges(entity, i);
        };
        for (ItemStack item : entity.func_184193_aE()) {
            count.accept(item);
        }
        CuriosProxy.getAllWorn((LivingEntity)entity).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                count.accept(c.getStackInSlot(i));
            }
        });
        return counter;
    }

    public static boolean hasFluxShieldCharge(LivingEntity entity) {
        return !FluxShieldingHelper.findShieldedItem(entity).func_190926_b();
    }

    public static boolean useFluxShieldCharge(LivingEntity entity) {
        return FluxShieldingHelper.useFluxShieldCharge(entity, FluxShieldingHelper.findShieldedItem(entity));
    }

    public static boolean useFluxShieldCharge(LivingEntity entity, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        LazyOptional cap = stack.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY);
        if (cap.map(c -> c.useCharge(entity)).orElse(false).booleanValue()) {
            if (entity instanceof ServerPlayerEntity) {
                cap.ifPresent(c -> c.scheduleUpdate((ServerPlayerEntity)entity));
            }
            FluxShieldingHelper.onUseFluxShieldCharge(entity);
            return true;
        }
        return false;
    }

    public static int getCurrCharges(LivingEntity entity, ItemStack stack) {
        return stack.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY).map(cap -> cap.currCharges(entity)).orElse(0);
    }

    public static int getMaxCharges(LivingEntity entity, ItemStack stack) {
        return stack.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY).map(cap -> cap.maxCharges(entity)).orElse(0);
    }

    public static boolean equalCharges(LivingEntity entity, ItemStack a, ItemStack b) {
        return FluxShieldingHelper.getCurrCharges(entity, a) == FluxShieldingHelper.getCurrCharges(entity, b) && FluxShieldingHelper.getMaxCharges(entity, a) == FluxShieldingHelper.getMaxCharges(entity, b);
    }

    protected static void onUseFluxShieldCharge(LivingEntity entity) {
        SoundCategory category = SoundCategory.NEUTRAL;
        if (entity instanceof PlayerEntity) {
            category = SoundCategory.PLAYERS;
        } else if (entity instanceof MonsterEntity) {
            category = SoundCategory.HOSTILE;
        }
        entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187635_cQ, category, 1.0f, 1.0f);
        AxisAlignedBB bounds = entity.func_174813_aQ();
        Vector3d pos = bounds.func_189972_c();
        if (!entity.field_70170_p.func_201670_d()) {
            ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 20, bounds.func_216364_b() * 0.5 + 0.2, bounds.func_216360_c() * 0.5 + 0.2, bounds.func_216362_d() * 0.5 + 0.2, 0.0);
        }
    }
}

