/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.util;

import cofh.core.compat.curios.CuriosProxy;
import cofh.redstonearsenal.capability.CapabilityFluxShielding;
import cofh.redstonearsenal.client.renderer.FluxShieldingHUDRenderer;
import cofh.redstonearsenal.network.client.FluxShieldingPacket;
import cofh.redstonearsenal.util.FluxShieldingHelper;
import com.google.common.collect.HashMultimap;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluxShieldingScheduler {
    public static HashMultimap<Long, ServerPlayerEntity> schedule = HashMultimap.create();

    public static void updateHUD(ServerPlayerEntity player) {
        FluxShieldingPacket.sendToClient(FluxShieldingHelper.countCharges((LivingEntity)player), player);
    }

    public static void updateHUD(int currCharges, int maxCharges, ServerPlayerEntity player) {
        FluxShieldingPacket.sendToClient(currCharges, maxCharges, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateHUD(int currCharges, int maxCharges) {
        FluxShieldingHUDRenderer.currCharges = currCharges;
        FluxShieldingHUDRenderer.maxCharges = maxCharges;
    }

    public static void scheduleUpdate(long time, ServerPlayerEntity player) {
        schedule.put((Object)time, (Object)player);
    }

    public static void loadSchedule(long time, ServerPlayerEntity player) {
        Consumer<ItemStack> schedule = i -> i.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY).ifPresent(c -> c.scheduleUpdate(player, time));
        for (ItemStack item : player.func_184209_aF()) {
            schedule.accept(item);
        }
        CuriosProxy.getAllWorn((LivingEntity)player).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                schedule.accept(c.getStackInSlot(i));
            }
        });
    }

    public static void handleSchedule(long time) {
        if (schedule.containsKey((Object)time)) {
            for (ServerPlayerEntity player : schedule.get((Object)time)) {
                FluxShieldingScheduler.updateHUD(player);
            }
            schedule.removeAll((Object)time);
        }
    }
}

