/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.altar;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.block.brazier.TileEntityBrazier;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.RitualManager;
import elucent.rootsclassic.tileentity.TEBase;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityAltar
extends TEBase
implements ITickable {
    private static final int RECIPE_PROGRESS_TIME = 200;
    private ArrayList<ItemStack> inventory = new ArrayList();
    private ArrayList<ItemStack> incenses = new ArrayList();
    private Random random = new Random();
    private int ticker = 0;
    private int progress = 0;
    private String ritualName = null;
    private RitualBase ritualCurrent = null;
    private ItemStack resultItem = ItemStack.field_190927_a;

    public void func_145839_a(NBTTagCompound tag) {
        int i;
        NBTTagList list;
        super.func_145839_a(tag);
        this.setInventory(new ArrayList<ItemStack>());
        if (tag.func_74764_b("inventory")) {
            list = tag.func_150295_c("inventory", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.getInventory().add(new ItemStack(list.func_150305_b(i)));
            }
        }
        this.setIncenses(new ArrayList<ItemStack>());
        if (tag.func_74764_b("incenses")) {
            list = tag.func_150295_c("incenses", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.getIncenses().add(new ItemStack(list.func_150305_b(i)));
            }
        }
        if (tag.func_74764_b("ritualName")) {
            this.setRitualName(tag.func_74779_i("ritualName"));
            this.setRitualCurrent(RitualManager.getRitualFromName(this.getRitualName()));
        }
        if (tag.func_74764_b("progress")) {
            this.setProgress(tag.func_74762_e("progress"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        int i;
        NBTTagList list;
        super.func_189515_b(tag);
        if (this.getInventory().size() > 0) {
            list = new NBTTagList();
            for (i = 0; i < this.getInventory().size(); ++i) {
                list.func_74742_a((NBTBase)this.getInventory().get(i).func_77955_b(new NBTTagCompound()));
            }
            tag.func_74782_a("inventory", (NBTBase)list);
        }
        if (this.getIncenses().size() > 0) {
            list = new NBTTagList();
            for (i = 0; i < this.getIncenses().size(); ++i) {
                list.func_74742_a((NBTBase)this.getIncenses().get(i).func_77955_b(new NBTTagCompound()));
            }
            tag.func_74782_a("incenses", (NBTBase)list);
        }
        if (this.getRitualName() != null) {
            tag.func_74778_a("ritualName", this.getRitualName());
        }
        tag.func_74768_a("progress", this.getProgress());
        return tag;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        for (int i = 0; i < this.getInventory().size(); ++i) {
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.getInventory().get(i)));
        }
        this.func_145843_s();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem.func_190926_b() && !player.func_70093_af() && this.getProgress() == 0) {
            if (this.getInventory().size() > 0) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, this.getInventory().remove(this.getInventory().size() - 1)));
                } else {
                    this.getInventory().remove(this.getInventory().size() - 1);
                }
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                return true;
            }
        } else {
            if (player.func_70093_af() && heldItem.func_190926_b() && this.getProgress() == 0) {
                this.setRitualName(null);
                this.setRitualCurrent(null);
                RitualBase ritual = RitualManager.findMatchingByIngredients(this);
                if (ritual == null) {
                    Roots.statusMessage(player, "roots.error.noritual.ingredients");
                    return false;
                }
                if (!ritual.verifyPositionBlocks(world, pos)) {
                    Roots.statusMessage(player, "roots.error.noritual.stones");
                    return false;
                }
                if (ritual.incesceMatches(this.func_145831_w(), this.func_174877_v())) {
                    this.setRitualCurrent(ritual);
                    this.setRitualName(ritual.getName());
                    this.setIncenses(RitualManager.getIncenses(world, this.func_174877_v()));
                    this.setProgress(200);
                    for (TileEntityBrazier brazier : ritual.getRecipeBraziers(world, pos)) {
                        brazier.setBurning(true);
                        brazier.setHeldItem(ItemStack.field_190927_a);
                    }
                    this.func_70296_d();
                    this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                    Roots.statusMessage(player, "roots.ritual.started");
                    return true;
                }
                Roots.statusMessage(player, "roots.error.noritual.incense");
                return false;
            }
            if (this.getInventory().size() < 3 && this.getProgress() == 0) {
                ItemStack toAdd = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77952_i());
                if (heldItem.func_77942_o()) {
                    toAdd.func_77982_d(heldItem.func_77978_p());
                }
                this.getInventory().add(toAdd);
                heldItem.func_190918_g(1);
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                return true;
            }
        }
        return false;
    }

    public void func_73660_a() {
        this.setTicker(this.getTicker() + 3);
        if (this.getTicker() > 360) {
            this.setTicker(0);
        }
        if (this.getProgress() > 0 && this.getRitualCurrent() != null) {
            this.setProgress(this.getProgress() - 1);
            if (this.func_145831_w().field_72995_K) {
                if (this.getRitualCurrent().getPositionsRelative().size() > 0) {
                    BlockPos pos = this.getRitualCurrent().getPositionsRelative().get(this.random.nextInt(this.getRitualCurrent().getPositionsRelative().size())).func_177984_a().func_177982_a(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
                    if (this.random.nextInt(6) == 0) {
                        Roots.proxy.spawnParticleMagicAltarLineFX(this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c);
                    } else {
                        Roots.proxy.spawnParticleMagicAltarLineFX(this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c);
                    }
                }
                if (this.random.nextInt(4) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(360.0 * (double)(this.getProgress() % 100) / 100.0)), this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(360.0 * (double)(this.getProgress() % 100) / 100.0)), this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c);
                }
                if (this.random.nextInt(4) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(90.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(90.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(90.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(90.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c);
                }
                if (this.random.nextInt(4) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(180.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(180.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(180.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(180.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c);
                }
                if (this.random.nextInt(4) == 0) {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(270.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(270.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicAltarFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(270.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(270.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c);
                }
            }
            if (this.getProgress() == 0 && this.getRitualCurrent() != null) {
                this.getRitualCurrent().doEffect(this.func_145831_w(), this.func_174877_v(), this.getInventory(), this.getIncenses());
                this.setRitualName(null);
                this.setRitualCurrent(null);
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            }
        }
    }

    public ArrayList<ItemStack> getInventory() {
        return this.inventory;
    }

    public void setInventory(ArrayList<ItemStack> inventory) {
        this.inventory = inventory;
    }

    public ArrayList<ItemStack> getIncenses() {
        return this.incenses;
    }

    public void setIncenses(ArrayList<ItemStack> incenses) {
        this.incenses = incenses;
    }

    public int getTicker() {
        return this.ticker;
    }

    public void setTicker(int ticker) {
        this.ticker = ticker;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public String getRitualName() {
        return this.ritualName;
    }

    public void setRitualName(String ritualName) {
        this.ritualName = ritualName;
    }

    public RitualBase getRitualCurrent() {
        return this.ritualCurrent;
    }

    public void setRitualCurrent(RitualBase ritualCurrent) {
        this.ritualCurrent = ritualCurrent;
    }

    public ItemStack getResultItem() {
        return this.resultItem;
    }

    public void setResultItem(ItemStack resultItem) {
        if (resultItem == null) {
            resultItem = ItemStack.field_190927_a;
        }
        this.resultItem = resultItem;
    }
}

