/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.brazier;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.tileentity.TEBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityBrazier
extends TEBase
implements ITickable {
    private static final int TOTAL_BURN_TIME = 2400;
    private ItemStack heldItem = ItemStack.field_190927_a;
    private Random random = new Random();
    private int ticker = 0;
    private boolean burning = false;
    private int progress = 0;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("heldItem")) {
            this.setHeldItem(new ItemStack(tag.func_74775_l("heldItem")));
        }
        if (tag.func_74764_b("burning")) {
            this.setBurning(tag.func_74767_n("burning"));
        }
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.getHeldItem() != null) {
            tag.func_74782_a("heldItem", (NBTBase)this.getHeldItem().func_77955_b(new NBTTagCompound()));
        }
        tag.func_74757_a("burning", this.isBurning());
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this.getHeldItem() != null && !this.isBurning() && !world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.getHeldItem()));
        }
        this.func_145843_s();
    }

    private void dropContaining(IBlockState state) {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, this.getHeldItem()));
        }
        this.setHeldItem(ItemStack.field_190927_a);
    }

    private void notifyUpdate(IBlockState state) {
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack playerItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerItem.func_190926_b()) {
            if (!this.getHeldItem().func_190926_b() && !this.isBurning()) {
                if (player.func_70093_af()) {
                    Roots.statusMessage(player, this.getHeldItem().func_82833_r());
                } else {
                    this.dropContaining(state);
                    this.notifyUpdate(state);
                    Roots.statusMessage(player, "brazier.burning.empty");
                }
                return true;
            }
            if (this.isBurning() && player.func_70093_af()) {
                Roots.statusMessage(player, "brazier.burning.off");
                this.stopBurning();
                this.notifyUpdate(state);
                return true;
            }
        } else if (playerItem.func_77973_b() == Items.field_151033_d) {
            if (!this.getHeldItem().func_190926_b()) {
                this.startBurning();
                Roots.statusMessage(player, "brazier.burning.on");
                this.notifyUpdate(state);
                return true;
            }
        } else if (this.getHeldItem().func_190926_b()) {
            this.setHeldItem(new ItemStack(playerItem.func_77973_b(), 1, playerItem.func_77952_i()));
            if (playerItem.func_77942_o()) {
                this.getHeldItem().func_77982_d(playerItem.func_77978_p());
            }
            playerItem.func_190918_g(1);
            Roots.statusMessage(player, "brazier.burning.added");
            this.notifyUpdate(state);
            return true;
        }
        return false;
    }

    private void startBurning() {
        this.setBurning(true);
        this.progress = 2400;
    }

    private void stopBurning() {
        this.setBurning(false);
        this.progress = 0;
    }

    public void func_73660_a() {
        this.setTicker(this.getTicker() + (this.isBurning() ? 12 : 3));
        if (this.progress > 0) {
            World world = this.func_145831_w();
            --this.progress;
            if (this.progress % 2 == 0) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, this.random.nextDouble() * 0.0625 + 0.0625, 0.0, new int[]{0});
            }
            if (this.progress % 20 == 0) {
                world.func_175688_a(EnumParticleTypes.FLAME, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[]{0});
            }
            if (this.progress <= 0) {
                this.setBurning(false);
                this.func_70296_d();
                world.func_184138_a(this.func_174877_v(), world.func_180495_p(this.func_174877_v()), world.func_180495_p(this.func_174877_v()), 3);
            }
        }
        if (this.getTicker() > 360) {
            this.setTicker(0);
        }
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burning) {
        this.burning = burning;
    }

    public int getTicker() {
        return this.ticker;
    }

    public void setTicker(int ticker) {
        this.ticker = ticker;
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public void setHeldItem(ItemStack heldItem) {
        this.heldItem = heldItem;
    }
}

