/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.mortar;

import elucent.rootsclassic.RegistryManager;
import elucent.rootsclassic.Roots;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.component.ComponentRecipe;
import elucent.rootsclassic.tileentity.TEBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class TileEntityMortar
extends TEBase {
    private static final int MAX_INVO_SIZE = 8;
    private static final String NBT_MODIFIERS = "modifiers";
    public List<ItemStack> inventory = new ArrayList<ItemStack>();

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory = new ArrayList<ItemStack>();
        if (tag.func_74764_b(NBT_MODIFIERS)) {
            NBTTagList list = tag.func_150295_c(NBT_MODIFIERS, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.inventory.add(new ItemStack(list.func_150305_b(i)));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.inventory.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.inventory.size(); ++i) {
                list.func_74742_a((NBTBase)this.inventory.get(i).func_77955_b(new NBTTagCompound()));
            }
            tag.func_74782_a(NBT_MODIFIERS, (NBTBase)list);
        }
        return tag;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.dropAllItems(world, pos);
        this.func_145843_s();
    }

    private void dropAllItems(World world, BlockPos pos) {
        for (ItemStack stack : this.inventory) {
            if (world.field_72995_K || stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem.func_190926_b() && hand == EnumHand.MAIN_HAND) {
            return this.tryDropSingleItem(world, pos, state);
        }
        if (heldItem.func_77973_b() == RegistryManager.pestle) {
            return this.tryActivateRecipe(player, state);
        }
        return this.tryInsertItem(world, pos, state, heldItem);
    }

    private boolean tryInsertItem(World world, BlockPos pos, IBlockState state, ItemStack heldItem) {
        if (this.inventory.size() < 8) {
            if (heldItem.func_77973_b() == Items.field_151114_aO || heldItem.func_77973_b() == Items.field_151137_ax || heldItem.func_77973_b() == Items.field_151016_H) {
                int maxCapacity = ComponentRecipe.getModifierCapacity(this.inventory);
                int modifierCount = ComponentRecipe.getModifierCount(this.inventory);
                if (modifierCount < maxCapacity) {
                    this.inventory.add(new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77960_j()));
                    heldItem.func_190918_g(1);
                    this.func_70296_d();
                    this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                    return true;
                }
            } else {
                ItemStack oneItem = new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77952_i());
                if (heldItem.func_77942_o()) {
                    oneItem.func_77982_d(heldItem.func_77978_p());
                }
                this.inventory.add(oneItem);
                heldItem.func_190918_g(1);
                this.func_70296_d();
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                return true;
            }
        }
        return false;
    }

    private boolean tryDropSingleItem(World world, BlockPos pos, IBlockState state) {
        if (this.inventory.size() > 0) {
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, this.inventory.remove(this.inventory.size() - 1)));
            } else {
                this.inventory.remove(this.inventory.size() - 1);
            }
            this.func_70296_d();
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
            return true;
        }
        return false;
    }

    private boolean tryActivateRecipe(EntityPlayer player, IBlockState state) {
        ComponentRecipe recipe = ComponentManager.getRecipeFromInput(this.inventory);
        if (recipe == null) {
            player.func_146105_b((ITextComponent)new TextComponentString(Roots.lang("roots.mortar.invalid")), true);
            return false;
        }
        if (recipe.isDisabled()) {
            player.func_146105_b((ITextComponent)new TextComponentString(Roots.lang("roots.mortar.disabled")), true);
            return false;
        }
        if (recipe.needsMixin() && ComponentRecipe.getModifierCapacity(this.inventory) < 0) {
            player.func_146105_b((ITextComponent)new TextComponentString(Roots.lang("roots.mortar.mixin")), true);
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, recipe.getRecipeResult(this.inventory)));
        }
        this.inventory.clear();
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        return true;
    }
}

