/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.capability;

import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class ManaCapabilityProvider
implements ICapabilityProvider,
INBTSerializable,
IManaCapability {
    float mana;
    float maxMana;

    ManaCapabilityProvider(boolean isNew) {
        if (isNew) {
            this.mana = 40.0f;
            this.maxMana = 40.0f;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == RootsCapabilityManager.manaCapability;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == RootsCapabilityManager.manaCapability) {
            return (T)RootsCapabilityManager.manaCapability.cast((Object)this);
        }
        return null;
    }

    @Override
    public float getMana() {
        return this.mana;
    }

    @Override
    public float getMaxMana() {
        return this.maxMana;
    }

    @Override
    public void setMana(float mana) {
        this.mana = mana;
        if (mana < 0.0f) {
            this.mana = 0.0f;
        }
        if (mana > this.getMaxMana()) {
            this.mana = this.getMaxMana();
        }
    }

    @Override
    public void setMaxMana(float maxMana) {
        this.maxMana = maxMana;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("maxMana", this.getMaxMana());
        tag.func_74776_a("mana", this.getMana());
        return tag;
    }

    public void deserializeNBT(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            if (tag.func_74764_b("maxMana")) {
                this.setMaxMana(tag.func_74760_g("maxMana"));
            }
            if (tag.func_74764_b("mana")) {
                this.setMana(tag.func_74760_g("mana"));
            }
        }
    }
}

