/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import elucent.rootsclassic.Roots;
import elucent.rootsclassic.compat.SpellZen;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.RitualManager;
import elucent.rootsclassic.ritual.rituals.RitualCrafting;
import java.util.Arrays;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rootsclassic.Ritual")
@ZenRegister
public class RitualZen {
    @Optional.Method(modid="crafttweaker")
    @ZenMethod
    public static void addCraftingRitual(String uniqueName, IItemStack output, int level, double r, double g, double b, IItemStack[] incenses, IItemStack[] ingredients) {
        RitualCrafting newCraft = new RitualCrafting(uniqueName, level, r, g, b);
        newCraft.setResult(SpellZen.toStack(output));
        newCraft.setIngredients(Arrays.asList(SpellZen.toStacks(ingredients)));
        newCraft.setIncenses(Arrays.asList(SpellZen.toStacks(incenses)));
        RitualManager.addRitual(newCraft);
    }

    @Optional.Method(modid="crafttweaker")
    @ZenMethod
    public static void setPrimaryColor(String name, double r, double g, double b) {
        RitualBase found = RitualZen.findRitualByName(name);
        found.setPrimaryColor(r, g, b);
    }

    @Optional.Method(modid="crafttweaker")
    @ZenMethod
    public static void setSecondaryColor(String name, double r, double g, double b) {
        RitualBase found = RitualZen.findRitualByName(name);
        found.setSecondaryColor(r, g, b);
    }

    @Optional.Method(modid="crafttweaker")
    @ZenMethod
    public static void setLevel(String name, int level) {
        RitualBase found = RitualZen.findRitualByName(name);
        found.setLevel(level);
    }

    @Optional.Method(modid="crafttweaker")
    @ZenMethod
    public static void setRitualIngredients(String name, IItemStack[] items) {
        RitualBase found = RitualZen.findRitualByName(name);
        Roots.logger.info("[ZenScript:Ritual] changing ingredients " + found.getName());
        found.setIngredients(Arrays.asList(SpellZen.toStacks(items)));
    }

    @Optional.Method(modid="crafttweaker")
    @ZenMethod
    public static void setRitualIncense(String name, IItemStack[] items) {
        RitualBase found = RitualZen.findRitualByName(name);
        Roots.logger.info("[ZenScript:Ritual] changing incense " + found.getName());
        found.setIncenses(Arrays.asList(SpellZen.toStacks(items)));
    }

    private static RitualBase findRitualByName(String name) {
        RitualBase found = RitualManager.getRitualFromName(name);
        if (found == null) {
            String names = "";
            for (RitualBase c : RitualManager.rituals) {
                names = names + c.getName() + ",";
            }
            Roots.logger.info(names);
            throw new IllegalArgumentException("Invalid ritual[" + name + "], names must be one of: " + names);
        }
        return found;
    }
}

