/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import elucent.rootsclassic.Roots;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.component.ComponentRecipe;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rootsclassic.Spell")
@ZenRegister
public class SpellZen {
    @Optional.Method(modid="crafttweaker")
    @ZenMethod
    public static void setSpellItems(String name, IItemStack[] items) {
        if (items.length == 0 || items.length > 4) {
            throw new IllegalArgumentException("Invalid spell ingredients, must be in range [1,4]");
        }
        ComponentRecipe found = SpellZen.findSpellByName(name);
        Roots.logger.info("[ZenScript:Spell] changing recipe " + found.getLocalizedName());
        found.setMaterials(Arrays.asList(SpellZen.toStacks(items)));
    }

    private static ComponentRecipe findSpellByName(String name) {
        ComponentRecipe found = ComponentManager.getSpellFromName(name);
        if (found == null) {
            String names = "";
            for (ComponentRecipe c : ComponentManager.recipes) {
                names = names + c.getEffectResult() + ",";
            }
            throw new IllegalArgumentException("Invalid spell [" + name + "], names must be one of: " + names);
        }
        return found;
    }

    @Optional.Method(modid="crafttweaker")
    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)internal;
    }

    @Optional.Method(modid="crafttweaker")
    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = SpellZen.toStack(iStack[i]);
        }
        return output;
    }
}

