/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.component;

import elucent.rootsclassic.RegistryManager;
import elucent.rootsclassic.Roots;
import elucent.rootsclassic.Util;
import elucent.rootsclassic.item.ItemDustPetal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ComponentRecipe {
    private String effectResult = "";
    private List<ItemStack> materials = new ArrayList<ItemStack>();
    private boolean disabled = false;
    private boolean needsMixin = true;

    public ComponentRecipe(String result) {
        this.setEffectResult(result);
    }

    public String getLocalizedName() {
        return Roots.lang("roots.component." + this.getEffectResult() + ".name");
    }

    public String toString() {
        String s = this.getLocalizedName() + ": ";
        for (ItemStack mat : this.getMaterials()) {
            s = s + mat.func_82833_r() + " ";
        }
        return s;
    }

    public static int getModifierCapacity(List<ItemStack> items) {
        int maxCapacity = -1;
        for (ItemStack it : items) {
            if (it.func_77973_b() == RegistryManager.oldRoot && maxCapacity < 0) {
                maxCapacity = 0;
            }
            if (it.func_77973_b() == RegistryManager.verdantSprig && maxCapacity < 1) {
                maxCapacity = 1;
            }
            if (it.func_77973_b() == RegistryManager.infernalStem && maxCapacity < 2) {
                maxCapacity = 2;
            }
            if (it.func_77973_b() != RegistryManager.dragonsEye || maxCapacity >= 3) continue;
            maxCapacity = 3;
        }
        return maxCapacity;
    }

    public ComponentRecipe addIngredient(ItemStack stack) {
        this.materials.add(stack);
        return this;
    }

    public static int getModifierCount(List<ItemStack> items) {
        int count = 0;
        for (ItemStack it : items) {
            if (it.func_77973_b() == Items.field_151114_aO) {
                ++count;
                continue;
            }
            if (it.func_77973_b() == Items.field_151137_ax) {
                ++count;
                continue;
            }
            if (it.func_77973_b() != Items.field_151016_H) continue;
            ++count;
        }
        return count;
    }

    public boolean matches(List<ItemStack> items) {
        ArrayList<ItemStack> tempItems = new ArrayList<ItemStack>();
        for (ItemStack stackIn : items) {
            if (stackIn.func_190926_b() || this.isSupplimentItem(stackIn)) continue;
            tempItems.add(stackIn);
        }
        for (int i = 0; i < this.materials.size(); ++i) {
            ItemStack input;
            if (i >= tempItems.size()) {
                return false;
            }
            ItemStack mat = this.materials.get(i);
            if (Util.oreDictMatches(mat, input = (ItemStack)tempItems.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isSupplimentItem(ItemStack it) {
        return it.func_77973_b() == RegistryManager.oldRoot || it.func_77973_b() == RegistryManager.verdantSprig || it.func_77973_b() == RegistryManager.infernalStem || it.func_77973_b() == RegistryManager.dragonsEye || it.func_77973_b() == Items.field_151114_aO || it.func_77973_b() == Items.field_151137_ax || it.func_77973_b() == Items.field_151016_H;
    }

    public String getEffectResult() {
        return this.effectResult;
    }

    public void setEffectResult(String effectResult) {
        this.effectResult = effectResult;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public List<ItemStack> getMaterials() {
        return this.materials;
    }

    public void setMaterials(List<ItemStack> materials) {
        this.materials = materials;
    }

    public ItemStack getRecipeResult(List<ItemStack> inventory) {
        ItemStack drop = new ItemStack(RegistryManager.dustPetal);
        ItemDustPetal.createData(drop, this.getEffectResult(), inventory);
        return drop;
    }

    public boolean needsMixin() {
        return this.needsMixin;
    }

    public void setNeedsMixin(boolean mix) {
        this.needsMixin = mix;
    }
}

