/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.config;

import elucent.rootsclassic.event.EventComponentSpells;
import elucent.rootsclassic.item.ItemDruidKnife;
import elucent.rootsclassic.item.ItemStaff;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigManager {
    public static int oldRootDropChance;
    public static int verdantSprigDropChance;
    public static int infernalStemDropChance;
    public static int dragonsEyeDropChance;
    public static int berriesDropChance;
    public static boolean showTabletWave;
    public static int chargeTicks;
    public static int staffUses;
    public static int efficiencyBonus;
    public static int manaBarOffset;
    public static boolean disablePVP;
    private static Configuration config;

    public static void load(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        ConfigManager.syncAllConfig();
    }

    public static void syncAllConfig() {
        String category = "rootsclassic.client";
        config.addCustomCategoryComment(category, "Settings that affect clientside graphical preferences.");
        manaBarOffset = config.getInt("manaBarOffset", category, 49, 0, Short.MAX_VALUE, "The number of pixels above the bottom of the screen that the mana bar should be rendered. If it's conflicting with a bar from another mod, raising it by 10 will normally position it right.");
        showTabletWave = config.getBoolean("showTabletWave", category, true, "Toggles the wave effect in the Runic Tablet GUI.");
        category = "rootsclassic.items";
        config.addCustomCategoryComment(category, "Settings related to actual gameplay-affecting features.");
        oldRootDropChance = config.getInt("oldRootDropChance", category, 40, 0, Short.MAX_VALUE, "Old Roots will drop from tall grass with a 1/oldRootDropChance probability.");
        verdantSprigDropChance = config.getInt("verdantSprigDropChance", category, 30, 0, Short.MAX_VALUE, "Verdant Sprigs will drop from grown crops with a 1/verdantSprigDropChance probability.");
        infernalStemDropChance = config.getInt("infernalBulbDropChance", category, 20, 0, Short.MAX_VALUE, "Infernal Bulbs will drop from nether wart with a 1/infernalBulbDropChance probability.");
        dragonsEyeDropChance = config.getInt("dragonsEyeDropChance", category, 10, 0, Short.MAX_VALUE, "Dragon's Eyes will drop from chorus flowers with a 1/dragonsEyeDropChance probability.");
        berriesDropChance = config.getInt("berriesDropChance", category, 25, 0, Short.MAX_VALUE, "Berries will drop from oak leaves with a 1/berriesDropChance probability.");
        ItemDruidKnife.BLOCK_DESTROY_ODDS = config.getFloat("barkKnifeBlockDestroyChance", category, 0.3f, 0.1f, 1.0f, "Chance that the bark knife will destroy the log, 1 is always destroy on first harvest. ");
        category = "rootsclassic.magic";
        chargeTicks = config.getInt("staffChargeTicks", category, 20, 1, Short.MAX_VALUE, "The number of ticks required to prepare a spell with a staff.");
        staffUses = config.getInt("staffUses", category, 65, 0, Short.MAX_VALUE, "The number of uses an unmodified staff will have upon being crafted.");
        efficiencyBonus = config.getInt("efficiencyBonusUses", category, 32, 0, Short.MAX_VALUE, "The number of additional uses each efficiency modifier gives.");
        disablePVP = config.getBoolean("disablePVP", category, false, "Whether or not damaging spells can affect players.");
        EventComponentSpells.TICKS_PER_MANA_REGEN = config.getInt("ticksPerManaRegen", category, 15, 1, 100, "Number of ticks between each mana regeneration (20 ticks = 1 second).");
        ItemStaff.MAX_USES_BASE = config.getInt("staffUsesBasic", category, 15, 1, 100, "Number of basic uses for one spell staff.");
        ItemStaff.MAX_USES_PER_EFFICIENCY = config.getInt("staffUsesEfficiency", category, 15, 1, 100, "Number of uses added by each efficiency level on a spell .");
        config.save();
    }

    public static Configuration getConfig() {
        return config;
    }
}

