/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.event;

import elucent.rootsclassic.Const;
import elucent.rootsclassic.RegistryManager;
import elucent.rootsclassic.Util;
import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventComponentSpells {
    private static final String NBT_THORNS = "RMOD_thornsDamage";
    private static final String NBT_VULN = "RMOD_vuln";
    private static final String NBT_DONT_DROP = "RMOD_dropItems";
    private static final String NBT_SKIP_TICKS = "RMOD_skipTicks";
    public static int TICKS_PER_MANA_REGEN = 5;

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            this.druidArmorRegenFullset((EntityPlayer)entity);
            this.tickManaRegen(entity);
        }
        this.tickSkipMovementCurse(event, entity);
    }

    private void tickSkipMovementCurse(LivingEvent.LivingUpdateEvent event, EntityLivingBase entity) {
        if (entity.getEntityData().func_74764_b("RMOD_trackTicks") && entity.getEntityData().func_74764_b(NBT_SKIP_TICKS) && entity.getEntityData().func_74762_e(NBT_SKIP_TICKS) > 0) {
            entity.getEntityData().func_74768_a(NBT_SKIP_TICKS, entity.getEntityData().func_74762_e(NBT_SKIP_TICKS) - 1);
            if (entity.getEntityData().func_74762_e(NBT_SKIP_TICKS) <= 0) {
                entity.getEntityData().func_82580_o(NBT_SKIP_TICKS);
                Util.decrementTickTracking((Entity)entity);
            }
            event.setCanceled(true);
        }
    }

    private void tickManaRegen(EntityLivingBase entity) {
        if (entity.field_70173_aa % TICKS_PER_MANA_REGEN == 0 && entity.hasCapability(RootsCapabilityManager.manaCapability, null)) {
            ((IManaCapability)entity.getCapability(RootsCapabilityManager.manaCapability, null)).setMana(((IManaCapability)entity.getCapability(RootsCapabilityManager.manaCapability, null)).getMana() + 1.0f);
        }
    }

    private void druidArmorRegenFullset(EntityPlayer entity) {
        ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
        if (head.func_77973_b() == RegistryManager.druidArmorHead && chest.func_77973_b() == RegistryManager.druidArmorChest && legs.func_77973_b() == RegistryManager.druidArmorLegs && feet.func_77973_b() == RegistryManager.druidArmorBoots && entity.field_70170_p.field_73012_v.nextDouble() < 0.02 && entity.func_110143_aJ() < entity.func_110138_aP()) {
            entity.func_70691_i(1.0f);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntityLiving().getEntityData().func_74764_b(NBT_DONT_DROP) && !event.getEntityLiving().getEntityData().func_74767_n(NBT_DONT_DROP)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingXP(LivingExperienceDropEvent event) {
        if (event.getEntityLiving().getEntityData().func_74764_b(NBT_DONT_DROP) && !event.getEntityLiving().getEntityData().func_74767_n(NBT_DONT_DROP)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        ItemStack sword;
        EntityPlayer player;
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving.getEntityData().func_74764_b(NBT_VULN)) {
            event.setAmount((float)((double)event.getAmount() * (1.0 + entityLiving.getEntityData().func_74769_h(NBT_VULN))));
            entityLiving.getEntityData().func_82580_o(NBT_VULN);
        }
        if (entityLiving.getEntityData().func_74764_b(NBT_THORNS) && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            ((EntityLivingBase)event.getSource().func_76346_g()).func_70097_a(DamageSource.field_76367_g, entityLiving.getEntityData().func_74760_g(NBT_THORNS));
            entityLiving.getEntityData().func_82580_o(NBT_THORNS);
            Util.decrementTickTracking((Entity)entityLiving);
        }
        if (entityLiving instanceof EntityPlayer) {
            player = (EntityPlayer)entityLiving;
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == RegistryManager.engravedSword && (sword = player.field_71071_by.func_70448_g()).func_77942_o() && sword.func_77978_p().func_74764_b("shadowstep")) {
                int stepLvl = sword.func_77978_p().func_74762_e("shadowstep");
                double chance = (double)stepLvl * 12.5;
                if ((double)player.func_130014_f_().field_73012_v.nextInt(100) < chance) {
                    event.setCanceled(true);
                }
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !event.getEntity().func_130014_f_().field_72995_K) {
            player = (EntityPlayer)event.getSource().func_76346_g();
            if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == RegistryManager.engravedSword) {
                float currentAmount;
                sword = player.field_71071_by.func_70448_g();
                if (sword.func_77942_o() && sword.func_77978_p().func_74764_b("aquatic")) {
                    int aquaLvl = sword.func_77978_p().func_74762_e("aquatic");
                    float amount = (float)aquaLvl * 0.5f;
                    event.getEntity().func_70097_a(DamageSource.field_76369_e, amount);
                }
                if (sword.func_77942_o() && sword.func_77978_p().func_74764_b("holy") && entityLiving.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                    int holyLvl = sword.func_77978_p().func_74762_e("holy");
                    float amount = (float)holyLvl * 1.5f;
                    currentAmount = event.getAmount();
                    event.setAmount(currentAmount + amount);
                }
                if (sword.func_77942_o() && sword.func_77978_p().func_74764_b("spikes")) {
                    int spikeLvl = sword.func_77978_p().func_74762_e("spikes");
                    float amount = spikeLvl;
                    currentAmount = event.getAmount();
                    event.setAmount(currentAmount + amount);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        event.getMap().func_174942_a(Const.magicParticle);
    }
}

