/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.Util;
import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.component.EnumCastType;
import elucent.rootsclassic.item.IManaRelatedItem;
import elucent.rootsclassic.item.ItemDruidRobes;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCrystalStaff
extends Item
implements IManaRelatedItem {
    Random random = new Random();

    public ItemCrystalStaff() {
        this.func_77625_d(1);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        if (timeLeft < 71988 && stack.func_77942_o()) {
            EntityPlayer pl = (EntityPlayer)player;
            ComponentBase comp = ComponentManager.getComponentFromName(ItemCrystalStaff.getEffect(stack));
            if (comp == null || !pl.hasCapability(RootsCapabilityManager.manaCapability, null)) {
                return;
            }
            int potency = ItemCrystalStaff.getPotency(stack) + 1;
            int efficiency = ItemCrystalStaff.getEfficiency(stack);
            int size = ItemCrystalStaff.getSize(stack);
            if (pl.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemDruidRobes && pl.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemDruidRobes && pl.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemDruidRobes && pl.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemDruidRobes) {
                ++potency;
            }
            Random random = new Random();
            IManaCapability manaCap = (IManaCapability)pl.getCapability(RootsCapabilityManager.manaCapability, null);
            if (manaCap.getMana() >= comp.getManaCost() / (float)(efficiency + 1)) {
                manaCap.setMana(manaCap.getMana() - comp.getManaCost() / (float)(efficiency + 1));
                comp.doEffect(world, (Entity)player, EnumCastType.SPELL, player.field_70165_t + 3.0 * player.func_70040_Z().field_72450_a, player.field_70163_u + 3.0 * player.func_70040_Z().field_72448_b, player.field_70161_v + 3.0 * player.func_70040_Z().field_72449_c, potency, efficiency, 3.0 + 2.0 * (double)size);
                for (int i = 0; i < 90; ++i) {
                    double offX = (double)random.nextFloat() * 0.5 - 0.25;
                    double offY = (double)random.nextFloat() * 0.5 - 0.25;
                    double offZ = (double)random.nextFloat() * 0.5 - 0.25;
                    double coeff = (offX + offY + offZ) / 1.5 + 0.5;
                    double dx = (player.func_70040_Z().field_72450_a + offX) * coeff;
                    double dy = (player.func_70040_Z().field_72448_b + offY) * coeff;
                    double dz = (player.func_70040_Z().field_72449_c + offZ) * coeff;
                    if (random.nextBoolean()) {
                        Roots.proxy.spawnParticleMagicFX(world, player.field_70165_t + dx, player.field_70163_u + 1.5 + dy, player.field_70161_v + dz, dx, dy, dz, comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c);
                        continue;
                    }
                    Roots.proxy.spawnParticleMagicFX(world, player.field_70165_t + dx, player.field_70163_u + 1.5 + dy, player.field_70161_v + dz, dx, dy, dz, comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77942_o() && !player.func_70093_af()) {
            if (world.field_72995_K && Minecraft.func_71410_x().field_71462_r != null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74768_a("selected", stack.func_77978_p().func_74762_e("selected") + 1);
            if (stack.func_77978_p().func_74762_e("selected") > 4) {
                stack.func_77978_p().func_74768_a("selected", 1);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldS, ItemStack newS, boolean slotChanged) {
        if (oldS.func_77942_o() && newS.func_77942_o() && (ItemCrystalStaff.getEffect(oldS) != ItemCrystalStaff.getEffect(newS) || oldS.func_77978_p().func_74762_e("selected") != newS.func_77978_p().func_74762_e("selected") || slotChanged)) {
            return true;
        }
        return slotChanged;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (stack.func_77942_o()) {
            ComponentBase comp = ComponentManager.getComponentFromName(stack.func_77978_p().func_74779_i("effect"));
            int potency = stack.func_77978_p().func_74762_e("potency");
            int efficiency = stack.func_77978_p().func_74762_e("efficiency");
            int size = stack.func_77978_p().func_74762_e("size");
            if (comp != null) {
                comp.castingAction((EntityPlayer)player, count, potency, efficiency, size);
                if (this.random.nextBoolean()) {
                    Roots.proxy.spawnParticleMagicLineFX(player.func_130014_f_(), player.field_70165_t + 2.0 * ((double)this.random.nextFloat() - 0.5), player.field_70163_u + 2.0 * ((double)this.random.nextFloat() - 0.5) + 1.0, player.field_70161_v + 2.0 * ((double)this.random.nextFloat() - 0.5), player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicLineFX(player.func_130014_f_(), player.field_70165_t + 2.0 * ((double)this.random.nextFloat() - 0.5), player.field_70163_u + 2.0 * ((double)this.random.nextFloat() - 0.5) + 1.0, player.field_70161_v + 2.0 * ((double)this.random.nextFloat() - 0.5), player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c);
                }
            }
        }
    }

    public static void createData(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("selected", 1);
        stack.func_77978_p().func_74768_a("potency1", 0);
        stack.func_77978_p().func_74768_a("potency2", 0);
        stack.func_77978_p().func_74768_a("potency3", 0);
        stack.func_77978_p().func_74768_a("potency4", 0);
        stack.func_77978_p().func_74768_a("efficiency1", 0);
        stack.func_77978_p().func_74768_a("efficiency2", 0);
        stack.func_77978_p().func_74768_a("efficiency3", 0);
        stack.func_77978_p().func_74768_a("efficiency4", 0);
        stack.func_77978_p().func_74768_a("size1", 0);
        stack.func_77978_p().func_74768_a("size2", 0);
        stack.func_77978_p().func_74768_a("size3", 0);
        stack.func_77978_p().func_74768_a("size4", 0);
        stack.func_77978_p().func_74778_a("effect1", "");
        stack.func_77978_p().func_74778_a("effect2", "");
        stack.func_77978_p().func_74778_a("effect3", "");
        stack.func_77978_p().func_74778_a("effect4", "");
    }

    public static void addEffect(ItemStack stack, int slot, String effect, int potency, int efficiency, int size) {
        stack.func_77978_p().func_74778_a("effect" + slot, effect);
        stack.func_77978_p().func_74768_a("potency" + slot, potency);
        stack.func_77978_p().func_74768_a("efficiency" + slot, efficiency);
        stack.func_77978_p().func_74768_a("size" + slot, size);
    }

    public static Integer getPotency(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("potency" + stack.func_77978_p().func_74762_e("selected"));
        }
        return 0;
    }

    public static Integer getEfficiency(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("efficiency" + stack.func_77978_p().func_74762_e("selected"));
        }
        return 0;
    }

    public static Integer getSize(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("size" + stack.func_77978_p().func_74762_e("selected"));
        }
        return 0;
    }

    public static String getEffect(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("effect" + stack.func_77978_p().func_74762_e("selected"));
        }
        return null;
    }

    public static String getEffect(ItemStack stack, int slot) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("effect" + slot);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        ComponentBase comp;
        if (stack.func_77942_o() && (comp = ComponentManager.getComponentFromName(ItemCrystalStaff.getEffect(stack))) != null) {
            tooltip.add(TextFormatting.GOLD + Roots.lang("roots.tooltip.spelltypeheading.name") + ": " + comp.getTextColor() + comp.getEffectName());
            tooltip.add(TextFormatting.RED + "  +" + ItemCrystalStaff.getPotency(stack) + " " + Roots.lang("roots.tooltip.spellpotency.name") + ".");
            tooltip.add(TextFormatting.RED + "  +" + ItemCrystalStaff.getEfficiency(stack) + " " + Roots.lang("roots.tooltip.spellefficiency.name") + ".");
            tooltip.add(TextFormatting.RED + "  +" + ItemCrystalStaff.getSize(stack) + " " + Roots.lang("roots.tooltip.spellsize.name") + ".");
        }
    }

    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int layer) {
            if (stack.func_77942_o()) {
                ComponentBase comp;
                if (layer == 2 && (comp = ComponentManager.getComponentFromName(ItemCrystalStaff.getEffect(stack))) != null) {
                    return Util.intColor((int)comp.primaryColor.field_72450_a, (int)comp.primaryColor.field_72448_b, (int)comp.primaryColor.field_72449_c);
                }
                if (layer == 1 && (comp = ComponentManager.getComponentFromName(ItemCrystalStaff.getEffect(stack))) != null) {
                    return Util.intColor((int)comp.secondaryColor.field_72450_a, (int)comp.secondaryColor.field_72448_b, (int)comp.secondaryColor.field_72449_c);
                }
            }
            return Util.intColor(255, 255, 255);
        }
    }
}

