/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.Util;
import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.component.EnumCastType;
import elucent.rootsclassic.item.IManaRelatedItem;
import elucent.rootsclassic.item.ItemDruidRobes;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStaff
extends Item
implements IManaRelatedItem {
    private static final String NBT_EFFICIENCY = "efficiency";
    private static final String NBT_SIZE = "size";
    private static final String NBT_POT = "potency";
    private static final String NBT_EFFECT = "effect";
    private static final String NBT_USES = "uses";
    private static final String NBT_MAX = "maxUses";
    public static int MAX_USES_PER_EFFICIENCY = 32;
    public static int MAX_USES_BASE = 65;
    private static double RANGE = 3.0;
    private static double SIZE_PER_LEVEL = 2.0;
    private static double SIZE_BASE = 3.0;
    Random random = new Random();

    public ItemStaff() {
        this.func_77625_d(1);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o()) {
            return 1.0 - (double)stack.func_77978_p().func_74762_e(NBT_USES) / (double)stack.func_77978_p().func_74762_e(NBT_MAX);
        }
        return 1.0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e(NBT_USES) < stack.func_77978_p().func_74762_e(NBT_MAX);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase caster, int timeLeft) {
        NBTTagCompound stackTags;
        if (timeLeft < 71988 && stack.func_77942_o() && caster.hasCapability(RootsCapabilityManager.manaCapability, null) && (stackTags = stack.func_77978_p()).func_74762_e(NBT_USES) >= 0) {
            IManaCapability manaCap;
            stackTags.func_74768_a(NBT_USES, stackTags.func_74762_e(NBT_USES) - 1);
            ComponentBase comp = ComponentManager.getComponentFromName(stackTags.func_74779_i(NBT_EFFECT));
            int potency = stackTags.func_74762_e(NBT_POT);
            int efficiency = stackTags.func_74762_e(NBT_EFFICIENCY);
            int size = stackTags.func_74762_e(NBT_SIZE);
            EntityPlayer player = (EntityPlayer)caster;
            if (player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemDruidRobes && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemDruidRobes && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemDruidRobes && player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemDruidRobes) {
                ++potency;
            }
            if ((manaCap = (IManaCapability)player.getCapability(RootsCapabilityManager.manaCapability, null)).getMana() >= comp.getManaCost() / (float)(efficiency + 1)) {
                manaCap.setMana(manaCap.getMana() - comp.getManaCost() / (float)(efficiency + 1));
                Vec3d lookVec = caster.func_70040_Z();
                comp.doEffect(world, (Entity)caster, EnumCastType.SPELL, caster.field_70165_t + RANGE * lookVec.field_72450_a, caster.field_70163_u + RANGE * lookVec.field_72448_b, caster.field_70161_v + RANGE * lookVec.field_72449_c, potency, efficiency, SIZE_BASE + SIZE_PER_LEVEL * (double)size);
                for (int i = 0; i < 90; ++i) {
                    double offX = (double)world.field_73012_v.nextFloat() * 0.5 - 0.25;
                    double offY = (double)world.field_73012_v.nextFloat() * 0.5 - 0.25;
                    double offZ = (double)world.field_73012_v.nextFloat() * 0.5 - 0.25;
                    double coeff = (offX + offY + offZ) / 1.5 + 0.5;
                    double dx = (lookVec.field_72450_a + offX) * coeff;
                    double dy = (lookVec.field_72448_b + offY) * coeff;
                    double dz = (lookVec.field_72449_c + offZ) * coeff;
                    if (world.field_73012_v.nextBoolean()) {
                        Roots.proxy.spawnParticleMagicFX(world, caster.field_70165_t + dx, caster.field_70163_u + 1.5 + dy, caster.field_70161_v + dz, dx, dy, dz, comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c);
                        continue;
                    }
                    Roots.proxy.spawnParticleMagicFX(world, caster.field_70165_t + dx, caster.field_70163_u + 1.5 + dy, caster.field_70161_v + dz, dx, dy, dz, comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K && Minecraft.func_71410_x().field_71462_r != null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e(NBT_USES) <= 0 && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldS, ItemStack newS, boolean slotChanged) {
        if (oldS.func_77942_o() && newS.func_77942_o() && oldS.func_77978_p().func_74779_i(NBT_EFFECT) != newS.func_77978_p().func_74779_i(NBT_EFFECT)) {
            return true;
        }
        return slotChanged;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (stack.func_77942_o()) {
            ComponentBase comp = ComponentManager.getComponentFromName(stack.func_77978_p().func_74779_i(NBT_EFFECT));
            int potency = stack.func_77978_p().func_74762_e(NBT_POT);
            int efficiency = stack.func_77978_p().func_74762_e(NBT_EFFICIENCY);
            int size = stack.func_77978_p().func_74762_e(NBT_SIZE);
            if (comp != null) {
                comp.castingAction((EntityPlayer)player, count, potency, efficiency, size);
                if (this.random.nextBoolean()) {
                    Roots.proxy.spawnParticleMagicLineFX(player.func_130014_f_(), player.field_70165_t + 2.0 * ((double)this.random.nextFloat() - 0.5), player.field_70163_u + 2.0 * ((double)this.random.nextFloat() - 0.5) + 1.0, player.field_70161_v + 2.0 * ((double)this.random.nextFloat() - 0.5), player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c);
                } else {
                    Roots.proxy.spawnParticleMagicLineFX(player.func_130014_f_(), player.field_70165_t + 2.0 * ((double)this.random.nextFloat() - 0.5), player.field_70163_u + 2.0 * ((double)this.random.nextFloat() - 0.5) + 1.0, player.field_70161_v + 2.0 * ((double)this.random.nextFloat() - 0.5), player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c);
                }
            }
        }
    }

    public static void createData(ItemStack stack, String effect, int potency, int efficiency, int size) {
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a(NBT_EFFECT, effect);
        stack.func_77978_p().func_74768_a(NBT_POT, potency);
        stack.func_77978_p().func_74768_a(NBT_EFFICIENCY, efficiency);
        stack.func_77978_p().func_74768_a(NBT_SIZE, size);
        int uses = MAX_USES_BASE + MAX_USES_PER_EFFICIENCY * efficiency;
        stack.func_77978_p().func_74768_a(NBT_MAX, uses);
        stack.func_77978_p().func_74768_a(NBT_USES, uses);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            ComponentBase comp = ComponentManager.getComponentFromName(tagCompound.func_74779_i(NBT_EFFECT));
            tooltip.add(TextFormatting.GOLD + Roots.lang("roots.tooltip.spelltypeheading.name") + ": " + comp.getTextColor() + comp.getEffectName());
            tooltip.add(TextFormatting.RED + "  +" + tagCompound.func_74762_e(NBT_POT) + " " + Roots.lang("roots.tooltip.spellpotency.name") + ".");
            tooltip.add(TextFormatting.RED + "  +" + tagCompound.func_74762_e(NBT_EFFICIENCY) + " " + Roots.lang("roots.tooltip.spellefficiency.name") + ".");
            tooltip.add(TextFormatting.RED + "  +" + tagCompound.func_74762_e(NBT_SIZE) + " " + Roots.lang("roots.tooltip.spellsize.name") + ".");
            tooltip.add("");
            tooltip.add(TextFormatting.GOLD + Integer.toString(tagCompound.func_74762_e(NBT_USES)) + " " + Roots.lang("roots.tooltip.usesremaining.name") + ".");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_0", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_1", "inventory"));
    }

    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int layer) {
            if (stack.func_77942_o() && stack.func_77973_b() instanceof ItemStaff) {
                if (layer == 2) {
                    ComponentBase comp = ComponentManager.getComponentFromName(stack.func_77978_p().func_74779_i(ItemStaff.NBT_EFFECT));
                    return Util.intColor((int)comp.primaryColor.field_72450_a, (int)comp.primaryColor.field_72448_b, (int)comp.primaryColor.field_72449_c);
                }
                if (layer == 1) {
                    ComponentBase comp = ComponentManager.getComponentFromName(stack.func_77978_p().func_74779_i(ItemStaff.NBT_EFFECT));
                    return Util.intColor((int)comp.secondaryColor.field_72450_a, (int)comp.secondaryColor.field_72448_b, (int)comp.secondaryColor.field_72449_c);
                }
            }
            return Util.intColor(255, 255, 255);
        }
    }
}

