/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.ritual;

import elucent.rootsclassic.RegistryManager;
import elucent.rootsclassic.Roots;
import elucent.rootsclassic.Util;
import elucent.rootsclassic.block.brazier.TileEntityBrazier;
import elucent.rootsclassic.ritual.RitualManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class RitualBase {
    private static final int RADIUS = 4;
    private ArrayList<Block> blocks = new ArrayList();
    private ArrayList<BlockPos> positionsRelative = new ArrayList();
    private List<ItemStack> incenses = new ArrayList<ItemStack>();
    private List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private Vec3d color = new Vec3d(255.0, 255.0, 255.0);
    private Vec3d secondaryColor = new Vec3d(255.0, 255.0, 255.0);
    private String name = "";
    private int level;

    public RitualBase(String parName, int level, double r, double g, double b) {
        if (RitualManager.getRitualFromName(this.name) != null) {
            throw new IllegalArgumentException("No duplicate names for rituals");
        }
        this.name = parName;
        this.setPrimaryColor(r, g, b);
        this.setSecondaryColor(r, g, b);
        this.setLevel(level);
    }

    public void setLevel(int level) {
        if (level < 0 || level > 2) {
            throw new IllegalArgumentException("Level must be 0, 1 or 2");
        }
        this.blocks = new ArrayList();
        this.level = level;
        if (level == 1 || level == 2) {
            this.addRitualPillar(RegistryManager.standingStoneT1, -3, 0, -3);
            this.addRitualPillar(RegistryManager.standingStoneT1, -3, 0, 3);
            this.addRitualPillar(RegistryManager.standingStoneT1, 3, 0, -3);
            this.addRitualPillar(RegistryManager.standingStoneT1, 3, 0, 3);
            this.addRitualPillar(RegistryManager.standingStoneT1, 3, 0, 0);
            this.addRitualPillar(RegistryManager.standingStoneT1, -3, 0, 0);
            this.addRitualPillar(RegistryManager.standingStoneT1, 0, 0, 3);
            this.addRitualPillar(RegistryManager.standingStoneT1, 0, 0, -3);
        } else if (level == 2) {
            this.addRitualPillar(RegistryManager.standingStoneT2, 5, 1, 0);
            this.addRitualPillar(RegistryManager.standingStoneT2, -5, 1, 0);
            this.addRitualPillar(RegistryManager.standingStoneT2, 0, 1, 5);
            this.addRitualPillar(RegistryManager.standingStoneT2, 0, 1, -5);
        }
    }

    public RitualBase addRitualPillar(Block b, int x, int y, int z) {
        this.getBlocks().add(b);
        this.getPositionsRelative().add(new BlockPos(x, y, z));
        return this;
    }

    public RitualBase addIngredient(ItemStack i) {
        this.getIngredients().add(i);
        return this;
    }

    public RitualBase addIncense(ItemStack i) {
        this.getIncenses().add(i);
        return this;
    }

    public boolean doIngredientsMatch(RitualBase ritual) {
        return Util.itemListsMatch(this.getIngredients(), ritual.getIngredients());
    }

    public abstract void doEffect(World var1, BlockPos var2, List<ItemStack> var3, List<ItemStack> var4);

    public boolean verifyPositionBlocks(World world, BlockPos pos) {
        if (this.getPositionsRelative().size() > 0) {
            for (int i = 0; i < this.getPositionsRelative().size(); ++i) {
                BlockPos loopPos = this.getPositionsRelative().get(i);
                Block loopBlock = this.getBlocks().get(i);
                BlockPos loopPosOffset = pos.func_177982_a(loopPos.func_177958_n(), loopPos.func_177956_o(), loopPos.func_177952_p());
                if (world.func_180495_p(loopPosOffset).func_177230_c() == loopBlock) continue;
                Roots.logger.info(this.level + " level recipe has Missing block " + loopBlock + " at position " + loopPosOffset);
                return false;
            }
        }
        return true;
    }

    public List<TileEntityBrazier> getRecipeBraziers(World world, BlockPos pos) {
        ArrayList<TileEntityBrazier> links = new ArrayList<TileEntityBrazier>();
        for (int i = -4; i <= 4; ++i) {
            for (int j = -4; j <= 4; ++j) {
                TileEntity tileHere;
                if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() != RegistryManager.brazier || (tileHere = world.func_175625_s(pos.func_177982_a(i, 0, j))) == null || !(tileHere instanceof TileEntityBrazier)) continue;
                links.add((TileEntityBrazier)tileHere);
            }
        }
        return links;
    }

    public boolean incesceMatches(World world, BlockPos pos) {
        ArrayList<ItemStack> incenceFromNearby = new ArrayList<ItemStack>();
        List<TileEntityBrazier> braziers = this.getRecipeBraziers(world, pos);
        for (TileEntityBrazier brazier : braziers) {
            if (brazier.getHeldItem().func_190926_b()) continue;
            incenceFromNearby.add(brazier.getHeldItem());
        }
        return Util.itemListsMatch(this.getIncenses(), incenceFromNearby);
    }

    public String toString() {
        String s = "[A] ";
        for (ItemStack mat : this.getIngredients()) {
            s = s + mat.func_82833_r() + "; ";
        }
        s = s + System.lineSeparator() + "[I] ";
        for (ItemStack mat : this.getIncenses()) {
            s = s + mat.func_82833_r() + "; ";
        }
        return s;
    }

    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<ItemStack> ingredients) throws IllegalArgumentException {
        if (ingredients.size() == 0 || ingredients.size() > 3) {
            throw new IllegalArgumentException("Invalid ritual ingredients, must be in range [1,3]");
        }
        this.ingredients = ingredients;
    }

    public List<ItemStack> getIncenses() {
        return this.incenses;
    }

    public void setIncenses(List<ItemStack> incenses) throws IllegalArgumentException {
        if (incenses.size() == 0 || incenses.size() > 4) {
            throw new IllegalArgumentException("Invalid ritual incense, must be in range [1,4]");
        }
        this.incenses = incenses;
    }

    public ArrayList<BlockPos> getPositionsRelative() {
        return this.positionsRelative;
    }

    public void setPositionsRelative(ArrayList<BlockPos> positionsRelative) {
        this.positionsRelative = positionsRelative;
    }

    public ArrayList<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<Block> blocks) {
        this.blocks = blocks;
    }

    public Vec3d getColor() {
        return this.color;
    }

    public void setPrimaryColor(double r, double g, double b) {
        this.color = this.buildColor(r, g, b);
    }

    public Vec3d getSecondaryColor() {
        return this.secondaryColor;
    }

    public RitualBase setSecondaryColor(double r, double g, double b) {
        this.secondaryColor = this.buildColor(r, g, b);
        return this;
    }

    private Vec3d buildColor(double r, double g, double b) throws IllegalArgumentException {
        if (r < 0.0 || r > 255.0 || g < 0.0 || g > 255.0 || b < 0.0 || b > 255.0) {
            throw new IllegalArgumentException("Invalid colour value use [0, 255]");
        }
        return new Vec3d(r, g, b);
    }

    public String getName() {
        return this.name;
    }
}

