/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.ritual;

import elucent.rootsclassic.RegistryManager;
import elucent.rootsclassic.Roots;
import elucent.rootsclassic.Util;
import elucent.rootsclassic.block.altar.TileEntityAltar;
import elucent.rootsclassic.block.brazier.TileEntityBrazier;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.rituals.RitualCauseRain;
import elucent.rootsclassic.ritual.rituals.RitualCrafting;
import elucent.rootsclassic.ritual.rituals.RitualEngravedSword;
import elucent.rootsclassic.ritual.rituals.RitualFlare;
import elucent.rootsclassic.ritual.rituals.RitualGrow;
import elucent.rootsclassic.ritual.rituals.RitualImbuer;
import elucent.rootsclassic.ritual.rituals.RitualLifeDrain;
import elucent.rootsclassic.ritual.rituals.RitualMassBreed;
import elucent.rootsclassic.ritual.rituals.RitualSacrifice;
import elucent.rootsclassic.ritual.rituals.RitualSummoning;
import elucent.rootsclassic.ritual.rituals.RitualTimeShift;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualManager {
    public static ArrayList<RitualBase> rituals = new ArrayList();

    public static RitualBase findMatchingByIngredients(TileEntityAltar altar) {
        for (RitualBase ritual : rituals) {
            if (!Util.itemListsMatchWithSize(ritual.getIngredients(), altar.getInventory())) continue;
            return ritual;
        }
        return null;
    }

    public static void addRitual(RitualBase ritual) throws IllegalArgumentException {
        for (RitualBase existing : rituals) {
            if (!ritual.doIngredientsMatch(existing)) continue;
            Roots.logger.error("Duplicate ingredients are not allowed for incoming ritual : " + ritual.getName() + " and existing ritual " + existing.getName());
        }
        rituals.add(ritual);
    }

    public static void init() {
        RitualManager.addRitual(new RitualCrafting("staffCrafting", 2, 205.0, 86.0, 0.0).setResult(new ItemStack(RegistryManager.crystalStaff, 1)).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, -3).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, -3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, 0).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, 0).addRitualPillar(RegistryManager.standingStoneT1, 0, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 0, 0, -3).addIncense(new ItemStack(Blocks.field_150402_ci, 1)).addIncense(new ItemStack(RegistryManager.acaciaTreeBark, 1)).addIncense(new ItemStack(RegistryManager.verdantSprig, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIngredient(new ItemStack(Blocks.field_150484_ah, 1)).addIngredient(new ItemStack(Items.field_151055_y, 1)).addIngredient(new ItemStack(Items.field_151065_br, 1)));
        RitualManager.addRitual(new RitualCrafting("sylvanHoodCrafting", 2, 62.0, 138.0, 62.0).setResult(new ItemStack(RegistryManager.druidRobesHead, 1)).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, -3).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, -3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, 0).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, 0).addRitualPillar(RegistryManager.standingStoneT1, 0, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 0, 0, -3).addRitualPillar(RegistryManager.standingStoneT2, 5, 1, 0).addRitualPillar(RegistryManager.standingStoneT2, -5, 1, 0).addRitualPillar(RegistryManager.standingStoneT2, 0, 1, 5).addRitualPillar(RegistryManager.standingStoneT2, 0, 1, -5).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIncense(new ItemStack(Items.field_151153_ao, 1)).addIncense(new ItemStack((Block)Blocks.field_150328_O, 1, 0)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack((Item)Items.field_151024_Q, 1)).addIngredient(new ItemStack(Blocks.field_150395_bd, 1)));
        RitualManager.addRitual(new RitualCrafting("sylvanChestCrafting", 2, 62.0, 138.0, 62.0).setResult(new ItemStack(RegistryManager.druidRobesChest, 1)).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, -3).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, -3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 3, 0, 0).addRitualPillar(RegistryManager.standingStoneT1, -3, 0, 0).addRitualPillar(RegistryManager.standingStoneT1, 0, 0, 3).addRitualPillar(RegistryManager.standingStoneT1, 0, 0, -3).addRitualPillar(RegistryManager.standingStoneT2, 5, 1, 0).addRitualPillar(RegistryManager.standingStoneT2, -5, 1, 0).addRitualPillar(RegistryManager.standingStoneT2, 0, 1, 5).addRitualPillar(RegistryManager.standingStoneT2, 0, 1, -5).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIncense(new ItemStack(Items.field_151153_ao, 1)).addIncense(new ItemStack((Block)Blocks.field_150328_O, 1, 0)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack((Item)Items.field_151027_R, 1)).addIngredient(new ItemStack(Blocks.field_150395_bd, 1)));
        RitualManager.addRitual(new RitualCrafting("sylvanLegsCrafting", 2, 62.0, 138.0, 62.0).setResult(new ItemStack(RegistryManager.druidRobesLegs, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIncense(new ItemStack(Items.field_151153_ao, 1)).addIncense(new ItemStack((Block)Blocks.field_150328_O, 1, 0)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack((Item)Items.field_151026_S, 1)).addIngredient(new ItemStack(Blocks.field_150395_bd, 1)));
        RitualManager.addRitual(new RitualCrafting("sylvanBootsCrafting", 2, 62.0, 138.0, 62.0).setResult(new ItemStack(RegistryManager.druidRobesBoots, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIncense(new ItemStack(Items.field_151153_ao, 1)).addIncense(new ItemStack((Block)Blocks.field_150328_O, 1, 0)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack((Item)Items.field_151021_T, 1)).addIngredient(new ItemStack(Blocks.field_150395_bd, 1)));
        RitualManager.addRitual(new RitualCrafting("wildwoodHeadCrafting", 2, 145.0, 115.0, 65.0).setResult(new ItemStack(RegistryManager.druidArmorHead, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(Blocks.field_150345_g, 1, 0)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack((Item)Items.field_151028_Y, 1)).addIngredient(new ItemStack(Blocks.field_150344_f, 1, 0)));
        RitualManager.addRitual(new RitualCrafting("wildwoodChestCrafting", 2, 145.0, 115.0, 65.0).setResult(new ItemStack(RegistryManager.druidArmorChest, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(Blocks.field_150345_g, 1, 0)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack((Item)Items.field_151030_Z, 1)).addIngredient(new ItemStack(Blocks.field_150344_f, 1)));
        RitualManager.addRitual(new RitualCrafting("wildwoodLegsCrafting", 2, 145.0, 115.0, 65.0).setResult(new ItemStack(RegistryManager.druidArmorLegs, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(Blocks.field_150345_g, 1, 0)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack((Item)Items.field_151165_aa, 1)).addIngredient(new ItemStack(Blocks.field_150344_f, 1)));
        RitualManager.addRitual(new RitualCrafting("wildwoodBootsCrafting", 2, 145.0, 115.0, 65.0).setResult(new ItemStack(RegistryManager.druidArmorBoots, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(Blocks.field_150345_g, 1, 0)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack((Item)Items.field_151167_ab, 1)).addIngredient(new ItemStack(Blocks.field_150344_f, 1)));
        RitualManager.addRitual(new RitualCrafting("acceleratorStoneCrafting", 2, 0.0, 105.0, 73.0).setResult(new ItemStack(RegistryManager.standingStoneAccelerator, 1)).addIncense(new ItemStack(RegistryManager.verdantSprig, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(RegistryManager.jungleTreeBark, 1, 0)).addIngredient(new ItemStack(RegistryManager.standingStoneT2, 1)).addIngredient(new ItemStack(Items.field_151114_aO, 1)).addIngredient(new ItemStack(Blocks.field_150417_aV, 1, 0)));
        RitualManager.addRitual(new RitualCrafting("standingStone", 2, 0.0, 105.0, 73.0).setResult(new ItemStack(RegistryManager.standingStoneAesthetic, 1)).addIngredient(new ItemStack(RegistryManager.standingStoneT2, 1)).addIngredient(new ItemStack(Items.field_151114_aO, 1)).addIngredient(new ItemStack(Blocks.field_150417_aV, 1, 1)));
        RitualManager.addRitual(new RitualCrafting("entanglerStoneCrafting", 2, 0.0, 105.0, 73.0).setResult(new ItemStack(RegistryManager.standingStoneEntangler, 1)).addIncense(new ItemStack(RegistryManager.verdantSprig, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1, 0)).addIngredient(new ItemStack(RegistryManager.standingStoneT2, 1)).addIngredient(new ItemStack(Items.field_151114_aO, 1)).addIngredient(new ItemStack(Blocks.field_150417_aV, 1, 2)));
        RitualManager.addRitual(new RitualCrafting("growerStoneCrafting", 2, 0.0, 105.0, 73.0).setResult(new ItemStack(RegistryManager.standingStoneGrower, 1)).addIncense(new ItemStack(RegistryManager.verdantSprig, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1, 0)).addIngredient(new ItemStack(RegistryManager.standingStoneT2, 1)).addIngredient(new ItemStack(Items.field_151114_aO, 1)).addIngredient(new ItemStack(Blocks.field_150348_b, 1, 0)));
        RitualManager.addRitual(new RitualCrafting("healerStoneCrafting", 2, 0.0, 105.0, 73.0).setResult(new ItemStack(RegistryManager.standingStoneHealer, 1)).addIncense(new ItemStack(RegistryManager.verdantSprig, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(Items.field_151073_bk, 1, 0)).addIngredient(new ItemStack(RegistryManager.standingStoneT2)).addIngredient(new ItemStack(Items.field_151137_ax)).addIngredient(new ItemStack(Blocks.field_150417_aV, 1, 3)));
        RitualManager.addRitual(new RitualCrafting("igniterStoneCrafting", 2, 0.0, 105.0, 73.0).setResult(new ItemStack(RegistryManager.standingStoneIgniter, 1)).addIncense(new ItemStack(RegistryManager.verdantSprig, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(RegistryManager.acaciaTreeBark, 1, 0)).addIngredient(new ItemStack(RegistryManager.standingStoneT2, 1)).addIngredient(new ItemStack(Items.field_151137_ax, 1)).addIngredient(new ItemStack(Blocks.field_150417_aV, 1, 2)));
        RitualManager.addRitual(new RitualCrafting("repulsorStoneCrafting", 2, 0.0, 105.0, 73.0).setResult(new ItemStack(RegistryManager.standingStoneRepulsor, 1)).addIncense(new ItemStack(RegistryManager.verdantSprig, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(RegistryManager.spruceTreeBark, 1, 0)).addIngredient(new ItemStack(RegistryManager.standingStoneT2, 1)).addIngredient(new ItemStack(Items.field_151114_aO, 1)).addIngredient(new ItemStack(Blocks.field_150417_aV, 1, 3)));
        RitualManager.addRitual(new RitualCrafting("vacuumStoneCrafting", 2, 0.0, 105.0, 73.0).setResult(new ItemStack(RegistryManager.standingStoneVacuum, 1)).addIncense(new ItemStack(RegistryManager.verdantSprig, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(RegistryManager.darkOakTreeBark, 1, 0)).addIngredient(new ItemStack(RegistryManager.standingStoneT2, 1)).addIngredient(new ItemStack(Items.field_151114_aO, 1)).addIngredient(new ItemStack(Blocks.field_150385_bj)));
        RitualManager.addRitual(new RitualCrafting("runicFocusCrafting", 2, 109.0, 242.0, 109.0).setResult(new ItemStack(RegistryManager.runicFocus, 1, 0)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.spruceTreeBark, 1)).addIncense(new ItemStack(RegistryManager.acaciaTreeBark, 1)).addIncense(new ItemStack(RegistryManager.jungleTreeBark, 1)).addIngredient(new ItemStack(RegistryManager.verdantSprig, 1)).addIngredient(new ItemStack(Items.field_151045_i, 1)).addIngredient(new ItemStack(Blocks.field_150348_b, 1)));
        RitualManager.addRitual(new RitualCrafting("runicFocusCharging", 2, 109.0, 242.0, 109.0).setResult(new ItemStack(RegistryManager.runicFocus, 1, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIngredient(new ItemStack(RegistryManager.runicFocus, 1, 0)).addIngredient(new ItemStack(Items.field_151137_ax, 1)).addIngredient(new ItemStack(Items.field_151114_aO, 1)));
        RitualManager.addRitual(new RitualCrafting("livingPickaxeCrafting", 2, 146.0, 214.0, 43.0).setResult(new ItemStack(RegistryManager.livingPickaxe, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIngredient(new ItemStack(Items.field_151039_o, 1)).addIngredient(new ItemStack(RegistryManager.verdantSprig, 1)).addIngredient(new ItemStack(Items.field_151074_bl)));
        RitualManager.addRitual(new RitualCrafting("livingAxeCrafting", 2, 146.0, 214.0, 43.0).setResult(new ItemStack(RegistryManager.livingAxe, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIngredient(new ItemStack(Items.field_151053_p, 1)).addIngredient(new ItemStack(RegistryManager.verdantSprig, 1)).addIngredient(new ItemStack(Items.field_151074_bl, 1)));
        RitualManager.addRitual(new RitualCrafting("livingSwordCrafting", 2, 146.0, 214.0, 43.0).setResult(new ItemStack(RegistryManager.livingSword, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIngredient(new ItemStack(Items.field_151041_m, 1)).addIngredient(new ItemStack(RegistryManager.verdantSprig, 1)).addIngredient(new ItemStack(Items.field_151074_bl, 1)));
        RitualManager.addRitual(new RitualCrafting("livingHoeCrafting", 2, 146.0, 214.0, 43.0).setResult(new ItemStack(RegistryManager.livingHoe, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIngredient(new ItemStack(Items.field_151017_I, 1)).addIngredient(new ItemStack(RegistryManager.verdantSprig, 1)).addIngredient(new ItemStack(Items.field_151074_bl, 1)));
        RitualManager.addRitual(new RitualCrafting("livingShovelCrafting", 2, 146.0, 214.0, 43.0).setResult(new ItemStack(RegistryManager.livingShovel, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.oakTreeBark, 1)).addIngredient(new ItemStack(Items.field_151038_n, 1)).addIngredient(new ItemStack(RegistryManager.verdantSprig, 1)).addIngredient(new ItemStack(Items.field_151074_bl, 1)));
        RitualManager.addRitual(new RitualCauseRain("causerain", 0, 23.0, 0.0, 138.0).addIncense(new ItemStack(Blocks.field_150395_bd, 1)).addIncense(new ItemStack(RegistryManager.oldRoot, 1)).addIngredient(new ItemStack(Blocks.field_150392_bi, 1)));
        RitualManager.addRitual(new RitualCauseRain("banishrain", 0, 204.0, 159.0, 35.0).addIncense(new ItemStack(Blocks.field_150395_bd, 1)).addIncense(new ItemStack(RegistryManager.oldRoot, 1)).addIngredient(new ItemStack(Items.field_151015_O, 1)));
        RitualManager.addRitual(new RitualMassBreed("massbreeding", 0, 148.0, 61.0, 81.0).addIncense(new ItemStack(Items.field_151172_bF, 1)).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(Items.field_151014_N, 1)).addIncense(new ItemStack(Items.field_151115_aP, 1)).addIngredient(new ItemStack(Items.field_151114_aO, 1)).addIngredient(new ItemStack(Items.field_151103_aS)));
        RitualManager.addRitual(new RitualLifeDrain("lifedrain", 2, 139.0, 22.0, 40.0).addIncense(new ItemStack(Items.field_151041_m, 1)).addIncense(new ItemStack(Items.field_151053_p, 1)).addIncense(new ItemStack(RegistryManager.darkOakTreeBark, 1)).addIncense(new ItemStack(RegistryManager.birchTreeBark, 1)).addIngredient(new ItemStack(Items.field_151065_br, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualImbuer().addIngredient(new ItemStack(RegistryManager.crystalStaff, 1)).addIngredient(new ItemStack(RegistryManager.verdantSprig, 1)));
        RitualManager.addRitual(new RitualSummoning("cowSummoning", 1, 199.0, 105.0, 193.0).setResult(EntityCow.class).addIncense(new ItemStack(Items.field_151014_N, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151082_bd, 1)).addIngredient(new ItemStack(Items.field_151116_aA, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("pigSummoning", 1, 199.0, 105.0, 193.0).setResult(EntityPig.class).addIncense(new ItemStack(Items.field_151014_N, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151147_al, 1)).addIngredient(new ItemStack(Items.field_151147_al, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("sheepSummoning", 1, 199.0, 105.0, 193.0).setResult(EntitySheep.class).addIncense(new ItemStack(Items.field_151014_N, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_179561_bm, 1)).addIngredient(new ItemStack(Blocks.field_150325_L, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("chickenSummoning", 1, 199.0, 105.0, 193.0).setResult(EntityChicken.class).addIncense(new ItemStack(Items.field_151014_N, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151076_bf, 1)).addIngredient(new ItemStack(Items.field_151008_G, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("rabbitSummoning", 1, 199.0, 105.0, 193.0).setResult(EntityRabbit.class).addIncense(new ItemStack(Items.field_151014_N, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_179558_bo, 1)).addIngredient(new ItemStack(Items.field_179555_bs, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("zombieSummoning", 2, 58.0, 2.0, 84.0).setResult(EntityZombie.class).addIncense(new ItemStack(Items.field_151044_h, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151078_bh, 1)).addIngredient(new ItemStack(Items.field_151078_bh, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("skeletonSummoning", 2, 58.0, 2.0, 84.0).setResult(EntitySkeleton.class).addIncense(new ItemStack(Items.field_151044_h, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151032_g, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("spiderSummoning", 2, 58.0, 2.0, 84.0).setResult(EntitySpider.class).addIncense(new ItemStack(Items.field_151044_h, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151007_F, 1)).addIngredient(new ItemStack(Items.field_151070_bp, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("caveSpiderSummoning", 2, 58.0, 2.0, 84.0).setResult(EntityCaveSpider.class).addIncense(new ItemStack(Items.field_151044_h, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151007_F, 1)).addIngredient(new ItemStack(Items.field_151071_bq, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("slimeSummoning", 2, 58.0, 2.0, 84.0).setResult(EntitySlime.class).addIncense(new ItemStack(Items.field_151044_h, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151123_aH, 1)).addIngredient(new ItemStack(Items.field_151123_aH, 1)).addIngredient(new ItemStack(Items.field_151123_aH, 1)));
        RitualManager.addRitual(new RitualSummoning("creeperSummoning", 2, 58.0, 2.0, 84.0).setResult(EntityCreeper.class).addIncense(new ItemStack(Items.field_151044_h, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151016_H, 1)).addIngredient(new ItemStack(Items.field_151016_H, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning("endermanSummoning", 2, 58.0, 2.0, 84.0).setResult(EntityEnderman.class).addIncense(new ItemStack(Items.field_151044_h, 1)).addIncense(new ItemStack(Items.field_151075_bm, 1)).addIngredient(new ItemStack(Items.field_151079_bi, 1)).addIngredient(new ItemStack(Items.field_151079_bi, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSacrifice("sacrifice", 2, 94.0, 9.0, 56.0).addIncense(new ItemStack(Items.field_151065_br, 1)).addIncense(new ItemStack(RegistryManager.darkOakTreeBark, 1, 0)).addIngredient(new ItemStack(Items.field_151145_ak, 1)).addIngredient(new ItemStack(Items.field_151040_l, 1)).addIngredient(new ItemStack(Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualFlare("flare", 1, 255.0, 91.0, 25.0).addIncense(new ItemStack(Items.field_151016_H, 1)).addIncense(new ItemStack(RegistryManager.infernalStem, 1)).addIngredient(new ItemStack(Items.field_151145_ak, 1)).addIngredient(new ItemStack(Items.field_151044_h, 1)).addIngredient(new ItemStack(Items.field_151044_h, 1, 1)));
        RitualManager.addRitual(new RitualGrow("grow", 0, 82.0, 212.0, 47.0).addIncense(new ItemStack(Items.field_151015_O, 1)).addIncense(new ItemStack(Items.field_185164_cV, 1)).addIncense(new ItemStack(Items.field_151174_bG, 1)).addIncense(new ItemStack(Items.field_151172_bF, 1)).addIngredient(new ItemStack(Items.field_151137_ax, 1)).addIngredient(new ItemStack(Items.field_151100_aR, 1, 15)).addIngredient(new ItemStack(RegistryManager.verdantSprig, 1)));
        RitualManager.addRitual(new RitualEngravedSword("engravedCrafting", 2, 104.0, 106.0, 107.0).setResult(new ItemStack(RegistryManager.engravedSword)).addIncense(new ItemStack(Items.field_151153_ao)).addIncense(new ItemStack(Items.field_151150_bK, 1)).addIngredient(new ItemStack(Items.field_151052_q)).addIngredient(new ItemStack(RegistryManager.runicFocus)).addIngredient(new ItemStack(Items.field_151114_aO)));
        RitualManager.addRitual(new RitualTimeShift("timeshift", 1, 240.0, 245.0, 88.0).addIngredient(new ItemStack(Items.field_151113_aN)).addIngredient(new ItemStack(Items.field_151042_j)).setSecondaryColor(252.0, 162.0, 35.0));
    }

    public static RitualBase getRitualFromName(String name) {
        for (int i = 0; i < rituals.size(); ++i) {
            if (rituals.get(i).getName() != name) continue;
            return rituals.get(i);
        }
        return null;
    }

    public static ArrayList<ItemStack> getIncenses(World world, BlockPos pos) {
        ArrayList<ItemStack> test = new ArrayList<ItemStack>();
        for (int i = -4; i < 5; ++i) {
            for (int j = -4; j < 5; ++j) {
                TileEntityBrazier teb;
                if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() != RegistryManager.brazier || world.func_175625_s(pos.func_177982_a(i, 0, j)) == null || !(teb = (TileEntityBrazier)world.func_175625_s(pos.func_177982_a(i, 0, j))).isBurning()) continue;
                test.add(teb.getHeldItem());
            }
        }
        return test;
    }
}

