/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.tileentity;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.item.ItemGrowthSalve;
import elucent.rootsclassic.tileentity.TEBase;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityStandingStoneGrower
extends TEBase
implements ITickable {
    private static final double PCT_CHANCE_PER_BLOCK = 0.03;
    private static final int TICK_SPEED = 100;
    private static final int MAX_TICKER = 10000;
    private static final int RADIUS = 4;
    int ticker = 0;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        return tag;
    }

    public void func_73660_a() {
        this.updateTicker();
        this.spawnParticles();
        if (this.ticker % 100 == 0) {
            this.applyGrowthToArea();
        }
    }

    private void updateTicker() {
        ++this.ticker;
        if (this.ticker >= 10000) {
            this.ticker = 0;
        }
    }

    private void applyGrowthToArea() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int xp = -4; xp <= 4; ++xp) {
            for (int zp = -4; zp <= 4; ++zp) {
                positions.add(this.func_174877_v().func_177982_a(xp, -1, zp));
                positions.add(this.func_174877_v().func_177982_a(xp, -2, zp));
            }
        }
        Collections.shuffle(positions);
        for (BlockPos pos : positions) {
            if (!(this.field_145850_b.field_73012_v.nextDouble() < 0.03)) continue;
            ItemGrowthSalve.applyGrowthHere(this.field_145850_b, pos);
        }
    }

    private void spawnParticles() {
        if (this.ticker % 5 == 0) {
            for (double i = 0.0; i < 720.0; i += 45.0) {
                double xShift = 0.5 * Math.sin(Math.PI * (i / 360.0));
                double zShift = 0.5 * Math.cos(Math.PI * (i / 360.0));
                Roots.proxy.spawnParticleMagicAuraFX(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5 + xShift, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5 + zShift, 0.0, 0.0, 0.0, 32.0, 255.0, 32.0);
            }
        }
    }
}

