/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.mortar;

import elucent.rootsclassic.recipe.ComponentRecipe;
import elucent.rootsclassic.registry.RootsRecipes;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.tile.TEBase;
import elucent.rootsclassic.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MortarTile
extends TEBase {
    public final ItemStackHandler inventory = new ItemStackHandler(8){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            MortarTile.this.calculateRotations();
        }
    };
    private LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);

    public MortarTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public MortarTile() {
        this((TileEntityType)RootsRegistry.MORTAR_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l("InventoryHandler"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("InventoryHandler", (INBT)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        this.dropAllItems(world, pos);
        this.func_145843_s();
    }

    @Override
    public ActionResultType activate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, ItemStack heldItem, BlockRayTraceResult hit) {
        if (hand == Hand.MAIN_HAND) {
            if (heldItem.func_190926_b()) {
                return this.tryDropSingleItem(world, pos, state);
            }
            if (heldItem.func_77973_b() == RootsRegistry.PESTLE.get()) {
                return this.tryActivateRecipe(player, state);
            }
            return this.tryInsertItem(world, pos, state, heldItem);
        }
        return ActionResultType.PASS;
    }

    private ActionResultType tryInsertItem(World world, BlockPos pos, BlockState state, ItemStack heldItem) {
        if (!heldItem.func_190926_b() && !InventoryUtil.isFull((IItemHandler)this.inventory)) {
            ItemStack heldCopy = heldItem.func_77946_l();
            heldCopy.func_190920_e(1);
            if (heldItem.func_77973_b() == Items.field_151114_aO || heldItem.func_77973_b() == Items.field_151137_ax || heldItem.func_77973_b() == Items.field_151016_H) {
                int maxCapacity = ComponentRecipe.getModifierCapacity(InventoryUtil.createIInventory((IItemHandler)this.inventory));
                int modifierCount = ComponentRecipe.getModifierCount(InventoryUtil.createIInventory((IItemHandler)this.inventory));
                if (modifierCount < maxCapacity) {
                    ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)heldCopy, (boolean)false);
                    if (restStack.func_190926_b()) {
                        heldItem.func_190918_g(1);
                        this.func_70296_d();
                        world.func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.FAIL;
                }
            } else {
                ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)heldCopy, (boolean)false);
                if (restStack.func_190926_b()) {
                    heldItem.func_190918_g(1);
                    this.func_70296_d();
                    world.func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    private ActionResultType tryDropSingleItem(World world, BlockPos pos, BlockState state) {
        if (!InventoryUtil.isEmpty((IItemHandler)this.inventory)) {
            ItemStack lastStack = InventoryUtil.getLastStack((IItemHandler)this.inventory);
            if (!lastStack.func_190926_b()) {
                this.dropItem(lastStack, 0.5f);
                lastStack.func_190918_g(1);
            }
            this.func_70296_d();
            world.func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private ActionResultType tryActivateRecipe(PlayerEntity player, BlockState state) {
        ComponentRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(RootsRecipes.COMPONENT_RECIPE_TYPE, (IInventory)InventoryUtil.createIInventory((IItemHandler)this.inventory), this.field_145850_b).orElse(null);
        if (recipe == null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.mortar.invalid"), true);
            return ActionResultType.PASS;
        }
        if (recipe.needsMixin() && ComponentRecipe.getModifierCapacity(InventoryUtil.createIInventory((IItemHandler)this.inventory)) < 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.mortar.mixin"), true);
            return ActionResultType.PASS;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, recipe.func_77572_b(InventoryUtil.createIInventory((IItemHandler)this.inventory))));
        }
        InventoryUtil.clearInventory((IItemHandler)this.inventory);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        return ActionResultType.SUCCESS;
    }

    public ItemEntity dropItem(ItemStack stack, float offsetY) {
        ItemStack copyStack = stack.func_77946_l();
        if (copyStack.func_190926_b()) {
            return null;
        }
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        BlockPos pos = this.func_174877_v();
        ItemEntity itementity = new ItemEntity(this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o() + (double)offsetY, (double)this.field_174879_c.func_177952_p(), copyStack);
        itementity.func_174869_p();
        this.field_145850_b.func_217376_c((Entity)itementity);
        return itementity;
    }

    private void dropAllItems(World world, BlockPos pos) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            this.dropItem(stack, 0.0f);
        }
    }

    private void calculateRotations() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
    }
}

