/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.client.particles;

import java.util.Random;
import javax.annotation.Nonnull;

public class ParticleColor {
    private final float r;
    private final float g;
    private final float b;
    private final int color;

    public ParticleColor(int r, int g, int b) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.color = r << 16 | g << 8 | b;
    }

    public static ParticleColor makeRandomColor(int r, int g, int b, Random random) {
        return new ParticleColor(random.nextInt(r), random.nextInt(g), random.nextInt(b));
    }

    public ParticleColor(float r, float g, float b) {
        this((int)r, (int)g, (int)b);
    }

    public ParticleColor(double r, double g, double b) {
        this((int)r, (int)g, (int)b);
    }

    public static ParticleColor fromInt(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        return new ParticleColor(r, g, b);
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public int getColor() {
        return this.color;
    }

    public String serialize() {
        return "" + this.r + "," + this.g + "," + this.b;
    }

    public IntWrapper toWrapper() {
        return new IntWrapper(this);
    }

    public static ParticleColor deserialize(String string) {
        String[] arr = string.split(",");
        return new ParticleColor(Integer.parseInt(arr[0].trim()), Integer.parseInt(arr[1].trim()), Integer.parseInt(arr[2].trim()));
    }

    public static class IntWrapper {
        public int r;
        public int g;
        public int b;

        public IntWrapper(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public IntWrapper(ParticleColor color) {
            this.r = (int)((double)color.getRed() * 255.0);
            this.g = (int)((double)color.getGreen() * 255.0);
            this.b = (int)((double)color.getBlue() * 255.0);
        }

        public ParticleColor toParticleColor() {
            return new ParticleColor(this.r, this.g, this.b);
        }

        public String serialize() {
            return "" + this.r + "," + this.g + "," + this.b;
        }

        public void makeVisible() {
            if (this.r + this.g + this.b < 20) {
                this.b += 10;
                this.g += 10;
                this.r += 10;
            }
        }

        @Nonnull
        public static IntWrapper deserialize(String string) {
            IntWrapper color = new IntWrapper(255, 25, 180);
            try {
                String[] arr = string.split(",");
                color = new IntWrapper(Integer.parseInt(arr[0].trim()), Integer.parseInt(arr[1].trim()), Integer.parseInt(arr[2].trim()));
                return color;
            }
            catch (Exception e) {
                e.printStackTrace();
                return color;
            }
        }
    }
}

