/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import elucent.rootsclassic.Const;
import elucent.rootsclassic.client.ClientInfo;
import elucent.rootsclassic.client.screen.ScreenSlotInstance;
import elucent.rootsclassic.client.screen.ScreenTextInstance;
import elucent.rootsclassic.client.screen.TabletScreen;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.research.EnumPageType;
import elucent.rootsclassic.research.ResearchBase;
import elucent.rootsclassic.research.ResearchGroup;
import elucent.rootsclassic.research.ResearchPage;
import elucent.rootsclassic.util.RootsUtil;
import java.util.ArrayList;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TabletPageScreen
extends Screen {
    private int currentPage = 0;
    private ResearchBase research = null;
    private ResearchGroup group = null;
    private boolean showRightArrow = false;
    private boolean showLeftArrow = true;
    private final PlayerEntity player;
    private int matchingStacksCurrent = 0;
    private int matchingStacksMax = 0;
    private int matchingStacks2Current = 0;
    private int matchingStacks2Max = 0;

    public TabletPageScreen(ResearchGroup g, ResearchBase r, PlayerEntity player) {
        super(StringTextComponent.field_240750_d_);
        this.player = player;
        this.group = g;
        this.research = r;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.field_230706_i_.func_147108_a((Screen)new TabletScreen(this.player));
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(20, 20, 20, 60, StringTextComponent.field_240750_d_, button -> {}));
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        float basePosX = (float)this.field_230708_k_ / 2.0f - 96.0f;
        float basePosY = (float)this.field_230709_l_ / 2.0f - 128.0f;
        if (this.showLeftArrow && mouseX >= (double)(basePosX + 16.0f) && mouseX < (double)(basePosX + 48.0f) && mouseY >= (double)(basePosY + 224.0f) && mouseY < (double)(basePosY + 240.0f)) {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            --this.currentPage;
        }
        if (this.showRightArrow && mouseX >= (double)(basePosX + 144.0f) && mouseX < (double)(basePosX + 176.0f) && mouseY >= (double)(basePosY + 224.0f) && mouseY < (double)(basePosY + 240.0f)) {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            ++this.currentPage;
        }
        ArrayList<ResearchPage> researchInfo = this.research.getInfo();
        if (this.player.field_70170_p.field_72995_K && mouseX >= (double)((float)this.field_230708_k_ / 2.0f - 110.0f) && mouseX < (double)((float)this.field_230708_k_ / 2.0f + 40.0f) && mouseY >= (double)((float)this.field_230709_l_ / 2.0f - 138.0f) && mouseY < (double)((float)this.field_230709_l_ / 2.0f - 40.0f)) {
            if (researchInfo.get((int)this.currentPage).recipe == EnumPageType.TYPE_MORTAR) {
                this.player.func_145747_a((ITextComponent)new StringTextComponent(researchInfo.get((int)this.currentPage).mortarRecipe.toString()), Util.field_240973_b_);
            } else if (researchInfo.get((int)this.currentPage).recipe == EnumPageType.TYPE_ALTAR) {
                this.player.func_145747_a((ITextComponent)new TranslationTextComponent(researchInfo.get((int)this.currentPage).altarRecipe.toString()), Util.field_240973_b_);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private String makeTitle() {
        return I18n.func_135052_a((String)("rootsclassic.research." + this.group.getName() + "." + this.research.getName() + ".page" + (this.currentPage + 1) + "title"), (Object[])new Object[0]);
    }

    private String makeInfo() {
        return I18n.func_135052_a((String)("rootsclassic.research." + this.group.getName() + "." + this.research.getName() + ".page" + (this.currentPage + 1) + "info"), (Object[])new Object[0]);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ArrayList<ResearchPage> researchInfo = this.research.getInfo();
        this.showLeftArrow = this.currentPage != 0;
        this.showRightArrow = this.currentPage != researchInfo.size() - 1;
        int basePosX = (int)((float)this.field_230708_k_ / 2.0f - 96.0f);
        int basePosY = (int)((float)this.field_230709_l_ / 2.0f - 128.0f);
        if (this.research == null || researchInfo == null || researchInfo.size() <= this.currentPage) {
            return;
        }
        ArrayList<ScreenSlotInstance> slots = new ArrayList<ScreenSlotInstance>();
        ArrayList<ScreenTextInstance> textLines = new ArrayList<ScreenTextInstance>();
        ResearchPage page = researchInfo.get(this.currentPage);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (page.recipe) {
            case TYPE_NULL: {
                int i;
                this.field_230706_i_.func_110434_K().func_110577_a(Const.tabletGui);
                this.func_238474_b_(matrixStack, basePosX, basePosY, 64, 0, 192, 256);
                ArrayList<String> info = page.makeLines(this.makeInfo());
                for (i = 0; i < info.size(); ++i) {
                    textLines.add(new ScreenTextInstance(info.get(i), basePosX + 16, basePosY + 32 + i * 11));
                }
                String title = this.makeTitle();
                textLines.add(new ScreenTextInstance(title, (float)(basePosX + 96) - (float)this.field_230712_o_.func_78256_a(title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
                break;
            }
            case TYPE_SMELTING: {
                int i;
                this.field_230706_i_.func_110434_K().func_110577_a(Const.tabletSmelting);
                this.func_238474_b_(matrixStack, basePosX, basePosY, 0, 0, 192, 256);
                slots.add(new ScreenSlotInstance(page.smeltingRecipe.get(0), basePosX + 56, basePosY + 40));
                slots.add(new ScreenSlotInstance(page.smeltingRecipe.get(1), basePosX + 144, basePosY + 56));
                ArrayList<String> info = page.makeLines(this.makeInfo());
                for (i = 0; i < info.size(); ++i) {
                    textLines.add(new ScreenTextInstance(info.get(i), basePosX + 16, basePosY + 104 + i * 11, RootsUtil.intColor(255, 255, 255)));
                }
                String title = this.makeTitle();
                textLines.add(new ScreenTextInstance(title, (float)(basePosX + 96) - (float)this.field_230712_o_.func_78256_a(title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
                break;
            }
            case TYPE_DISPLAY: {
                int i;
                this.field_230706_i_.func_110434_K().func_110577_a(Const.tabletDisplay);
                this.func_238474_b_(matrixStack, basePosX, basePosY, 0, 0, 192, 256);
                slots.add(new ScreenSlotInstance(page.displayItem, basePosX + 88, basePosY + 48));
                ArrayList<String> info = page.makeLines(this.makeInfo());
                for (i = 0; i < info.size(); ++i) {
                    textLines.add(new ScreenTextInstance(info.get(i), basePosX + 16, basePosY + 80 + i * 11, RootsUtil.intColor(255, 255, 255)));
                }
                String title = this.makeTitle();
                textLines.add(new ScreenTextInstance(title, (float)(basePosX + 96) - (float)this.field_230712_o_.func_78256_a(title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
                break;
            }
            case TYPE_ALTAR: {
                int i;
                this.field_230706_i_.func_110434_K().func_110577_a(Const.tabletAltar);
                this.func_238474_b_(matrixStack, basePosX, basePosY, 0, 0, 192, 256);
                for (i = 0; i < page.altarRecipe.getBlocks().size(); ++i) {
                    this.field_230706_i_.func_110434_K().func_110577_a(Const.tabletAltar);
                    int u = 192;
                    int v = 240;
                    int xShift = 0;
                    int yShift = 0;
                    this.func_238474_b_(matrixStack, basePosX + 93, basePosY + 153, 192, 32, 16, 16);
                    if (page.altarRecipe.getBlocks().get(i).equals(RootsRegistry.MUNDANE_STANDING_STONE.get())) {
                        u = 192;
                        v = 48;
                        xShift = 8 * page.altarRecipe.getPositionsRelative().get(i).func_177958_n();
                        yShift = 8 * page.altarRecipe.getPositionsRelative().get(i).func_177952_p();
                    }
                    if (page.altarRecipe.getBlocks().get(i).equals(RootsRegistry.ATTUNED_STANDING_STONE.get())) {
                        u = 192;
                        v = 64;
                        xShift = 8 * page.altarRecipe.getPositionsRelative().get(i).func_177958_n();
                        yShift = 8 * page.altarRecipe.getPositionsRelative().get(i).func_177952_p();
                    }
                    this.func_238474_b_(matrixStack, basePosX + 93 + xShift, basePosY + 153 + yShift, u, v, 16, 16);
                }
                for (i = 0; i < page.altarRecipe.getIngredients().size(); ++i) {
                    slots.add(new ScreenSlotInstance(page.altarRecipe.getIngredients().get(i), basePosX + 64 + 24 * i, basePosY + 56));
                }
                for (i = 0; i < page.altarRecipe.getIncenses().size(); ++i) {
                    slots.add(new ScreenSlotInstance(page.altarRecipe.getIncenses().get(i), basePosX + 76 + 16 * i, basePosY + 88));
                }
                String title = this.makeTitle();
                textLines.add(new ScreenTextInstance(title, (float)(basePosX + 96) - (float)this.field_230712_o_.func_78256_a(title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
                break;
            }
            case TYPE_MORTAR: {
                int i;
                ArrayList<String> info;
                this.field_230706_i_.func_110434_K().func_110577_a(Const.tabletMortar);
                this.func_238474_b_(matrixStack, basePosX, basePosY, 0, 0, 192, 256);
                String title = this.makeTitle();
                if (page.mortarRecipe != null) {
                    for (i = 0; i < page.mortarRecipe.func_192400_c().size(); ++i) {
                        Ingredient ingredient = (Ingredient)page.mortarRecipe.func_192400_c().get(i);
                        if (ingredient.func_203189_d()) {
                            slots.add(new ScreenSlotInstance(new ItemStack((IItemProvider)Items.field_221803_eL), basePosX + 24 + i * 16, basePosY + 56));
                            continue;
                        }
                        slots.add(new ScreenSlotInstance(this.getStackFromIngredient(ingredient), basePosX + 24 + i * 16, basePosY + 56));
                    }
                    slots.add(new ScreenSlotInstance(page.mortarRecipe.func_77572_b(null), basePosX + 144, basePosY + 56));
                    info = page.makeLines(this.makeInfo());
                    for (i = 0; i < info.size(); ++i) {
                        textLines.add(new ScreenTextInstance(info.get(i), basePosX + 16, basePosY + 96 + i * 11, RootsUtil.intColor(255, 255, 255)));
                    }
                } else {
                    title = TextFormatting.RED + I18n.func_135052_a((String)"rootsclassic.research.disabled", (Object[])new Object[0]);
                }
                textLines.add(new ScreenTextInstance(title, (float)(basePosX + 96) - (float)this.field_230712_o_.func_78256_a(title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
            }
        }
        for (ScreenSlotInstance s : slots) {
            this.field_230707_j_.func_175042_a(s.getStack(), s.getX(), s.getY());
        }
        for (ScreenTextInstance line : textLines) {
            if (line.isShadow()) {
                this.field_230712_o_.func_238405_a_(matrixStack, line.getLine(), line.getX(), line.getY(), line.getColor());
                continue;
            }
            this.field_230712_o_.func_238421_b_(matrixStack, line.getLine(), (float)((int)line.getX()), (float)((int)line.getY()), line.getColor());
        }
        this.field_230706_i_.func_110434_K().func_110577_a(Const.tabletGui);
        if (this.showLeftArrow) {
            if (mouseX >= basePosX + 16 && mouseX < basePosX + 48 && mouseY >= basePosY + 224 && mouseY < basePosY + 240) {
                this.func_238474_b_(matrixStack, basePosX + 16, basePosY + 224, 32, 80, 32, 16);
            } else {
                this.func_238474_b_(matrixStack, basePosX + 16, basePosY + 224, 32, 64, 32, 16);
            }
        }
        if (this.showRightArrow) {
            if (mouseX >= basePosX + 144 && mouseX < basePosX + 176 && mouseY >= basePosY + 224 && mouseY < basePosY + 240) {
                this.func_238474_b_(matrixStack, basePosX + 144, basePosY + 224, 0, 80, 32, 16);
            } else {
                this.func_238474_b_(matrixStack, basePosX + 144, basePosY + 224, 0, 64, 32, 16);
            }
        }
        for (ScreenSlotInstance s : slots) {
            if (!s.isMouseover(mouseX, mouseY)) continue;
            this.func_230457_a_(matrixStack, s.getStack(), mouseX, mouseY);
        }
        RenderSystem.popMatrix();
    }

    public ItemStack getStackFromIngredient(Ingredient ingredient) {
        ItemStack[] matchingStacks = ingredient.func_193365_a();
        if (this.matchingStacksMax != matchingStacks.length) {
            this.matchingStacksMax = matchingStacks.length;
        }
        if (ClientInfo.ticksInGame % 20 == 0) {
            ++this.matchingStacksCurrent;
        }
        if (this.matchingStacksCurrent >= this.matchingStacksMax - 1) {
            this.matchingStacksCurrent = 0;
        }
        return matchingStacks[this.matchingStacksCurrent];
    }

    public ItemStack getStackFrom2ndIngredient(Ingredient ingredient) {
        ItemStack[] matchingStacks = ingredient.func_193365_a();
        if (this.matchingStacks2Max != matchingStacks.length) {
            this.matchingStacks2Max = matchingStacks.length;
        }
        if (ClientInfo.ticksInGame % 20 == 0) {
            ++this.matchingStacks2Current;
        }
        if (this.matchingStacks2Current >= this.matchingStacks2Max - 1) {
            this.matchingStacks2Current = 0;
        }
        return matchingStacks[this.matchingStacks2Current];
    }
}

