/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import elucent.rootsclassic.Const;
import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.client.ClientInfo;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.item.IManaRelatedItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ManaBarEvent {
    private void drawQuad(BufferBuilder vertexbuffer, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, int minU, int minV, int maxU, int maxV) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        vertexbuffer.func_225582_a_((double)(x1 + 0.0f), (double)(y1 + 0.0f), 0.0).func_225583_a_((float)(minU + 0) * f, (float)(minV + maxV) * f1).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x2 + 0.0f), (double)(y2 + 0.0f), 0.0).func_225583_a_((float)(minU + maxU) * f, (float)(minV + maxV) * f1).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x3 + 0.0f), (double)(y3 + 0.0f), 0.0).func_225583_a_((float)(minU + maxU) * f, (float)(minV + 0) * f1).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x4 + 0.0f), (double)(y4 + 0.0f), 0.0).func_225583_a_((float)(minU + 0) * f, (float)(minV + 0) * f1).func_181675_d();
    }

    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean showBar = player.func_184614_ca().func_77973_b() instanceof IManaRelatedItem || player.func_184592_cb().func_77973_b() instanceof IManaRelatedItem;
        IManaCapability capability = (IManaCapability)player.getCapability(RootsCapabilityManager.MANA_CAPABILITY, null).orElse(null);
        if (!showBar || capability == null) {
            return;
        }
        if (capability.getMaxMana() > 0.0f) {
            this.drawManaBar(event, (PlayerEntity)player, capability);
        }
    }

    private void drawManaBar(RenderGameOverlayEvent.Post event, PlayerEntity player, IManaCapability capability) {
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Const.manaBar);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder b = tess.func_178180_c();
        int w = event.getWindow().func_198107_o();
        int h = event.getWindow().func_198087_p();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int manaNumber = Math.round(capability.getMana());
        int maxManaNumber = Math.round(capability.getMaxMana());
        int offsetX = 0;
        b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int manaBarOffset = (Integer)RootsConfig.CLIENT.manaBarOffset.get();
        while (maxManaNumber > 0) {
            this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 0, 0, 9, 9);
            if (maxManaNumber > 4) {
                maxManaNumber -= 4;
                offsetX += 8;
                continue;
            }
            maxManaNumber = 0;
        }
        offsetX = 0;
        while (manaNumber > 0) {
            if (manaNumber > 4) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 0, 16, 9, 9);
                manaNumber -= 4;
                offsetX += 8;
                continue;
            }
            if (manaNumber == 4) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 0, 16, 9, 9);
            }
            if (manaNumber == 3) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 16, 16, 9, 9);
            }
            if (manaNumber == 2) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 32, 16, 9, 9);
            }
            if (manaNumber == 1) {
                this.drawQuad(b, w / 2 + 10 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - (manaBarOffset - 9), w / 2 + 19 + offsetX, h - manaBarOffset, w / 2 + 10 + offsetX, h - manaBarOffset, 48, 16, 9, 9);
            }
            manaNumber = 0;
        }
        tess.func_78381_a();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
    }

    @SubscribeEvent
    public void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ClientInfo.ticksInGame;
        }
    }
}

