/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.RitualManager;
import elucent.rootsclassic.ritual.rituals.RitualCrafting;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.rootsclassic.Ritual")
public class RitualZen {
    @ZenCodeType.Method
    public void addCraftingRitual(String uniqueName, IItemStack output, int level, double r, double g, double b, IItemStack[] incenses, IItemStack[] ingredients) {
        RitualCrafting newCraft = new RitualCrafting(new ResourceLocation("crafttweaker", uniqueName), level, r, g, b);
        newCraft.setResult(output.getInternal());
        newCraft.setIncenses(Arrays.asList(this.convertToStacks(incenses)));
        newCraft.setIngredients(Arrays.asList(this.convertToStacks(ingredients)));
        RitualManager.addRitual(newCraft);
    }

    @ZenCodeType.Method
    public void setPrimaryColor(ResourceLocation name, double r, double g, double b) {
        RitualBase found = this.findRitualByName(name);
        found.setPrimaryColor(r, g, b);
    }

    @ZenCodeType.Method
    public void setSecondaryColor(ResourceLocation name, double r, double g, double b) {
        RitualBase found = this.findRitualByName(name);
        found.setSecondaryColor(r, g, b);
    }

    @ZenCodeType.Method
    public void setLevel(ResourceLocation name, int level) {
        RitualBase found = this.findRitualByName(name);
        found.setLevel(level);
    }

    @ZenCodeType.Method
    public void setRitualIngredients(ResourceLocation name, IItemStack[] items) {
        RitualBase found = this.findRitualByName(name);
        CraftTweakerAPI.logInfo((String)("Changing Ritual ingredients " + found.getName()), (Object[])new Object[0]);
        found.setIngredients(Arrays.asList(this.convertToStacks(items)));
    }

    @ZenCodeType.Method
    public void setRitualIncense(ResourceLocation name, IItemStack[] items) {
        RitualBase found = this.findRitualByName(name);
        CraftTweakerAPI.logInfo((String)("Changing Ritual incense " + found.getName()), (Object[])new Object[0]);
        found.setIncenses(Arrays.asList(this.convertToStacks(items)));
    }

    private RitualBase findRitualByName(ResourceLocation name) {
        RitualBase found = RitualManager.getRitualFromName(name);
        if (found == null) {
            StringBuilder names = new StringBuilder();
            for (RitualBase c : RitualManager.rituals) {
                names.append(c.getName()).append(",");
            }
            CraftTweakerAPI.logInfo((String)names.toString(), (Object[])new Object[0]);
            throw new IllegalArgumentException("Invalid ritual[" + name + "], names must be one of: " + names);
        }
        return found;
    }

    private ItemStack[] convertToStacks(IItemStack[] stacks) {
        if (stacks == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            output[i] = stacks[i].getInternal();
        }
        return output;
    }
}

