/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.event;

import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.util.RootsUtil;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ComponentSpellsEvent {
    public static int TICKS_PER_MANA_REGEN = 5;

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity) {
            this.wildwoodArmorRegenFullset((PlayerEntity)entity);
            this.tickManaRegen(entity);
        }
        this.tickSkipMovementCurse(event, entity);
    }

    private void tickSkipMovementCurse(LivingEvent.LivingUpdateEvent event, LivingEntity entity) {
        int skipTicks;
        CompoundNBT persistentData = entity.getPersistentData();
        if (persistentData.func_74764_b("RMOD_trackTicks") && persistentData.func_74764_b("rootsclassic:RMOD_skipTicks") && (skipTicks = persistentData.func_74762_e("rootsclassic:RMOD_skipTicks")) > 0) {
            persistentData.func_74768_a("rootsclassic:RMOD_skipTicks", skipTicks - 1);
            if (skipTicks <= 0) {
                persistentData.func_82580_o("rootsclassic:RMOD_skipTicks");
                RootsUtil.decrementTickTracking((Entity)entity);
            }
            event.setCanceled(true);
        }
    }

    private void tickManaRegen(LivingEntity entity) {
        if (entity.field_70173_aa % TICKS_PER_MANA_REGEN == 0) {
            entity.getCapability(RootsCapabilityManager.MANA_CAPABILITY).ifPresent(cap -> cap.setMana(cap.getMana() + 1.0f));
        }
    }

    private void wildwoodArmorRegenFullset(PlayerEntity entity) {
        ItemStack head = entity.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chest = entity.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = entity.func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feet = entity.func_184582_a(EquipmentSlotType.FEET);
        if (head.func_77973_b() == RootsRegistry.WILDWOOD_MASK.get() && chest.func_77973_b() == RootsRegistry.WILDWOOD_PLATE.get() && legs.func_77973_b() == RootsRegistry.WILDWOOD_LEGGINGS.get() && feet.func_77973_b() == RootsRegistry.WILDWOOD_BOOTS.get() && entity.field_70170_p.field_73012_v.nextDouble() < 0.02 && entity.func_110143_aJ() < entity.func_110138_aP()) {
            entity.func_70691_i(1.0f);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        CompoundNBT persistentData = event.getEntityLiving().getPersistentData();
        if (persistentData.func_74764_b("rootsclassic:RMOD_dropItems") && !persistentData.func_74767_n("rootsclassic:RMOD_dropItems")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingXP(LivingExperienceDropEvent event) {
        CompoundNBT persistentData = event.getEntityLiving().getPersistentData();
        if (persistentData.func_74764_b("rootsclassic:RMOD_dropItems") && !persistentData.func_74767_n("rootsclassic:RMOD_dropItems")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        ItemStack sword;
        PlayerEntity player;
        LivingEntity entityLiving = event.getEntityLiving();
        CompoundNBT persistentData = entityLiving.getPersistentData();
        if (persistentData.func_74764_b("rootsclassic:RMOD_vuln")) {
            event.setAmount((float)((double)event.getAmount() * (1.0 + persistentData.func_74769_h("rootsclassic:RMOD_vuln"))));
            persistentData.func_82580_o("rootsclassic:RMOD_vuln");
        }
        if (persistentData.func_74764_b("rootsclassic:RMOD_thornsDamage") && event.getSource().func_76346_g() instanceof LivingEntity) {
            ((LivingEntity)event.getSource().func_76346_g()).func_70097_a(DamageSource.field_76367_g, persistentData.func_74760_g("rootsclassic:RMOD_thornsDamage"));
            persistentData.func_82580_o("rootsclassic:RMOD_thornsDamage");
            RootsUtil.decrementTickTracking((Entity)entityLiving);
        }
        if (entityLiving instanceof PlayerEntity) {
            player = (PlayerEntity)entityLiving;
            if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() == RootsRegistry.ENGRAVED_BLADE.get() && (sword = player.field_71071_by.func_70448_g()).func_77942_o() && sword.func_77978_p().func_74764_b("shadowstep")) {
                int stepLvl = sword.func_77978_p().func_74762_e("shadowstep");
                double chance = (double)stepLvl * 12.5;
                if ((double)player.func_130014_f_().field_73012_v.nextInt(100) < chance) {
                    event.setCanceled(true);
                }
            }
        }
        if (event.getSource().func_76346_g() instanceof PlayerEntity && !event.getEntity().func_130014_f_().field_72995_K) {
            player = (PlayerEntity)event.getSource().func_76346_g();
            if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() == RootsRegistry.ENGRAVED_BLADE.get() && (sword = player.field_71071_by.func_70448_g()).func_77942_o()) {
                float currentAmount;
                float amount;
                CompoundNBT tag = sword.func_77978_p();
                if (tag.func_74764_b("aquatic")) {
                    int aquaLvl = tag.func_74762_e("aquatic");
                    amount = (float)aquaLvl * 0.5f;
                    event.getEntity().func_70097_a(DamageSource.field_76369_e, amount);
                }
                if (tag.func_74764_b("holy") && entityLiving.func_70668_bt() == CreatureAttribute.field_223223_b_) {
                    int holyLvl = tag.func_74762_e("holy");
                    amount = (float)holyLvl * 1.5f;
                    currentAmount = event.getAmount();
                    event.setAmount(currentAmount + amount);
                }
                if (tag.func_74764_b("spikes")) {
                    int spikeLvl = tag.func_74762_e("spikes");
                    amount = spikeLvl;
                    currentAmount = event.getAmount();
                    event.setAmount(currentAmount + amount);
                }
            }
        }
    }
}

