/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.client.particles.MagicLineParticleData;
import elucent.rootsclassic.client.particles.MagicParticleData;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.component.EnumCastType;
import elucent.rootsclassic.item.IManaRelatedItem;
import elucent.rootsclassic.item.SylvanArmorItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CrystalStaffItem
extends Item
implements IManaRelatedItem {
    public CrystalStaffItem(Item.Properties properties) {
        super(properties);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity caster, int timeLeft) {
        if (timeLeft < 71988 && stack.func_77942_o()) {
            PlayerEntity player = (PlayerEntity)caster;
            ResourceLocation compName = ResourceLocation.func_208304_a((String)CrystalStaffItem.getEffect(stack));
            if (compName != null) {
                IManaCapability manaCap;
                ComponentBase comp = ComponentManager.getComponentFromName(compName);
                if (comp == null || !caster.getCapability(RootsCapabilityManager.MANA_CAPABILITY).isPresent()) {
                    return;
                }
                int potency = CrystalStaffItem.getPotency(stack) + 1;
                int efficiency = CrystalStaffItem.getEfficiency(stack);
                int size = CrystalStaffItem.getSize(stack);
                if (player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof SylvanArmorItem && player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof SylvanArmorItem && player.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof SylvanArmorItem && player.func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof SylvanArmorItem) {
                    ++potency;
                }
                if ((manaCap = (IManaCapability)player.getCapability(RootsCapabilityManager.MANA_CAPABILITY).orElse(null)).getMana() >= comp.getManaCost() / (float)(efficiency + 1)) {
                    manaCap.setMana(manaCap.getMana() - comp.getManaCost() / (float)(efficiency + 1));
                    comp.doEffect(world, (Entity)caster, EnumCastType.SPELL, caster.func_226277_ct_() + 3.0 * caster.func_70040_Z().field_72450_a, caster.func_226278_cu_() + 3.0 * caster.func_70040_Z().field_72448_b, caster.func_226281_cx_() + 3.0 * caster.func_70040_Z().field_72449_c, potency, efficiency, 3.0 + 2.0 * (double)size);
                    if (world.field_72995_K) {
                        for (int i = 0; i < 90; ++i) {
                            double offX = (double)field_77697_d.nextFloat() * 0.5 - 0.25;
                            double offY = (double)field_77697_d.nextFloat() * 0.5 - 0.25;
                            double offZ = (double)field_77697_d.nextFloat() * 0.5 - 0.25;
                            double coeff = (offX + offY + offZ) / 1.5 + 0.5;
                            double dx = (caster.func_70040_Z().field_72450_a + offX) * coeff;
                            double dy = (caster.func_70040_Z().field_72448_b + offY) * coeff;
                            double dz = (caster.func_70040_Z().field_72449_c + offZ) * coeff;
                            if (world.field_73012_v.nextBoolean()) {
                                world.func_195594_a(MagicParticleData.createData(comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c), caster.func_226277_ct_() + dx, caster.func_226278_cu_() + 1.5 + dy, caster.func_226281_cx_() + dz, dx, dy, dz);
                                continue;
                            }
                            world.func_195594_a(MagicParticleData.createData(comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c), caster.func_226277_ct_() + dx, caster.func_226278_cu_() + 1.5 + dy, caster.func_226281_cx_() + dz, dx, dy, dz);
                        }
                    }
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            if (!player.func_225608_bj_()) {
                if (world.field_72995_K && Minecraft.func_71410_x().field_71462_r != null) {
                    return new ActionResult(ActionResultType.FAIL, (Object)stack);
                }
                player.func_184598_c(hand);
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            tag.func_74768_a("rootsclassic:selected", tag.func_74762_e("rootsclassic:selected") + 1);
            if (tag.func_74762_e("rootsclassic:selected") > 4) {
                tag.func_74768_a("rootsclassic:selected", 1);
            }
            stack.func_77982_d(tag);
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldS, ItemStack newS, boolean slotChanged) {
        if (oldS.func_77942_o() && newS.func_77942_o() && (!CrystalStaffItem.getEffect(oldS).equals(CrystalStaffItem.getEffect(newS)) || oldS.func_77978_p().func_74762_e("rootsclassic:selected") != newS.func_77978_p().func_74762_e("rootsclassic:selected") || slotChanged)) {
            return true;
        }
        return slotChanged;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (stack.func_77942_o()) {
            ComponentBase comp;
            ResourceLocation componentName;
            CompoundNBT tag = stack.func_77978_p();
            String effect = CrystalStaffItem.getEffect(stack);
            if (effect != null && (componentName = ResourceLocation.func_208304_a((String)effect)) != null && (comp = ComponentManager.getComponentFromName(componentName)) != null) {
                int potency = tag.func_74762_e("rootsclassic:potency");
                int efficiency = tag.func_74762_e("rootsclassic:efficiency");
                int size = tag.func_74762_e("rootsclassic:size");
                comp.castingAction((PlayerEntity)player, count, potency, efficiency, size);
                if (player.func_130014_f_().field_72995_K) {
                    if (field_77697_d.nextBoolean()) {
                        player.func_130014_f_().func_195594_a(MagicLineParticleData.createData(comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c), player.func_226277_ct_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.func_226278_cu_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5) + 1.0, player.func_226281_cx_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_());
                    } else {
                        player.func_130014_f_().func_195594_a(MagicLineParticleData.createData(comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c), player.func_226277_ct_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.func_226278_cu_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5) + 1.0, player.func_226281_cx_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_());
                    }
                }
            }
        }
    }

    public static void createData(ItemStack stack) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("rootsclassic:selected", 1);
        tag.func_74768_a("rootsclassic:potency1", 0);
        tag.func_74768_a("rootsclassic:potency2", 0);
        tag.func_74768_a("rootsclassic:potency3", 0);
        tag.func_74768_a("rootsclassic:potency4", 0);
        tag.func_74768_a("rootsclassic:efficiency1", 0);
        tag.func_74768_a("rootsclassic:efficiency2", 0);
        tag.func_74768_a("rootsclassic:efficiency3", 0);
        tag.func_74768_a("rootsclassic:efficiency4", 0);
        tag.func_74768_a("rootsclassic:size1", 0);
        tag.func_74768_a("rootsclassic:size2", 0);
        tag.func_74768_a("rootsclassic:size3", 0);
        tag.func_74768_a("rootsclassic:size4", 0);
        tag.func_74778_a("rootsclassic:effect1", "");
        tag.func_74778_a("rootsclassic:effect2", "");
        tag.func_74778_a("rootsclassic:effect3", "");
        tag.func_74778_a("rootsclassic:effect4", "");
        stack.func_77982_d(tag);
    }

    public static void addEffect(ItemStack stack, int slot, String effect, int potency, int efficiency, int size) {
        CompoundNBT tag = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        tag.func_74778_a("rootsclassic:effect" + slot, effect);
        tag.func_74768_a("rootsclassic:potency" + slot, potency);
        tag.func_74768_a("rootsclassic:efficiency" + slot, efficiency);
        tag.func_74768_a("rootsclassic:size" + slot, size);
        stack.func_77982_d(tag);
    }

    public static Integer getPotency(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74762_e("rootsclassic:potency" + tag.func_74762_e("rootsclassic:selected"));
        }
        return 0;
    }

    public static Integer getEfficiency(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74762_e("rootsclassic:efficiency" + tag.func_74762_e("rootsclassic:selected"));
        }
        return 0;
    }

    public static Integer getSize(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74762_e("rootsclassic:size" + tag.func_74762_e("rootsclassic:selected"));
        }
        return 0;
    }

    public static String getEffect(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74779_i("rootsclassic:effect" + tag.func_74762_e("rootsclassic:selected"));
        }
        return null;
    }

    public static String getEffect(ItemStack stack, int slot) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74779_i("rootsclassic:effect" + slot);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            ComponentBase comp;
            ResourceLocation compName;
            String effect = CrystalStaffItem.getEffect(stack);
            if (effect != null && (compName = ResourceLocation.func_208304_a((String)effect)) != null && (comp = ComponentManager.getComponentFromName(compName)) != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.spelltypeheading").func_240702_b_(": ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)comp.getEffectName().func_240699_a_(comp.getTextColor())));
            }
            tooltip.add((ITextComponent)new StringTextComponent("  +" + CrystalStaffItem.getPotency(stack) + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.spellpotency")).func_240702_b_(".").func_240699_a_(TextFormatting.RED));
            tooltip.add((ITextComponent)new StringTextComponent("  +" + CrystalStaffItem.getEfficiency(stack) + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.spellefficiency")).func_240702_b_(".").func_240699_a_(TextFormatting.RED));
            tooltip.add((ITextComponent)new StringTextComponent("  +" + CrystalStaffItem.getSize(stack) + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.spellsize")).func_240702_b_(".").func_240699_a_(TextFormatting.RED));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("rootsclassic.error.unset").func_240699_a_(TextFormatting.GRAY));
        }
    }
}

