/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import com.google.common.collect.ImmutableMap;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.registry.RootsRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DruidKnifeItem
extends Item {
    protected static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196626_Q, (Object)Blocks.field_209389_ab).put((Object)Blocks.field_196617_K, (Object)Blocks.field_203204_R).put((Object)Blocks.field_196639_V, (Object)Blocks.field_209394_ag).put((Object)Blocks.field_196623_P, (Object)Blocks.field_203209_W).put((Object)Blocks.field_196637_U, (Object)Blocks.field_209393_af).put((Object)Blocks.field_196621_O, (Object)Blocks.field_203208_V).put((Object)Blocks.field_196631_S, (Object)Blocks.field_209391_ad).put((Object)Blocks.field_196619_M, (Object)Blocks.field_203206_T).put((Object)Blocks.field_196634_T, (Object)Blocks.field_209392_ae).put((Object)Blocks.field_196620_N, (Object)Blocks.field_203207_U).put((Object)Blocks.field_196629_R, (Object)Blocks.field_209390_ac).put((Object)Blocks.field_196618_L, (Object)Blocks.field_203205_S).build();
    protected static final Map<Block, Supplier<Item>> BLOCK_BARK_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196626_Q, RootsRegistry.OAK_BARK).put((Object)Blocks.field_196617_K, RootsRegistry.OAK_BARK).put((Object)Blocks.field_196639_V, RootsRegistry.DARK_OAK_BARK).put((Object)Blocks.field_196623_P, RootsRegistry.DARK_OAK_BARK).put((Object)Blocks.field_196637_U, RootsRegistry.ACACIA_BARK).put((Object)Blocks.field_196621_O, RootsRegistry.ACACIA_BARK).put((Object)Blocks.field_196631_S, RootsRegistry.BIRCH_BARK).put((Object)Blocks.field_196619_M, RootsRegistry.BIRCH_BARK).put((Object)Blocks.field_196634_T, RootsRegistry.JUNGLE_BARK).put((Object)Blocks.field_196620_N, RootsRegistry.JUNGLE_BARK).put((Object)Blocks.field_196629_R, RootsRegistry.SPRUCE_BARK).put((Object)Blocks.field_196618_L, RootsRegistry.SPRUCE_BARK).build();

    public DruidKnifeItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        BlockState strippedState = DruidKnifeItem.getStrippingState(state);
        ItemStack barkDrop = DruidKnifeItem.getBarkDrop(state);
        if (!barkDrop.func_190926_b() && strippedState != null) {
            ItemStack stack = context.func_195996_i();
            Hand hand = context.func_221531_n();
            PlayerEntity playerIn = context.func_195999_j();
            playerIn.func_70099_a(barkDrop, 1.0f);
            stack.func_222118_a(1, (LivingEntity)playerIn, e -> e.func_213334_d(hand));
            if (world.field_73012_v.nextDouble() < (Double)RootsConfig.COMMON.barkKnifeBlockStripChance.get()) {
                world.func_184133_a(playerIn, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, strippedState, 11);
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public static BlockState getStrippingState(BlockState originalState) {
        Block block = BLOCK_STRIPPING_MAP.get(originalState.func_177230_c());
        return block != null ? (BlockState)block.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, originalState.func_177229_b((Property)RotatedPillarBlock.field_176298_M)) : null;
    }

    public static ItemStack getBarkDrop(BlockState originalState) {
        Block block = originalState.func_177230_c();
        if (BLOCK_BARK_MAP.containsKey(block)) {
            return new ItemStack((IItemProvider)BLOCK_BARK_MAP.get(block).get());
        }
        return ItemStack.field_190927_a;
    }
}

