/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.client.particles.MagicLineParticleData;
import elucent.rootsclassic.client.particles.MagicParticleData;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.component.EnumCastType;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.item.IManaRelatedItem;
import elucent.rootsclassic.item.SylvanArmorItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class StaffItem
extends Item
implements IManaRelatedItem {
    private static final String NBT_USES = "uses";
    private static final String NBT_MAX = "maxUses";
    private static final double RANGE = 3.0;
    private static final double SIZE_PER_LEVEL = 2.0;
    private static final double SIZE_BASE = 3.0;

    public StaffItem(Item.Properties properties) {
        super(properties);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return 1.0 - (double)tag.func_74762_e(NBT_USES) / (double)tag.func_74762_e(NBT_MAX);
        }
        return 1.0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74762_e(NBT_USES) < tag.func_74762_e(NBT_MAX);
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity caster, int timeLeft) {
        CompoundNBT tag;
        if (timeLeft < 71988 && stack.func_77942_o() && caster.getCapability(RootsCapabilityManager.MANA_CAPABILITY).isPresent() && (tag = stack.func_77978_p()).func_74762_e(NBT_USES) >= 0) {
            ComponentBase comp;
            tag.func_74768_a(NBT_USES, tag.func_74762_e(NBT_USES) - 1);
            ResourceLocation compName = ResourceLocation.func_208304_a((String)tag.func_74779_i("rootsclassic:effect"));
            if (compName != null && (comp = ComponentManager.getComponentFromName(compName)) != null) {
                IManaCapability manaCap;
                int potency = tag.func_74762_e("rootsclassic:potency");
                int efficiency = tag.func_74762_e("rootsclassic:efficiency");
                int size = tag.func_74762_e("rootsclassic:size");
                PlayerEntity player = (PlayerEntity)caster;
                if (player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof SylvanArmorItem && player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof SylvanArmorItem && player.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof SylvanArmorItem && player.func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof SylvanArmorItem) {
                    ++potency;
                }
                if ((manaCap = (IManaCapability)player.getCapability(RootsCapabilityManager.MANA_CAPABILITY).orElse(null)).getMana() >= comp.getManaCost() / (float)(efficiency + 1)) {
                    manaCap.setMana(manaCap.getMana() - comp.getManaCost() / (float)(efficiency + 1));
                    Vector3d lookVec = caster.func_70040_Z();
                    comp.doEffect(world, (Entity)caster, EnumCastType.SPELL, caster.func_226277_ct_() + 3.0 * lookVec.field_72450_a, caster.func_226278_cu_() + 3.0 * lookVec.field_72448_b, caster.func_226281_cx_() + 3.0 * lookVec.field_72449_c, potency, efficiency, 3.0 + 2.0 * (double)size);
                    if (world.field_72995_K) {
                        for (int i = 0; i < 90; ++i) {
                            double offX = (double)world.field_73012_v.nextFloat() * 0.5 - 0.25;
                            double offY = (double)world.field_73012_v.nextFloat() * 0.5 - 0.25;
                            double offZ = (double)world.field_73012_v.nextFloat() * 0.5 - 0.25;
                            double coeff = (offX + offY + offZ) / 1.5 + 0.5;
                            double dx = (lookVec.field_72450_a + offX) * coeff;
                            double dy = (lookVec.field_72448_b + offY) * coeff;
                            double dz = (lookVec.field_72449_c + offZ) * coeff;
                            if (world.field_73012_v.nextBoolean()) {
                                world.func_195594_a(MagicParticleData.createData(comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c), caster.func_226277_ct_() + dx, caster.func_226278_cu_() + 1.5 + dy, caster.func_226281_cx_() + dz, dx, dy, dz);
                                continue;
                            }
                            world.func_195594_a(MagicParticleData.createData(comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c), caster.func_226277_ct_() + dx, caster.func_226278_cu_() + 1.5 + dy, caster.func_226281_cx_() + dz, dx, dy, dz);
                        }
                    }
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K && Minecraft.func_71410_x().field_71462_r != null) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT tag;
        if (stack.func_77942_o() && stack.func_77973_b() == this && (tag = stack.func_77978_p()).func_74764_b(NBT_USES) && tag.func_74762_e(NBT_USES) <= 0 && entityIn instanceof PlayerEntity) {
            stack.func_190918_g(1);
            ((PlayerEntity)entityIn).func_71029_a(Stats.field_199088_e.func_199076_b((Object)stack.func_77973_b()));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldS, ItemStack newS, boolean slotChanged) {
        if (oldS.func_77942_o() && newS.func_77942_o() && oldS.func_77978_p().func_74779_i("rootsclassic:effect") != newS.func_77978_p().func_74779_i("rootsclassic:effect")) {
            return true;
        }
        return slotChanged;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        ComponentBase comp;
        CompoundNBT tag;
        ResourceLocation componentName;
        if (stack.func_77942_o() && (componentName = ResourceLocation.func_208304_a((String)(tag = stack.func_77978_p()).func_74779_i("rootsclassic:effect"))) != null && (comp = ComponentManager.getComponentFromName(componentName)) != null) {
            int potency = tag.func_74762_e("rootsclassic:potency");
            int efficiency = tag.func_74762_e("rootsclassic:efficiency");
            int size = tag.func_74762_e("rootsclassic:size");
            comp.castingAction((PlayerEntity)player, count, potency, efficiency, size);
            if (player.func_130014_f_().field_72995_K) {
                if (field_77697_d.nextBoolean()) {
                    player.func_130014_f_().func_195594_a(MagicLineParticleData.createData(comp.primaryColor.field_72450_a, comp.primaryColor.field_72448_b, comp.primaryColor.field_72449_c), player.func_226277_ct_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.func_226278_cu_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5) + 1.0, player.func_226281_cx_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_());
                } else {
                    player.func_130014_f_().func_195594_a(MagicLineParticleData.createData(comp.secondaryColor.field_72450_a, comp.secondaryColor.field_72448_b, comp.secondaryColor.field_72449_c), player.func_226277_ct_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.func_226278_cu_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5) + 1.0, player.func_226281_cx_() + 2.0 * ((double)field_77697_d.nextFloat() - 0.5), player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_());
                }
            }
        }
    }

    public static void createData(ItemStack stack, String effect, int potency, int efficiency, int size) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("rootsclassic:effect", effect);
        tag.func_74768_a("rootsclassic:potency", potency);
        tag.func_74768_a("rootsclassic:efficiency", efficiency);
        tag.func_74768_a("rootsclassic:size", size);
        int uses = StaffItem.getMaxUsesBase() + StaffItem.getMaxUsesPerEfficiency() * efficiency;
        tag.func_74768_a(NBT_MAX, uses);
        tag.func_74768_a(NBT_USES, uses);
        stack.func_77982_d(tag);
    }

    public static int getMaxUsesBase() {
        return (Integer)RootsConfig.COMMON.staffUsesBasic.get();
    }

    public static int getMaxUsesPerEfficiency() {
        return (Integer)RootsConfig.COMMON.staffUsesEfficiency.get();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            ComponentBase comp;
            CompoundNBT tag = stack.func_77978_p();
            ResourceLocation compName = ResourceLocation.func_208304_a((String)tag.func_74779_i("rootsclassic:effect"));
            if (compName != null && (comp = ComponentManager.getComponentFromName(compName)) != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.spelltypeheading").func_240702_b_(": ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)comp.getEffectName().func_240699_a_(comp.getTextColor())));
            }
            tooltip.add((ITextComponent)new StringTextComponent("  +" + tag.func_74762_e("rootsclassic:potency") + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.spellpotency")).func_240702_b_(".").func_240699_a_(TextFormatting.RED));
            tooltip.add((ITextComponent)new StringTextComponent("  +" + tag.func_74762_e("rootsclassic:efficiency") + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.spellefficiency")).func_240702_b_(".").func_240699_a_(TextFormatting.RED));
            tooltip.add((ITextComponent)new StringTextComponent("  +" + tag.func_74762_e("rootsclassic:size") + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.spellsize")).func_240702_b_(".").func_240699_a_(TextFormatting.RED));
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add((ITextComponent)new StringTextComponent(tag.func_74762_e(NBT_USES) + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("rootsclassic.tooltip.usesremaining")).func_240702_b_(".").func_240699_a_(TextFormatting.GOLD));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("rootsclassic.error.unset").func_240699_a_(TextFormatting.GRAY));
        }
    }
}

