/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.ritual;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.block.altar.AltarTile;
import elucent.rootsclassic.block.brazier.BrazierTile;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.rituals.RitualBanishRain;
import elucent.rootsclassic.ritual.rituals.RitualCauseRain;
import elucent.rootsclassic.ritual.rituals.RitualCrafting;
import elucent.rootsclassic.ritual.rituals.RitualEngravedSword;
import elucent.rootsclassic.ritual.rituals.RitualFlare;
import elucent.rootsclassic.ritual.rituals.RitualGrow;
import elucent.rootsclassic.ritual.rituals.RitualImbuer;
import elucent.rootsclassic.ritual.rituals.RitualLifeDrain;
import elucent.rootsclassic.ritual.rituals.RitualMassBreed;
import elucent.rootsclassic.ritual.rituals.RitualSacrifice;
import elucent.rootsclassic.ritual.rituals.RitualSummoning;
import elucent.rootsclassic.ritual.rituals.RitualTimeShift;
import elucent.rootsclassic.util.RootsUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualManager {
    public static ArrayList<RitualBase> rituals = new ArrayList();

    public static RitualBase findMatchingByIngredients(AltarTile altar) {
        for (RitualBase ritual : rituals) {
            ArrayList<ItemStack> altarInv = new ArrayList<ItemStack>();
            for (int i = 0; i < altar.inventory.getSlots(); ++i) {
                altarInv.add(altar.inventory.getStackInSlot(i));
            }
            if (!RootsUtil.itemListsMatchWithSize(ritual.getIngredients(), altarInv)) continue;
            return ritual;
        }
        return null;
    }

    public static void addRitual(RitualBase ritual) throws IllegalArgumentException {
        for (RitualBase existing : rituals) {
            if (!ritual.doIngredientsMatch(existing)) continue;
            Roots.LOGGER.error("Duplicate ingredients are not allowed for incoming ritual : " + ritual.getName() + " and existing ritual " + existing.getName());
        }
        rituals.add(ritual);
    }

    public static void reload() {
        rituals.clear();
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "staff_crafting"), 2, 205.0, 86.0, 0.0).setResult(new ItemStack((IItemProvider)RootsRegistry.CRYSTAL_STAFF.get(), 1)).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, -3).addIncense(new ItemStack((IItemProvider)Blocks.field_150402_ci, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.ACACIA_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_150484_ah, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151055_y, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151065_br, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "sylvan_hood_crafting"), 2, 62.0, 138.0, 62.0).setResult(new ItemStack((IItemProvider)RootsRegistry.SYLVAN_HOOD.get(), 1)).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, -3).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 5, 1, 0).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), -5, 1, 0).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, 5).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, -5).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151153_ao, 1)).addIncense(new ItemStack((IItemProvider)Blocks.field_196606_bd, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151024_Q, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_150395_bd, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "sylvan_chest_crafting"), 2, 62.0, 138.0, 62.0).setResult(new ItemStack((IItemProvider)RootsRegistry.SYLVAN_ROBE.get(), 1)).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, -3).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 5, 1, 0).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), -5, 1, 0).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, 5).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, -5).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151153_ao, 1)).addIncense(new ItemStack((IItemProvider)Blocks.field_196606_bd, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151027_R, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_150395_bd, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "sylvan_legs_crafting"), 2, 62.0, 138.0, 62.0).setResult(new ItemStack((IItemProvider)RootsRegistry.SYLVAN_TUNIC.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151153_ao, 1)).addIncense(new ItemStack((IItemProvider)Blocks.field_196606_bd, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151026_S, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_150395_bd, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "sylvan_boots_crafting"), 2, 62.0, 138.0, 62.0).setResult(new ItemStack((IItemProvider)RootsRegistry.SYLVAN_BOOTS.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151153_ao, 1)).addIncense(new ItemStack((IItemProvider)Blocks.field_196606_bd, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151021_T, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_150395_bd, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "wildwood_head_crafting"), 2, 145.0, 115.0, 65.0).setResult(new ItemStack((IItemProvider)RootsRegistry.WILDWOOD_MASK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)Blocks.field_196674_t, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151028_Y, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196662_n, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "wildwood_chest_crafting"), 2, 145.0, 115.0, 65.0).setResult(new ItemStack((IItemProvider)RootsRegistry.WILDWOOD_PLATE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)Blocks.field_196674_t, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151030_Z, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196662_n, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "wildwood_legs_crafting"), 2, 145.0, 115.0, 65.0).setResult(new ItemStack((IItemProvider)RootsRegistry.WILDWOOD_LEGGINGS.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)Blocks.field_196674_t, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151165_aa, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196662_n, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "wildwood_boots_crafting"), 2, 145.0, 115.0, 65.0).setResult(new ItemStack((IItemProvider)RootsRegistry.WILDWOOD_BOOTS.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)Blocks.field_196674_t, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151167_ab, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196662_n, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "accelerator_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((IItemProvider)RootsRegistry.ACCELERATOR_STANDING_STONE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.JUNGLE_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196696_di, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "standing_stone"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((IItemProvider)RootsRegistry.AESTHETIC_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196698_dj, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "entangler_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((IItemProvider)RootsRegistry.ENTANGLER_STANDING_STONE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196700_dk, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "grower_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((IItemProvider)RootsRegistry.GROWER_STANDING_STONE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_150348_b, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "healer_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((IItemProvider)RootsRegistry.HEALER_STANDING_STONE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151073_bk, 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get())).addIngredient(new ItemStack((IItemProvider)Items.field_151137_ax)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196702_dl, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "igniter_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((IItemProvider)RootsRegistry.IGNITER_STANDING_STONE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.ACACIA_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151137_ax, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196700_dk, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "repulsor_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((IItemProvider)RootsRegistry.REPULSOR_STANDING_STONE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.SPRUCE_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196702_dl, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "vacuum_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((IItemProvider)RootsRegistry.VACUUM_STANDING_STONE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.DARK_OAK_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196653_dH)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "runic_focus_crafting"), 2, 109.0, 242.0, 109.0).setResult(new ItemStack((IItemProvider)RootsRegistry.RUNIC_FOCUS.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.SPRUCE_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.ACACIA_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.JUNGLE_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151045_i, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_150348_b, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "runic_focus_charging"), 2, 109.0, 242.0, 109.0).setResult(new ItemStack((IItemProvider)RootsRegistry.CHARGED_RUNIC_FOCUS.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.RUNIC_FOCUS.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151137_ax, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_pickaxe_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((IItemProvider)RootsRegistry.LIVING_PICKAXE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151039_o, 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151074_bl)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_axe_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((IItemProvider)RootsRegistry.LIVING_AXE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151053_p, 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151074_bl, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_sword_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((IItemProvider)RootsRegistry.LIVING_SWORD.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151041_m, 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151074_bl, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_hoe_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((IItemProvider)RootsRegistry.LIVING_HOE.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151017_I, 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151074_bl, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_shovel_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((IItemProvider)RootsRegistry.LIVING_SHOVEL.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151038_n, 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151074_bl, 1)));
        RitualManager.addRitual(new RitualCauseRain(new ResourceLocation("rootsclassic", "cause_rain"), 0, 23.0, 0.0, 138.0).addIncense(new ItemStack((IItemProvider)Blocks.field_150395_bd, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OLD_ROOT.get(), 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196651_dG, 1)));
        RitualManager.addRitual(new RitualBanishRain(new ResourceLocation("rootsclassic", "banish_rain"), 0, 204.0, 159.0, 35.0).addIncense(new ItemStack((IItemProvider)Blocks.field_150395_bd, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.OLD_ROOT.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151015_O, 1)));
        RitualManager.addRitual(new RitualMassBreed(new ResourceLocation("rootsclassic", "mass_breeding"), 0, 148.0, 61.0, 81.0).addIncense(new ItemStack((IItemProvider)Items.field_151172_bF, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151014_N, 1)).addIncense(new ItemStack((IItemProvider)Items.field_196086_aW, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS)));
        RitualManager.addRitual(new RitualLifeDrain(new ResourceLocation("rootsclassic", "life_drain"), 2, 139.0, 22.0, 40.0).addIncense(new ItemStack((IItemProvider)Items.field_151041_m, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151053_p, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.DARK_OAK_BARK.get(), 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.BIRCH_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151065_br, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualImbuer(new ResourceLocation("rootsclassic", "imbuer")).addIngredient(new ItemStack((IItemProvider)RootsRegistry.CRYSTAL_STAFF.get(), 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "cow_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200796_j).addIncense(new ItemStack((IItemProvider)Items.field_151014_N, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151082_bd, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151116_aA, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "pig_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200784_X).addIncense(new ItemStack((IItemProvider)Items.field_151014_N, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151147_al, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151147_al, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "sheep_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200737_ac).addIncense(new ItemStack((IItemProvider)Items.field_151014_N, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_179561_bm, 1)).addIngredient(new ItemStack((IItemProvider)Blocks.field_196556_aL, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "chicken_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200795_i).addIncense(new ItemStack((IItemProvider)Items.field_151014_N, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151076_bf, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151008_G, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "rabbit_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200736_ab).addIncense(new ItemStack((IItemProvider)Items.field_151014_N, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_179558_bo, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_179555_bs, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "zombie_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200725_aD).addIncense(new ItemStack((IItemProvider)Items.field_151044_h, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151078_bh, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151078_bh, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "skeleton_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200741_ag).addIncense(new ItemStack((IItemProvider)Items.field_151044_h, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151032_g, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "spider_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200748_an).addIncense(new ItemStack((IItemProvider)Items.field_151044_h, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151007_F, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151070_bp, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "cave_spider_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200794_h).addIncense(new ItemStack((IItemProvider)Items.field_151044_h, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151007_F, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151071_bq, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "slime_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200743_ai).addIncense(new ItemStack((IItemProvider)Items.field_151044_h, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151123_aH, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151123_aH, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151123_aH, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "creeper_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200797_k).addIncense(new ItemStack((IItemProvider)Items.field_151044_h, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151016_H, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151016_H, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "enderman_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends MobEntity>)EntityType.field_200803_q).addIncense(new ItemStack((IItemProvider)Items.field_151044_h, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151075_bm, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151079_bi, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151079_bi, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualSacrifice(new ResourceLocation("rootsclassic", "sacrifice"), 2, 94.0, 9.0, 56.0).addIncense(new ItemStack((IItemProvider)Items.field_151065_br, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.DARK_OAK_BARK.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151145_ak, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151040_l, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151103_aS, 1)));
        RitualManager.addRitual(new RitualFlare(new ResourceLocation("rootsclassic", "flare"), 1, 255.0, 91.0, 25.0).addIncense(new ItemStack((IItemProvider)Items.field_151016_H, 1)).addIncense(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151145_ak, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151044_h, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_196155_l, 1)));
        RitualManager.addRitual(new RitualGrow(new ResourceLocation("rootsclassic", "grow"), 0, 82.0, 212.0, 47.0).addIncense(new ItemStack((IItemProvider)Items.field_151015_O, 1)).addIncense(new ItemStack((IItemProvider)Items.field_185164_cV, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151174_bG, 1)).addIncense(new ItemStack((IItemProvider)Items.field_151172_bF, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151137_ax, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_196106_bc, 1)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1)));
        RitualManager.addRitual(new RitualEngravedSword(new ResourceLocation("rootsclassic", "engraved_crafting"), 2, 104.0, 106.0, 107.0).setResult(new ItemStack((IItemProvider)RootsRegistry.ENGRAVED_BLADE.get())).addIncense(new ItemStack((IItemProvider)Items.field_151153_ao)).addIncense(new ItemStack((IItemProvider)Items.field_151150_bK, 1)).addIngredient(new ItemStack((IItemProvider)Items.field_151052_q)).addIngredient(new ItemStack((IItemProvider)RootsRegistry.RUNIC_FOCUS.get())).addIngredient(new ItemStack((IItemProvider)Items.field_151114_aO)));
        RitualManager.addRitual(new RitualTimeShift(new ResourceLocation("rootsclassic", "time_shift"), 1, 240.0, 245.0, 88.0).addIngredient(new ItemStack((IItemProvider)Items.field_151113_aN)).addIngredient(new ItemStack((IItemProvider)Items.field_151042_j)).addIncense(new ItemStack((IItemProvider)Items.field_151113_aN)).setSecondaryColor(252.0, 162.0, 35.0));
    }

    public static RitualBase getRitualFromName(ResourceLocation name) {
        if (name != null) {
            for (RitualBase ritual : rituals) {
                if (!ritual.getName().equals((Object)name)) continue;
                return ritual;
            }
        }
        return null;
    }

    public static ArrayList<ItemStack> getIncenses(World world, BlockPos pos) {
        ArrayList<ItemStack> test = new ArrayList<ItemStack>();
        for (int i = -4; i < 5; ++i) {
            for (int j = -4; j < 5; ++j) {
                BrazierTile brazierTile;
                if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() != RootsRegistry.BRAZIER.get() || world.func_175625_s(pos.func_177982_a(i, 0, j)) == null || !(brazierTile = (BrazierTile)world.func_175625_s(pos.func_177982_a(i, 0, j))).isBurning()) continue;
                test.add(brazierTile.getHeldItem());
            }
        }
        return test;
    }
}

