/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RootsUtil {
    private static final Random random = new Random();

    public static double randomDouble(double min, double max) {
        double range = max - min;
        double scale = random.nextDouble() * range;
        return scale + min;
    }

    public static BlockPos getRayTrace(World world, PlayerEntity player, int reachDistance) {
        double x = player.func_226277_ct_();
        double y = player.func_226278_cu_() + (double)player.func_70047_e();
        double z = player.func_226281_cx_();
        int i = 0;
        while ((double)i < (double)reachDistance * 10.0) {
            if (world.func_180495_p(new BlockPos(x += player.func_70040_Z().field_72450_a * 0.1, y += player.func_70040_Z().field_72448_b * 0.1, z += player.func_70040_Z().field_72449_c * 0.1)).func_177230_c() != Blocks.field_150350_a) {
                return new BlockPos(x, y, z);
            }
            ++i;
        }
        return new BlockPos(x, y, z);
    }

    public static void addTickTracking(Entity entity) {
        if (entity.getPersistentData().func_74764_b("RMOD_trackTicks")) {
            entity.getPersistentData().func_74768_a("RMOD_trackTicks", entity.getPersistentData().func_74762_e("RMOD_trackTicks") + 1);
        } else {
            entity.getPersistentData().func_74768_a("RMOD_trackTicks", 1);
        }
    }

    public static void decrementTickTracking(Entity entity) {
        if (entity.getPersistentData().func_74764_b("RMOD_trackTicks")) {
            entity.getPersistentData().func_74768_a("RMOD_trackTicks", entity.getPersistentData().func_74762_e("RMOD_trackTicks") - 1);
            if (entity.getPersistentData().func_74762_e("RMOD_trackTicks") == 0) {
                entity.func_184197_b("RMOD_trackTicks");
            }
        }
    }

    public static Entity getRayTraceEntity(World world, PlayerEntity player, int reachDistance) {
        double x = player.func_226277_ct_();
        double y = player.func_226278_cu_() + (double)player.func_70047_e();
        double z = player.func_226281_cx_();
        int i = 0;
        while ((double)i < (double)reachDistance * 10.0) {
            List entities;
            if ((entities = world.func_217357_a(Entity.class, new AxisAlignedBB((x += player.func_70040_Z().field_72450_a * 0.1) - 0.1, (y += player.func_70040_Z().field_72448_b * 0.1) - 0.1, (z += player.func_70040_Z().field_72449_c * 0.1) - 0.1, x + 0.1, y + 0.1, z + 0.1))).size() > 0 && ((Entity)entities.get(0)).func_110124_au() != player.func_110124_au()) {
                return (Entity)entities.get(0);
            }
            ++i;
        }
        return null;
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static boolean itemListMatchInventoryWithSize(IInventory i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (int i3 = 0; i3 < i1.func_70302_i_(); ++i3) {
            recipe.add(i1.func_70301_a(i3));
        }
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!((ItemStack)recipe.get(i)).func_190926_b()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).func_190926_b()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() == recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i4 = 0; i4 < recipe.size() && !endIteration; ++i4) {
                    if (!itemStack.func_77969_a((ItemStack)recipe.get(i4))) continue;
                    recipe.remove(i4);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListMatchInventory(IInventory i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (int i3 = 0; i3 < i1.func_70302_i_(); ++i3) {
            recipe.add(i1.func_70301_a(i3));
        }
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!((ItemStack)recipe.get(i)).func_190926_b()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).func_190926_b()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i4 = 0; i4 < recipe.size() && !endIteration; ++i4) {
                    if (!itemStack.func_77969_a((ItemStack)recipe.get(i4))) continue;
                    recipe.remove(i4);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListMatchesIngredients(List<Ingredient> i1, List<ItemStack> i2) {
        int i;
        ArrayList<Ingredient> recipe = new ArrayList<Ingredient>(i1);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).func_203189_d()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).func_190926_b()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!recipe.get(i3).test(itemStack)) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListMatchesIngredientsWithSize(List<Ingredient> i1, List<ItemStack> i2) {
        int i;
        ArrayList<Ingredient> recipe = new ArrayList<Ingredient>(i1);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).func_203189_d()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).func_190926_b()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() == recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!recipe.get(i3).test(itemStack)) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListsMatchWithSize(List<ItemStack> i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>(i1);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).func_190926_b()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).func_190926_b()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() == recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!itemStack.func_77969_a(recipe.get(i3))) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean itemListsMatch(List<ItemStack> i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>(i1);
        ArrayList<ItemStack> available = new ArrayList<ItemStack>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).func_190926_b()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).func_190926_b()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (ItemStack itemStack : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!itemStack.func_77969_a(recipe.get(i3))) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static boolean ingredientListMatch(List<Ingredient> i1, List<Ingredient> i2) {
        int i;
        ArrayList<Ingredient> recipe = new ArrayList<Ingredient>(i1);
        ArrayList<Ingredient> available = new ArrayList<Ingredient>(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (!recipe.get(i).func_203189_d()) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (!available.get(i).func_203189_d()) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (Ingredient ingredient : available) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!ingredient.func_193365_a()[0].func_77969_a(recipe.get(i3).func_193365_a()[0])) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static void randomlyRepair(Random rnd, ItemStack stack) {
        if (stack.func_77951_h() && rnd.nextInt(80) == 0) {
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }
}

