/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.brazier;

import elucent.rootsclassic.blockentity.BEBase;
import elucent.rootsclassic.registry.RootsRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BrazierBlockEntity
extends BEBase {
    private static final int TOTAL_BURN_TIME = 2400;
    private int ticker = 0;
    private boolean burning = false;
    private int progress = 0;
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);

    public BrazierBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public BrazierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RootsRegistry.BRAZIER_TILE.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("InventoryHandler"));
        if (tag.m_128441_("burning")) {
            this.setBurning(tag.m_128471_("burning"));
        }
        if (tag.m_128441_("progress")) {
            this.progress = tag.m_128451_("progress");
        }
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        tag = super.m_6945_(tag);
        tag.m_128365_("InventoryHandler", (Tag)this.inventory.serializeNBT());
        tag.m_128379_("burning", this.isBurning());
        tag.m_128405_("progress", this.progress);
        return tag;
    }

    @Override
    public void breakBlock(Level world, BlockPos pos, BlockState state, Player player) {
        if (this.getHeldItem() != null && !this.isBurning()) {
            this.dropContaining();
        }
        this.m_7651_();
    }

    private void dropContaining() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, this.getHeldItem()));
        }
        this.setHeldItem(ItemStack.f_41583_);
    }

    private void notifyUpdate(BlockState state) {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), state, this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    @Override
    public InteractionResult activate(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, ItemStack playerItem, BlockHitResult hit) {
        if (playerItem.m_41619_()) {
            if (!this.getHeldItem().m_41619_() && !this.isBurning()) {
                if (player.m_6144_()) {
                    player.m_5661_(this.getHeldItem().m_41786_(), true);
                } else {
                    this.dropContaining();
                    this.notifyUpdate(state);
                    player.m_5661_((Component)new TranslatableComponent("rootsclassic.brazier.burning.empty"), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isBurning() && player.m_6144_()) {
                player.m_5661_((Component)new TranslatableComponent("rootsclassic.brazier.burning.off"), true);
                this.stopBurning();
                this.notifyUpdate(state);
                return InteractionResult.SUCCESS;
            }
        } else if (playerItem.m_41720_() == Items.f_42409_) {
            if (!this.getHeldItem().m_41619_()) {
                this.startBurning();
                player.m_5661_((Component)new TranslatableComponent("rootsclassic.brazier.burning.on"), true);
                this.notifyUpdate(state);
                return InteractionResult.SUCCESS;
            }
        } else if (this.getHeldItem().m_41619_()) {
            this.setHeldItem(new ItemStack((ItemLike)playerItem.m_41720_(), 1));
            if (playerItem.m_41782_()) {
                this.getHeldItem().m_41751_(playerItem.m_41783_());
            }
            playerItem.m_41774_(1);
            player.m_5661_((Component)new TranslatableComponent("rootsclassic.brazier.burning.added"), true);
            this.notifyUpdate(state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void startBurning() {
        this.setBurning(true);
        this.progress = 2400;
    }

    private void stopBurning() {
        this.setBurning(false);
        this.progress = 0;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BrazierBlockEntity tile) {
        tile.setTicker(tile.getTicker() + (tile.isBurning() ? 12 : 3));
        if (tile.progress > 0) {
            --tile.progress;
            if (tile.progress <= 0) {
                tile.setBurning(false);
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
        }
        if (tile.getTicker() > 360) {
            tile.setTicker(0);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BrazierBlockEntity tile) {
        tile.setTicker(tile.getTicker() + (tile.isBurning() ? 12 : 3));
        if (tile.progress > 0) {
            --tile.progress;
            if (level.f_46443_) {
                if (tile.progress % 2 == 0) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, level.f_46441_.nextDouble() * 0.0625 + 0.0625, 0.0);
                }
                if (tile.progress % 20 == 0) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                }
            }
            if (tile.progress <= 0) {
                tile.setBurning(false);
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
        }
        if (tile.getTicker() > 360) {
            tile.setTicker(0);
        }
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burning) {
        this.burning = burning;
    }

    public int getTicker() {
        return this.ticker;
    }

    public void setTicker(int ticker) {
        this.ticker = ticker;
    }

    public ItemStack getHeldItem() {
        return this.inventory.getStackInSlot(0);
    }

    public void setHeldItem(ItemStack heldItem) {
        this.inventory.setStackInSlot(0, heldItem);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
    }
}

