/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.blockentity;

import elucent.rootsclassic.blockentity.BEBase;
import elucent.rootsclassic.client.particles.MagicAuraParticleData;
import elucent.rootsclassic.item.GrowthPowderItem;
import elucent.rootsclassic.registry.RootsRegistry;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GrowerStandingStoneTile
extends BEBase {
    private static final double PCT_CHANCE_PER_BLOCK = 0.03;
    private static final int TICK_SPEED = 100;
    private static final int MAX_TICKER = 10000;
    private static final int RADIUS = 4;
    private int ticker = 0;

    public GrowerStandingStoneTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public GrowerStandingStoneTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)RootsRegistry.GROWER_STANDING_STONE_TILE.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        return tag;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GrowerStandingStoneTile tile) {
        tile.updateTicker();
        if (tile.ticker % 100 == 0) {
            tile.applyGrowthToArea();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, GrowerStandingStoneTile tile) {
        tile.updateTicker();
        tile.spawnParticles();
    }

    private void updateTicker() {
        ++this.ticker;
        if (this.ticker >= 10000) {
            this.ticker = 0;
        }
    }

    private void applyGrowthToArea() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int xp = -4; xp <= 4; ++xp) {
            for (int zp = -4; zp <= 4; ++zp) {
                positions.add(this.m_58899_().m_142082_(xp, -1, zp));
                positions.add(this.m_58899_().m_142082_(xp, -2, zp));
            }
        }
        Collections.shuffle(positions);
        for (BlockPos pos : positions) {
            if (!(this.f_58857_.f_46441_.nextDouble() < 0.03)) continue;
            GrowthPowderItem.applyGrowthHere(this.f_58857_, pos);
        }
    }

    private void spawnParticles() {
        if (this.ticker % 5 == 0 && this.f_58857_.f_46443_) {
            for (double i = 0.0; i < 720.0; i += 45.0) {
                double xShift = 0.5 * Math.sin(Math.PI * (i / 360.0));
                double zShift = 0.5 * Math.cos(Math.PI * (i / 360.0));
                this.f_58857_.m_7106_(MagicAuraParticleData.createData(32.0, 255.0, 32.0), (double)this.f_58858_.m_123341_() + 0.5 + xShift, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5 + zShift, 0.0, 0.0, 0.0);
            }
        }
    }
}

