/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.event;

import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.util.RootsUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ComponentSpellsEvent {
    public static int TICKS_PER_MANA_REGEN = 5;

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof Player) {
            this.wildwoodArmorRegenFullset((Player)entity);
            this.tickManaRegen(entity);
        }
        this.tickSkipMovementCurse(event, entity);
    }

    private void tickSkipMovementCurse(LivingEvent.LivingUpdateEvent event, LivingEntity entity) {
        int skipTicks;
        CompoundTag persistentData = entity.getPersistentData();
        if (persistentData.m_128441_("RMOD_trackTicks") && persistentData.m_128441_("rootsclassic:RMOD_skipTicks") && (skipTicks = persistentData.m_128451_("rootsclassic:RMOD_skipTicks")) > 0) {
            persistentData.m_128405_("rootsclassic:RMOD_skipTicks", skipTicks - 1);
            if (skipTicks <= 0) {
                persistentData.m_128473_("rootsclassic:RMOD_skipTicks");
                RootsUtil.decrementTickTracking((Entity)entity);
            }
            event.setCanceled(true);
        }
    }

    private void tickManaRegen(LivingEntity entity) {
        if (entity.f_19797_ % TICKS_PER_MANA_REGEN == 0) {
            entity.getCapability(RootsCapabilityManager.MANA_CAPABILITY).ifPresent(cap -> cap.setMana(cap.getMana() + 1.0f));
        }
    }

    private void wildwoodArmorRegenFullset(Player entity) {
        ItemStack head = entity.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = entity.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = entity.m_6844_(EquipmentSlot.FEET);
        if (head.m_41720_() == RootsRegistry.WILDWOOD_MASK.get() && chest.m_41720_() == RootsRegistry.WILDWOOD_PLATE.get() && legs.m_41720_() == RootsRegistry.WILDWOOD_LEGGINGS.get() && feet.m_41720_() == RootsRegistry.WILDWOOD_BOOTS.get() && entity.f_19853_.f_46441_.nextDouble() < 0.02 && entity.m_21223_() < entity.m_21233_()) {
            entity.m_5634_(1.0f);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        CompoundTag persistentData = event.getEntityLiving().getPersistentData();
        if (persistentData.m_128441_("rootsclassic:RMOD_dropItems") && !persistentData.m_128471_("rootsclassic:RMOD_dropItems")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingXP(LivingExperienceDropEvent event) {
        CompoundTag persistentData = event.getEntityLiving().getPersistentData();
        if (persistentData.m_128441_("rootsclassic:RMOD_dropItems") && !persistentData.m_128471_("rootsclassic:RMOD_dropItems")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        ItemStack sword;
        Player player;
        LivingEntity livingEntity;
        LivingEntity entityLiving = event.getEntityLiving();
        CompoundTag persistentData = entityLiving.getPersistentData();
        if (persistentData.m_128441_("rootsclassic:RMOD_vuln")) {
            event.setAmount((float)((double)event.getAmount() * (1.0 + persistentData.m_128459_("rootsclassic:RMOD_vuln"))));
            persistentData.m_128473_("rootsclassic:RMOD_vuln");
        }
        if (persistentData.m_128441_("rootsclassic:RMOD_thornsDamage") && event.getSource().m_7639_() instanceof LivingEntity) {
            ((LivingEntity)event.getSource().m_7639_()).m_6469_(DamageSource.f_19314_, persistentData.m_128457_("rootsclassic:RMOD_thornsDamage"));
            persistentData.m_128473_("rootsclassic:RMOD_thornsDamage");
            RootsUtil.decrementTickTracking((Entity)entityLiving);
        }
        if ((livingEntity = entityLiving) instanceof Player && !(player = (Player)livingEntity).m_150109_().m_36056_().m_41619_() && player.m_150109_().m_36056_().m_41720_() == RootsRegistry.ENGRAVED_BLADE.get() && (sword = player.m_150109_().m_36056_()).m_41782_() && sword.m_41783_().m_128441_("shadowstep")) {
            int stepLvl = sword.m_41783_().m_128451_("shadowstep");
            double chance = (double)stepLvl * 12.5;
            if ((double)player.m_20193_().f_46441_.nextInt(100) < chance) {
                event.setCanceled(true);
            }
        }
        if (event.getSource().m_7639_() instanceof Player && !event.getEntity().m_20193_().f_46443_ && !(player = (Player)event.getSource().m_7639_()).m_150109_().m_36056_().m_41619_() && player.m_150109_().m_36056_().m_41720_() == RootsRegistry.ENGRAVED_BLADE.get() && (sword = player.m_150109_().m_36056_()).m_41782_()) {
            float currentAmount;
            float amount;
            CompoundTag tag = sword.m_41783_();
            if (tag.m_128441_("aquatic")) {
                int aquaLvl = tag.m_128451_("aquatic");
                amount = (float)aquaLvl * 0.5f;
                event.getEntity().m_6469_(DamageSource.f_19312_, amount);
            }
            if (tag.m_128441_("holy") && entityLiving.m_6336_() == MobType.f_21641_) {
                int holyLvl = tag.m_128451_("holy");
                amount = (float)holyLvl * 1.5f;
                currentAmount = event.getAmount();
                event.setAmount(currentAmount + amount);
            }
            if (tag.m_128441_("spikes")) {
                int spikeLvl = tag.m_128451_("spikes");
                amount = spikeLvl;
                currentAmount = event.getAmount();
                event.setAmount(currentAmount + amount);
            }
        }
    }
}

