/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.client.particles.MagicLineParticleData;
import elucent.rootsclassic.client.particles.MagicParticleData;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.component.EnumCastType;
import elucent.rootsclassic.item.IManaRelatedItem;
import elucent.rootsclassic.item.SylvanArmorItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class CrystalStaffItem
extends Item
implements IManaRelatedItem {
    public CrystalStaffItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity caster, int timeLeft) {
        if (timeLeft < 71988 && stack.m_41782_()) {
            Player player = (Player)caster;
            ResourceLocation compName = ResourceLocation.m_135820_((String)CrystalStaffItem.getEffect(stack));
            if (compName != null) {
                IManaCapability manaCap;
                ComponentBase comp = ComponentManager.getComponentFromName(compName);
                if (comp == null || !caster.getCapability(RootsCapabilityManager.MANA_CAPABILITY).isPresent()) {
                    return;
                }
                int potency = CrystalStaffItem.getPotency(stack) + 1;
                int efficiency = CrystalStaffItem.getEfficiency(stack);
                int size = CrystalStaffItem.getSize(stack);
                if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof SylvanArmorItem && player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof SylvanArmorItem && player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof SylvanArmorItem && player.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof SylvanArmorItem) {
                    ++potency;
                }
                if ((manaCap = (IManaCapability)player.getCapability(RootsCapabilityManager.MANA_CAPABILITY).orElse(null)).getMana() >= comp.getManaCost() / (float)(efficiency + 1)) {
                    manaCap.setMana(manaCap.getMana() - comp.getManaCost() / (float)(efficiency + 1));
                    comp.doEffect(world, (Entity)caster, EnumCastType.SPELL, caster.m_20185_() + 3.0 * caster.m_20154_().f_82479_, caster.m_20186_() + 3.0 * caster.m_20154_().f_82480_, caster.m_20189_() + 3.0 * caster.m_20154_().f_82481_, potency, efficiency, 3.0 + 2.0 * (double)size);
                    if (world.f_46443_) {
                        for (int i = 0; i < 90; ++i) {
                            double offX = (double)world.f_46441_.nextFloat() * 0.5 - 0.25;
                            double offY = (double)world.f_46441_.nextFloat() * 0.5 - 0.25;
                            double offZ = (double)world.f_46441_.nextFloat() * 0.5 - 0.25;
                            double coeff = (offX + offY + offZ) / 1.5 + 0.5;
                            double dx = (caster.m_20154_().f_82479_ + offX) * coeff;
                            double dy = (caster.m_20154_().f_82480_ + offY) * coeff;
                            double dz = (caster.m_20154_().f_82481_ + offZ) * coeff;
                            if (world.f_46441_.nextBoolean()) {
                                world.m_7106_(MagicParticleData.createData(comp.primaryColor.f_82479_, comp.primaryColor.f_82480_, comp.primaryColor.f_82481_), caster.m_20185_() + dx, caster.m_20186_() + 1.5 + dy, caster.m_20189_() + dz, dx, dy, dz);
                                continue;
                            }
                            world.m_7106_(MagicParticleData.createData(comp.secondaryColor.f_82479_, comp.secondaryColor.f_82480_, comp.secondaryColor.f_82481_), caster.m_20185_() + dx, caster.m_20186_() + 1.5 + dy, caster.m_20189_() + dz, dx, dy, dz);
                        }
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (!player.m_6144_()) {
                if (world.f_46443_ && Minecraft.m_91087_().f_91080_ != null) {
                    return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
                }
                player.m_6672_(hand);
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            tag.m_128405_("rootsclassic:selected", tag.m_128451_("rootsclassic:selected") + 1);
            if (tag.m_128451_("rootsclassic:selected") > 4) {
                tag.m_128405_("rootsclassic:selected", 1);
            }
            stack.m_41751_(tag);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldS, ItemStack newS, boolean slotChanged) {
        if (oldS.m_41782_() && newS.m_41782_() && (!CrystalStaffItem.getEffect(oldS).equals(CrystalStaffItem.getEffect(newS)) || oldS.m_41783_().m_128451_("rootsclassic:selected") != newS.m_41783_().m_128451_("rootsclassic:selected") || slotChanged)) {
            return true;
        }
        return slotChanged;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (stack.m_41782_()) {
            ComponentBase comp;
            ResourceLocation componentName;
            CompoundTag tag = stack.m_41783_();
            String effect = CrystalStaffItem.getEffect(stack);
            if (effect != null && (componentName = ResourceLocation.m_135820_((String)effect)) != null && (comp = ComponentManager.getComponentFromName(componentName)) != null) {
                int potency = tag.m_128451_("rootsclassic:potency");
                int efficiency = tag.m_128451_("rootsclassic:efficiency");
                int size = tag.m_128451_("rootsclassic:size");
                comp.castingAction((Player)player, count, potency, efficiency, size);
                if (player.m_20193_().f_46443_) {
                    if (player.m_21187_().nextBoolean()) {
                        player.m_20193_().m_7106_(MagicLineParticleData.createData(comp.primaryColor.f_82479_, comp.primaryColor.f_82480_, comp.primaryColor.f_82481_), player.m_20185_() + 2.0 * ((double)player.m_21187_().nextFloat() - 0.5), player.m_20186_() + 2.0 * ((double)player.m_21187_().nextFloat() - 0.5) + 1.0, player.m_20189_() + 2.0 * ((double)player.m_21187_().nextFloat() - 0.5), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
                    } else {
                        player.m_20193_().m_7106_(MagicLineParticleData.createData(comp.secondaryColor.f_82479_, comp.secondaryColor.f_82480_, comp.secondaryColor.f_82481_), player.m_20185_() + 2.0 * ((double)player.m_21187_().nextFloat() - 0.5), player.m_20186_() + 2.0 * ((double)player.m_21187_().nextFloat() - 0.5) + 1.0, player.m_20189_() + 2.0 * ((double)player.m_21187_().nextFloat() - 0.5), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
                    }
                }
            }
        }
    }

    public static void createData(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("rootsclassic:selected", 1);
        tag.m_128405_("rootsclassic:potency1", 0);
        tag.m_128405_("rootsclassic:potency2", 0);
        tag.m_128405_("rootsclassic:potency3", 0);
        tag.m_128405_("rootsclassic:potency4", 0);
        tag.m_128405_("rootsclassic:efficiency1", 0);
        tag.m_128405_("rootsclassic:efficiency2", 0);
        tag.m_128405_("rootsclassic:efficiency3", 0);
        tag.m_128405_("rootsclassic:efficiency4", 0);
        tag.m_128405_("rootsclassic:size1", 0);
        tag.m_128405_("rootsclassic:size2", 0);
        tag.m_128405_("rootsclassic:size3", 0);
        tag.m_128405_("rootsclassic:size4", 0);
        tag.m_128359_("rootsclassic:effect1", "");
        tag.m_128359_("rootsclassic:effect2", "");
        tag.m_128359_("rootsclassic:effect3", "");
        tag.m_128359_("rootsclassic:effect4", "");
        stack.m_41751_(tag);
    }

    public static void addEffect(ItemStack stack, int slot, String effect, int potency, int efficiency, int size) {
        CompoundTag tag = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        tag.m_128359_("rootsclassic:effect" + slot, effect);
        tag.m_128405_("rootsclassic:potency" + slot, potency);
        tag.m_128405_("rootsclassic:efficiency" + slot, efficiency);
        tag.m_128405_("rootsclassic:size" + slot, size);
        stack.m_41751_(tag);
    }

    public static Integer getPotency(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128451_("rootsclassic:potency" + tag.m_128451_("rootsclassic:selected"));
        }
        return 0;
    }

    public static Integer getEfficiency(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128451_("rootsclassic:efficiency" + tag.m_128451_("rootsclassic:selected"));
        }
        return 0;
    }

    public static Integer getSize(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128451_("rootsclassic:size" + tag.m_128451_("rootsclassic:selected"));
        }
        return 0;
    }

    public static String getEffect(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128461_("rootsclassic:effect" + tag.m_128451_("rootsclassic:selected"));
        }
        return null;
    }

    public static String getEffect(ItemStack stack, int slot) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128461_("rootsclassic:effect" + slot);
        }
        return null;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_()) {
            ComponentBase comp;
            ResourceLocation compName;
            String effect = CrystalStaffItem.getEffect(stack);
            if (effect != null && (compName = ResourceLocation.m_135820_((String)effect)) != null && (comp = ComponentManager.getComponentFromName(compName)) != null) {
                tooltip.add((Component)new TranslatableComponent("rootsclassic.tooltip.spelltypeheading").m_130946_(": ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)comp.getEffectName().m_130940_(comp.getTextColor())));
            }
            tooltip.add((Component)new TextComponent("  +" + CrystalStaffItem.getPotency(stack) + " ").m_7220_((Component)new TranslatableComponent("rootsclassic.tooltip.spellpotency")).m_130946_(".").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)new TextComponent("  +" + CrystalStaffItem.getEfficiency(stack) + " ").m_7220_((Component)new TranslatableComponent("rootsclassic.tooltip.spellefficiency")).m_130946_(".").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)new TextComponent("  +" + CrystalStaffItem.getSize(stack) + " ").m_7220_((Component)new TranslatableComponent("rootsclassic.tooltip.spellsize")).m_130946_(".").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)new TranslatableComponent("rootsclassic.error.unset").m_130940_(ChatFormatting.GRAY));
        }
    }
}

