/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.ritual;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.block.brazier.BrazierBlockEntity;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.ritual.RitualManager;
import elucent.rootsclassic.util.RootsUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public abstract class RitualBase {
    private static final int RADIUS = 4;
    private ArrayList<Block> blocks = new ArrayList();
    private ArrayList<BlockPos> positionsRelative = new ArrayList();
    private List<ItemStack> incenses = new ArrayList<ItemStack>();
    private List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private Vec3 color = new Vec3(255.0, 255.0, 255.0);
    private Vec3 secondaryColor = new Vec3(255.0, 255.0, 255.0);
    private final ResourceLocation name;
    private int level;

    public RitualBase(ResourceLocation parName, int level, double r, double g, double b) {
        if (RitualManager.getRitualFromName(parName) != null) {
            throw new IllegalArgumentException("No duplicate names for rituals");
        }
        this.name = parName;
        this.setPrimaryColor(r, g, b);
        this.setSecondaryColor(r, g, b);
        this.setLevel(level);
    }

    public void setLevel(int level) {
        if (level < 0 || level > 2) {
            throw new IllegalArgumentException("Level must be 0, 1 or 2");
        }
        this.blocks = new ArrayList();
        this.level = level;
        if (level >= 1) {
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, -3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, -3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 0);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 0);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, 3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, -3);
        }
        if (level == 2) {
            this.addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 5, 1, 0);
            this.addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), -5, 1, 0);
            this.addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, 5);
            this.addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, -5);
        }
    }

    public RitualBase addRitualPillar(Block b, int x, int y, int z) {
        this.getBlocks().add(b);
        this.getPositionsRelative().add(new BlockPos(x, y, z));
        return this;
    }

    public RitualBase addIngredient(ItemStack i) {
        this.getIngredients().add(i);
        return this;
    }

    public RitualBase addIncense(ItemStack i) {
        this.getIncenses().add(i);
        return this;
    }

    public boolean doIngredientsMatch(RitualBase ritual) {
        return RootsUtil.itemListsMatch(this.getIngredients(), ritual.getIngredients());
    }

    public abstract void doEffect(Level var1, BlockPos var2, Container var3, List<ItemStack> var4);

    public boolean verifyPositionBlocks(Level world, BlockPos pos) {
        if (this.getPositionsRelative().size() > 0) {
            for (int i = 0; i < this.getPositionsRelative().size(); ++i) {
                BlockPos loopPos = this.getPositionsRelative().get(i);
                Block loopBlock = this.getBlocks().get(i);
                BlockPos loopPosOffset = pos.m_142082_(loopPos.m_123341_(), loopPos.m_123342_(), loopPos.m_123343_());
                if (world.m_8055_(loopPosOffset).m_60734_() == loopBlock) continue;
                Roots.LOGGER.info(this.level + " level recipe has Missing block " + loopBlock + " at position " + loopPosOffset);
                return false;
            }
        }
        return true;
    }

    public List<BrazierBlockEntity> getRecipeBraziers(Level world, BlockPos pos) {
        ArrayList<BrazierBlockEntity> links = new ArrayList<BrazierBlockEntity>();
        for (int i = -4; i <= 4; ++i) {
            for (int j = -4; j <= 4; ++j) {
                BlockEntity tileHere;
                if (world.m_8055_(pos.m_142082_(i, 0, j)).m_60734_() != RootsRegistry.BRAZIER.get() || !((tileHere = world.m_7702_(pos.m_142082_(i, 0, j))) instanceof BrazierBlockEntity)) continue;
                links.add((BrazierBlockEntity)tileHere);
            }
        }
        return links;
    }

    public boolean incenseMatches(Level world, BlockPos pos) {
        ArrayList<ItemStack> incenseFromNearby = new ArrayList<ItemStack>();
        List<BrazierBlockEntity> braziers = this.getRecipeBraziers(world, pos);
        for (BrazierBlockEntity brazier : braziers) {
            if (brazier.getHeldItem().m_41619_()) continue;
            incenseFromNearby.add(brazier.getHeldItem());
        }
        return RootsUtil.itemListsMatch(this.getIncenses(), incenseFromNearby);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[A] ");
        for (ItemStack mat : this.getIngredients()) {
            s.append(mat.m_41786_().getString()).append("; ");
        }
        s.append("[I] ");
        for (ItemStack mat : this.getIncenses()) {
            s.append(mat.m_41786_().getString()).append("; ");
        }
        return s.toString();
    }

    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<ItemStack> ingredients) throws IllegalArgumentException {
        if (ingredients.size() == 0 || ingredients.size() > 3) {
            throw new IllegalArgumentException("Invalid ritual ingredients, must be in range [1,3]");
        }
        this.ingredients = ingredients;
    }

    public List<ItemStack> getIncenses() {
        return this.incenses;
    }

    public void setIncenses(List<ItemStack> incenses) throws IllegalArgumentException {
        if (incenses.size() == 0 || incenses.size() > 4) {
            throw new IllegalArgumentException("Invalid ritual incense, must be in range [1,4]");
        }
        this.incenses = incenses;
    }

    public ArrayList<BlockPos> getPositionsRelative() {
        return this.positionsRelative;
    }

    public void setPositionsRelative(ArrayList<BlockPos> positionsRelative) {
        this.positionsRelative = positionsRelative;
    }

    public ArrayList<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<Block> blocks) {
        this.blocks = blocks;
    }

    public Vec3 getColor() {
        return this.color;
    }

    public void setPrimaryColor(double r, double g, double b) {
        this.color = this.buildColor(r, g, b);
    }

    public Vec3 getSecondaryColor() {
        return this.secondaryColor;
    }

    public RitualBase setSecondaryColor(double r, double g, double b) {
        this.secondaryColor = this.buildColor(r, g, b);
        return this;
    }

    private Vec3 buildColor(double r, double g, double b) throws IllegalArgumentException {
        if (r < 0.0 || r > 255.0 || g < 0.0 || g > 255.0 || b < 0.0 || b > 255.0) {
            throw new IllegalArgumentException("Invalid color value use [0, 255]");
        }
        return new Vec3(r, g, b);
    }

    public ResourceLocation getName() {
        return this.name;
    }
}

