/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.ritual;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.block.altar.AltarBlockEntity;
import elucent.rootsclassic.block.brazier.BrazierBlockEntity;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.rituals.RitualBanishRain;
import elucent.rootsclassic.ritual.rituals.RitualCauseRain;
import elucent.rootsclassic.ritual.rituals.RitualCrafting;
import elucent.rootsclassic.ritual.rituals.RitualEngravedSword;
import elucent.rootsclassic.ritual.rituals.RitualFlare;
import elucent.rootsclassic.ritual.rituals.RitualGrow;
import elucent.rootsclassic.ritual.rituals.RitualImbuer;
import elucent.rootsclassic.ritual.rituals.RitualLifeDrain;
import elucent.rootsclassic.ritual.rituals.RitualMassBreed;
import elucent.rootsclassic.ritual.rituals.RitualSacrifice;
import elucent.rootsclassic.ritual.rituals.RitualSummoning;
import elucent.rootsclassic.ritual.rituals.RitualTimeShift;
import elucent.rootsclassic.util.RootsUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class RitualManager {
    public static ArrayList<RitualBase> rituals = new ArrayList();

    public static RitualBase findMatchingByIngredients(AltarBlockEntity altar) {
        for (RitualBase ritual : rituals) {
            ArrayList<ItemStack> altarInv = new ArrayList<ItemStack>();
            for (int i = 0; i < altar.inventory.getSlots(); ++i) {
                altarInv.add(altar.inventory.getStackInSlot(i));
            }
            if (!RootsUtil.itemListsMatchWithSize(ritual.getIngredients(), altarInv)) continue;
            return ritual;
        }
        return null;
    }

    public static void addRitual(RitualBase ritual) throws IllegalArgumentException {
        for (RitualBase existing : rituals) {
            if (!ritual.doIngredientsMatch(existing)) continue;
            Roots.LOGGER.error("Duplicate ingredients are not allowed for incoming ritual : " + ritual.getName() + " and existing ritual " + existing.getName());
        }
        rituals.add(ritual);
    }

    public static void reload() {
        rituals.clear();
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "staff_crafting"), 2, 205.0, 86.0, 0.0).setResult(new ItemStack((ItemLike)RootsRegistry.CRYSTAL_STAFF.get(), 1)).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, -3).addIncense(new ItemStack((ItemLike)Blocks.f_50353_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.ACACIA_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50090_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42398_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42593_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "sylvan_hood_crafting"), 2, 62.0, 138.0, 62.0).setResult(new ItemStack((ItemLike)RootsRegistry.SYLVAN_HOOD.get(), 1)).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, -3).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 5, 1, 0).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), -5, 1, 0).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, 5).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, -5).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42436_, 1)).addIncense(new ItemStack((ItemLike)Blocks.f_50112_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42407_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50191_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "sylvan_chest_crafting"), 2, 62.0, 138.0, 62.0).setResult(new ItemStack((ItemLike)RootsRegistry.SYLVAN_ROBE.get(), 1)).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, -3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 0).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, 3).addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, -3).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 5, 1, 0).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), -5, 1, 0).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, 5).addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, -5).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42436_, 1)).addIncense(new ItemStack((ItemLike)Blocks.f_50112_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42408_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50191_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "sylvan_legs_crafting"), 2, 62.0, 138.0, 62.0).setResult(new ItemStack((ItemLike)RootsRegistry.SYLVAN_TUNIC.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42436_, 1)).addIncense(new ItemStack((ItemLike)Blocks.f_50112_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42462_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50191_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "sylvan_boots_crafting"), 2, 62.0, 138.0, 62.0).setResult(new ItemStack((ItemLike)RootsRegistry.SYLVAN_BOOTS.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42436_, 1)).addIncense(new ItemStack((ItemLike)Blocks.f_50112_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42463_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50191_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "wildwood_head_crafting"), 2, 145.0, 115.0, 65.0).setResult(new ItemStack((ItemLike)RootsRegistry.WILDWOOD_MASK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)Blocks.f_50746_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42468_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50705_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "wildwood_chest_crafting"), 2, 145.0, 115.0, 65.0).setResult(new ItemStack((ItemLike)RootsRegistry.WILDWOOD_PLATE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)Blocks.f_50746_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42469_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50705_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "wildwood_legs_crafting"), 2, 145.0, 115.0, 65.0).setResult(new ItemStack((ItemLike)RootsRegistry.WILDWOOD_LEGGINGS.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)Blocks.f_50746_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42470_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50705_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "wildwood_boots_crafting"), 2, 145.0, 115.0, 65.0).setResult(new ItemStack((ItemLike)RootsRegistry.WILDWOOD_BOOTS.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)Blocks.f_50746_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42471_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50705_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "accelerator_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((ItemLike)RootsRegistry.ACCELERATOR_STANDING_STONE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.JUNGLE_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42525_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50222_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "standing_stone"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((ItemLike)RootsRegistry.AESTHETIC_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42525_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50223_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "entangler_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((ItemLike)RootsRegistry.ENTANGLER_STANDING_STONE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42525_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50224_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "grower_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((ItemLike)RootsRegistry.GROWER_STANDING_STONE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42525_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50069_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "healer_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((ItemLike)RootsRegistry.HEALER_STANDING_STONE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42586_, 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get())).addIngredient(new ItemStack((ItemLike)Items.f_42451_)).addIngredient(new ItemStack((ItemLike)Blocks.f_50225_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "igniter_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((ItemLike)RootsRegistry.IGNITER_STANDING_STONE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.ACACIA_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42451_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50224_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "repulsor_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((ItemLike)RootsRegistry.REPULSOR_STANDING_STONE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.SPRUCE_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42525_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50225_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "vacuum_stone_crafting"), 2, 0.0, 105.0, 73.0).setResult(new ItemStack((ItemLike)RootsRegistry.VACUUM_STANDING_STONE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.DARK_OAK_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42525_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50197_)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "runic_focus_crafting"), 2, 109.0, 242.0, 109.0).setResult(new ItemStack((ItemLike)RootsRegistry.RUNIC_FOCUS.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.SPRUCE_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.ACACIA_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.JUNGLE_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42415_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50069_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "runic_focus_charging"), 2, 109.0, 242.0, 109.0).setResult(new ItemStack((ItemLike)RootsRegistry.CHARGED_RUNIC_FOCUS.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.RUNIC_FOCUS.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42451_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42525_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_pickaxe_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((ItemLike)RootsRegistry.LIVING_PICKAXE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42422_, 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42587_)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_axe_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((ItemLike)RootsRegistry.LIVING_AXE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42423_, 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42587_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_sword_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((ItemLike)RootsRegistry.LIVING_SWORD.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42420_, 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42587_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_hoe_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((ItemLike)RootsRegistry.LIVING_HOE.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42424_, 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42587_, 1)));
        RitualManager.addRitual(new RitualCrafting(new ResourceLocation("rootsclassic", "living_shovel_crafting"), 2, 146.0, 214.0, 43.0).setResult(new ItemStack((ItemLike)RootsRegistry.LIVING_SHOVEL.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OAK_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42421_, 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42587_, 1)));
        RitualManager.addRitual(new RitualCauseRain(new ResourceLocation("rootsclassic", "cause_rain"), 0, 23.0, 0.0, 138.0).addIncense(new ItemStack((ItemLike)Blocks.f_50191_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OLD_ROOT.get(), 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50196_, 1)));
        RitualManager.addRitual(new RitualBanishRain(new ResourceLocation("rootsclassic", "banish_rain"), 0, 204.0, 159.0, 35.0).addIncense(new ItemStack((ItemLike)Blocks.f_50191_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.OLD_ROOT.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42405_, 1)));
        RitualManager.addRitual(new RitualMassBreed(new ResourceLocation("rootsclassic", "mass_breeding"), 0, 148.0, 61.0, 81.0).addIncense(new ItemStack((ItemLike)Items.f_42619_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42404_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42526_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42525_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_)));
        RitualManager.addRitual(new RitualLifeDrain(new ResourceLocation("rootsclassic", "life_drain"), 2, 139.0, 22.0, 40.0).addIncense(new ItemStack((ItemLike)Items.f_42420_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42423_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.DARK_OAK_BARK.get(), 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.BIRCH_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42593_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualImbuer(new ResourceLocation("rootsclassic", "imbuer")).addIngredient(new ItemStack((ItemLike)RootsRegistry.CRYSTAL_STAFF.get(), 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "cow_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20557_).addIncense(new ItemStack((ItemLike)Items.f_42404_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42579_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42454_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "pig_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20510_).addIncense(new ItemStack((ItemLike)Items.f_42404_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42485_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42485_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "sheep_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20520_).addIncense(new ItemStack((ItemLike)Items.f_42404_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42658_, 1)).addIngredient(new ItemStack((ItemLike)Blocks.f_50041_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "chicken_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20555_).addIncense(new ItemStack((ItemLike)Items.f_42404_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42581_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42402_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "rabbit_summoning"), 1, 199.0, 105.0, 193.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20517_).addIncense(new ItemStack((ItemLike)Items.f_42404_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42697_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42649_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "zombie_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20501_).addIncense(new ItemStack((ItemLike)Items.f_42413_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42583_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42583_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "skeleton_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20524_).addIncense(new ItemStack((ItemLike)Items.f_42413_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42412_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "spider_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20479_).addIncense(new ItemStack((ItemLike)Items.f_42413_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42401_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42591_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "cave_spider_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20554_).addIncense(new ItemStack((ItemLike)Items.f_42413_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42401_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42592_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "slime_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20526_).addIncense(new ItemStack((ItemLike)Items.f_42413_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42518_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42518_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42518_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "creeper_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20558_).addIncense(new ItemStack((ItemLike)Items.f_42413_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42403_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42403_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSummoning(new ResourceLocation("rootsclassic", "enderman_summoning"), 2, 58.0, 2.0, 84.0).setEntityType((EntityType<? extends Mob>)EntityType.f_20566_).addIncense(new ItemStack((ItemLike)Items.f_42413_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42588_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42584_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42584_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualSacrifice(new ResourceLocation("rootsclassic", "sacrifice"), 2, 94.0, 9.0, 56.0).addIncense(new ItemStack((ItemLike)Items.f_42593_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.DARK_OAK_BARK.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42484_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42383_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42500_, 1)));
        RitualManager.addRitual(new RitualFlare(new ResourceLocation("rootsclassic", "flare"), 1, 255.0, 91.0, 25.0).addIncense(new ItemStack((ItemLike)Items.f_42403_, 1)).addIncense(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1)).addIngredient(new ItemStack((ItemLike)Items.f_42484_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42413_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42414_, 1)));
        RitualManager.addRitual(new RitualGrow(new ResourceLocation("rootsclassic", "grow"), 0, 82.0, 212.0, 47.0).addIncense(new ItemStack((ItemLike)Items.f_42405_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42732_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42620_, 1)).addIncense(new ItemStack((ItemLike)Items.f_42619_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42451_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42499_, 1)).addIngredient(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1)));
        RitualManager.addRitual(new RitualEngravedSword(new ResourceLocation("rootsclassic", "engraved_crafting"), 2, 104.0, 106.0, 107.0).setResult(new ItemStack((ItemLike)RootsRegistry.ENGRAVED_BLADE.get())).addIncense(new ItemStack((ItemLike)Items.f_42436_)).addIncense(new ItemStack((ItemLike)Items.f_42677_, 1)).addIngredient(new ItemStack((ItemLike)Items.f_42425_)).addIngredient(new ItemStack((ItemLike)RootsRegistry.RUNIC_FOCUS.get())).addIngredient(new ItemStack((ItemLike)Items.f_42525_)));
        RitualManager.addRitual(new RitualTimeShift(new ResourceLocation("rootsclassic", "time_shift"), 1, 240.0, 245.0, 88.0).addIngredient(new ItemStack((ItemLike)Items.f_42524_)).addIngredient(new ItemStack((ItemLike)Items.f_42416_)).addIncense(new ItemStack((ItemLike)Items.f_42524_)).setSecondaryColor(252.0, 162.0, 35.0));
    }

    public static RitualBase getRitualFromName(ResourceLocation name) {
        if (name != null) {
            for (RitualBase ritual : rituals) {
                if (!ritual.getName().equals((Object)name)) continue;
                return ritual;
            }
        }
        return null;
    }

    public static ArrayList<ItemStack> getIncenses(Level world, BlockPos pos) {
        ArrayList<ItemStack> test = new ArrayList<ItemStack>();
        for (int i = -4; i < 5; ++i) {
            for (int j = -4; j < 5; ++j) {
                BrazierBlockEntity brazierTile;
                if (world.m_8055_(pos.m_142082_(i, 0, j)).m_60734_() != RootsRegistry.BRAZIER.get() || world.m_7702_(pos.m_142082_(i, 0, j)) == null || !(brazierTile = (BrazierBlockEntity)world.m_7702_(pos.m_142082_(i, 0, j))).isBurning()) continue;
                test.add(brazierTile.getHeldItem());
            }
        }
        return test;
    }
}

