/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.entity.skeleton;

import elucent.rootsclassic.registry.RootsEntities;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.util.FakePlayer;

public class PhantomSkeletonEntity
extends Skeleton {
    public static boolean appliesSlowPotion = true;
    private static final Predicate<LivingEntity> SKELETON_SELECTOR = livingEntity -> !(livingEntity instanceof PhantomSkeletonEntity);

    public PhantomSkeletonEntity(EntityType<? extends PhantomSkeletonEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public PhantomSkeletonEntity(Level worldIn) {
        super((EntityType)RootsEntities.PHANTOM_SKELETON.get(), worldIn);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractSkeleton.m_32166_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderMan.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, 10, true, false, SKELETON_SELECTOR));
    }

    public boolean m_6040_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource s) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", this.f_19796_.nextGaussian() * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        float f = difficultyIn.m_19057_();
        this.m_21553_(this.f_19796_.nextFloat() < 0.55f * f);
        this.m_21553_(this.f_19796_.nextFloat() < 0.55f * f);
        return spawnDataIn;
    }

    public boolean m_7327_(Entity entityIn) {
        if (appliesSlowPotion && entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (!(entityIn instanceof FakePlayer) && !player.m_21023_(MobEffects.f_19597_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0));
            }
        }
        return super.m_7327_(entityIn);
    }
}

