/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import elucent.rootsclassic.item.SpellPowderItem;
import elucent.rootsclassic.registry.RootsRecipes;
import elucent.rootsclassic.registry.RootsRegistry;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ComponentRecipe
implements Recipe<Container> {
    private static final int MAX_INGREDIENTS = 4;
    private final ResourceLocation id;
    private final ResourceLocation effectResult;
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> materials;
    private final boolean needsMixin;

    public ComponentRecipe(ResourceLocation idIn, ResourceLocation effectResult, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, boolean needsMixin) {
        this.id = idIn;
        this.effectResult = effectResult;
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.materials = recipeItemsIn;
        this.needsMixin = needsMixin;
    }

    public ComponentRecipe(ResourceLocation idIn, ResourceLocation effectResult, String groupIn, NonNullList<Ingredient> recipeItemsIn, boolean needsMixin) {
        this(idIn, effectResult, groupIn, new ItemStack((ItemLike)RootsRegistry.SPELL_POWDER.get()), recipeItemsIn, needsMixin);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ResourceLocation getEffectResult() {
        return this.effectResult;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RootsRecipes.COMPONENT_SERIALIZER.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_5874_(Container inventory) {
        ItemStack outputStack = this.m_8043_();
        if (outputStack.m_41720_() instanceof SpellPowderItem) {
            SpellPowderItem.createData(outputStack, this.getEffectResult(), inventory);
        }
        return outputStack;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return this.recipeOutput.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.materials;
    }

    public RecipeType<?> m_6671_() {
        return RootsRecipes.COMPONENT_RECIPE_TYPE;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean needsMixin() {
        return this.needsMixin;
    }

    public TranslatableComponent getLocalizedName() {
        return new TranslatableComponent("rootsclassic.component." + this.m_6423_());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Ingredient mat : this.m_7527_()) {
            if (!mat.m_43947_()) {
                s.append(mat.m_43908_()[0].m_41786_().getString()).append(" ");
                continue;
            }
            s.append("One of the ingredients has no matching ItemStack's");
        }
        return s.toString();
    }

    public boolean m_5818_(Container inventory, Level worldIn) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack stack = inventory.m_8020_(j);
            if (stack.m_41619_() || this.isSupplementItem(stack)) continue;
            ++i;
            inputs.add(stack);
        }
        return i == this.materials.size() && RecipeMatcher.findMatches(inputs, this.materials) != null;
    }

    private boolean isSupplementItem(ItemStack stack) {
        if (this.m_8043_().m_41720_() instanceof SpellPowderItem) {
            return stack.m_41720_() == RootsRegistry.OLD_ROOT.get() || stack.m_41720_() == RootsRegistry.VERDANT_SPRIG.get() || stack.m_41720_() == RootsRegistry.INFERNAL_BULB.get() || stack.m_41720_() == RootsRegistry.DRAGONS_EYE.get() || stack.m_41720_() == Items.f_42525_ || stack.m_41720_() == Items.f_42451_ || stack.m_41720_() == Items.f_42403_;
        }
        return false;
    }

    public static int getModifierCapacity(Container inventory) {
        int maxCapacity = -1;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41720_() == RootsRegistry.OLD_ROOT.get() && maxCapacity < 0) {
                maxCapacity = 0;
            }
            if (stack.m_41720_() == RootsRegistry.VERDANT_SPRIG.get() && maxCapacity < 1) {
                maxCapacity = 1;
            }
            if (stack.m_41720_() == RootsRegistry.INFERNAL_BULB.get() && maxCapacity < 2) {
                maxCapacity = 2;
            }
            if (stack.m_41720_() != RootsRegistry.DRAGONS_EYE.get() || maxCapacity >= 3) continue;
            maxCapacity = 3;
        }
        return maxCapacity;
    }

    public static int getModifierCount(Container inventory) {
        int count = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41720_() == Items.f_42525_) {
                ++count;
                continue;
            }
            if (stack.m_41720_() == Items.f_42451_) {
                ++count;
                continue;
            }
            if (stack.m_41720_() != Items.f_42403_) continue;
            ++count;
        }
        return count;
    }

    public static class SerializeComponentRecipe
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ComponentRecipe> {
        public ComponentRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = SerializeComponentRecipe.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for component recipe");
            }
            if (nonnulllist.size() > 4) {
                throw new JsonParseException("Too many ingredients for component recipe the max is 4");
            }
            boolean needsMixin = GsonHelper.m_13855_((JsonObject)json, (String)"needs_mixin", (boolean)true);
            String effect = GsonHelper.m_13906_((JsonObject)json, (String)"effect");
            ResourceLocation effectResult = ResourceLocation.m_135820_((String)effect);
            if (GsonHelper.m_13900_((JsonObject)json, (String)"result")) {
                ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
                return new ComponentRecipe(recipeId, effectResult, s, itemstack, nonnulllist, needsMixin);
            }
            return new ComponentRecipe(recipeId, effectResult, s, nonnulllist, needsMixin);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public ComponentRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            int i = buffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            boolean needsMixin = buffer.readBoolean();
            ResourceLocation effectResult = buffer.m_130281_();
            ItemStack itemstack = buffer.m_130267_();
            return new ComponentRecipe(recipeId, effectResult, s, itemstack, (NonNullList<Ingredient>)nonnulllist, needsMixin);
        }

        public void toNetwork(FriendlyByteBuf buffer, ComponentRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.materials.size());
            for (Ingredient ingredient : recipe.materials) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeBoolean(recipe.needsMixin);
            buffer.m_130085_(recipe.effectResult);
            buffer.m_130055_(recipe.recipeOutput);
        }
    }
}

