/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.RitualBaseRegistry;
import elucent.rootsclassic.ritual.rituals.RitualCrafting;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.rootsclassic.Ritual")
public class RitualZen {
    @ZenCodeType.Method
    public static void addCraftingRitual(String uniqueName, IItemStack output, int level, double r, double g, double b, IItemStack[] incenses, IItemStack[] ingredients) {
        RitualCrafting newCraft = new RitualCrafting(level, r, g, b);
        newCraft.setRegistryName(new ResourceLocation("crafttweaker", uniqueName));
        newCraft.setResult(output.getInternal());
        newCraft.setIncenses(List.of(RitualZen.convertToStacks(incenses)));
        newCraft.setIngredients(List.of(RitualZen.convertToStacks(ingredients)));
        ((ForgeRegistry)RitualBaseRegistry.RITUALS.get()).unfreeze();
        RitualBaseRegistry.RITUALS.get().register((IForgeRegistryEntry)newCraft);
        ((ForgeRegistry)RitualBaseRegistry.RITUALS.get()).freeze();
    }

    @ZenCodeType.Method
    public static void setPrimaryColor(ResourceLocation name, double r, double g, double b) {
        RitualBase found = RitualZen.findRitualByName(name);
        found.setPrimaryColor(r, g, b);
    }

    @ZenCodeType.Method
    public static void setSecondaryColor(ResourceLocation name, double r, double g, double b) {
        RitualBase found = RitualZen.findRitualByName(name);
        found.setSecondaryColor(r, g, b);
    }

    @ZenCodeType.Method
    public static void setLevel(ResourceLocation name, int level) {
        RitualBase found = RitualZen.findRitualByName(name);
        found.setLevel(level);
    }

    @ZenCodeType.Method
    public static void setRitualIngredients(ResourceLocation name, IItemStack[] items) {
        RitualBase found = RitualZen.findRitualByName(name);
        CraftTweakerAPI.LOGGER.info("Changing Ritual ingredients " + found.getRegistryName());
        found.setIngredients(Arrays.asList(RitualZen.convertToStacks(items)));
    }

    @ZenCodeType.Method
    public static void setRitualIncense(ResourceLocation name, IItemStack[] items) {
        RitualBase found = RitualZen.findRitualByName(name);
        CraftTweakerAPI.LOGGER.info("Changing Ritual incense " + found.getRegistryName());
        found.setIncenses(Arrays.asList(RitualZen.convertToStacks(items)));
    }

    private static RitualBase findRitualByName(ResourceLocation name) {
        RitualBase found = (RitualBase)RitualBaseRegistry.RITUALS.get().getValue(name);
        if (found == null) {
            StringBuilder names = new StringBuilder();
            for (RitualBase c : RitualBaseRegistry.RITUALS.get().getValues()) {
                names.append(c.getRegistryName()).append(",");
            }
            CraftTweakerAPI.LOGGER.info(names.toString());
            throw new IllegalArgumentException("Invalid ritual[" + name + "], names must be one of: " + names);
        }
        return found;
    }

    private static ItemStack[] convertToStacks(IItemStack[] stacks) {
        if (stacks == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            output[i] = stacks[i].getInternal();
        }
        return output;
    }
}

