/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import elucent.rootsclassic.block.AttunedStandingStoneBlock;
import elucent.rootsclassic.lootmodifiers.DropModifier;
import elucent.rootsclassic.registry.RootsEntities;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.registry.RootsTags;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RootsDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new Loots(generator));
            generator.m_123914_((DataProvider)new Recipes(generator));
            generator.m_123914_((DataProvider)new GLMProvider(generator));
            RootsBlockTags provider = new RootsBlockTags(generator, helper);
            generator.m_123914_((DataProvider)provider);
            generator.m_123914_((DataProvider)new RootsItemTags(generator, provider, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(RootsBlockLoot::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(RootsEntityLoot::new, (Object)LootContextParamSets.f_81415_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private static class RootsEntityLoot
        extends EntityLoot {
            private RootsEntityLoot() {
            }

            protected void addTables() {
                this.m_124371_((EntityType)RootsEntities.PHANTOM_SKELETON.get(), LootTable.m_79147_());
            }

            protected boolean isNonLiving(EntityType<?> entityType) {
                return entityType.m_20674_() == MobCategory.MISC;
            }

            protected Iterable<EntityType<?>> getKnownEntities() {
                Stream<EntityType> entities = RootsEntities.ENTITIES.getEntries().stream().map(RegistryObject::get);
                return entities::iterator;
            }
        }

        private static class RootsBlockLoot
        extends BlockLoot {
            private RootsBlockLoot() {
            }

            protected void addTables() {
                this.m_124288_((Block)RootsRegistry.MORTAR.get());
                this.m_124288_((Block)RootsRegistry.ALTAR.get());
                this.m_124288_((Block)RootsRegistry.BRAZIER.get());
                this.m_124288_((Block)RootsRegistry.IMBUER.get());
                this.m_124288_((Block)RootsRegistry.MUNDANE_STANDING_STONE.get());
                this.m_124288_((Block)RootsRegistry.MIDNIGHT_BLOOM.get());
                this.m_124288_((Block)RootsRegistry.FLARE_ORCHID.get());
                this.m_124288_((Block)RootsRegistry.RADIANT_DAISY.get());
                this.m_124175_((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), this::registerStandingStone);
                this.m_124175_((Block)RootsRegistry.VACUUM_STANDING_STONE.get(), this::registerStandingStone);
                this.m_124175_((Block)RootsRegistry.REPULSOR_STANDING_STONE.get(), this::registerStandingStone);
                this.m_124175_((Block)RootsRegistry.ACCELERATOR_STANDING_STONE.get(), this::registerStandingStone);
                this.m_124175_((Block)RootsRegistry.AESTHETIC_STANDING_STONE.get(), this::registerStandingStone);
                this.m_124175_((Block)RootsRegistry.ENTANGLER_STANDING_STONE.get(), this::registerStandingStone);
                this.m_124175_((Block)RootsRegistry.IGNITER_STANDING_STONE.get(), this::registerStandingStone);
                this.m_124175_((Block)RootsRegistry.GROWER_STANDING_STONE.get(), this::registerStandingStone);
                this.m_124175_((Block)RootsRegistry.HEALER_STANDING_STONE.get(), this::registerStandingStone);
            }

            public LootTable.Builder registerStandingStone(Block standingStone) {
                return RootsBlockLoot.m_124161_((Block)standingStone, AttunedStandingStoneBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
            }

            protected Iterable<Block> getKnownBlocks() {
                return RootsRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.PESTLE.get())).m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50228_).m_142409_("pestle").m_126130_("X  ").m_126130_(" XX").m_126130_(" XX").m_142284_("has_diorite", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Blocks.f_50228_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.PESTLE.get())).m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50228_).m_142409_("pestle").m_126130_("  X").m_126130_("XX ").m_126130_("XX ").m_142284_("has_diorite", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Blocks.f_50228_)).m_176500_(consumer, Registry.f_122827_.m_7981_((Object)((Item)RootsRegistry.PESTLE.get())) + "2");
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.MORTAR.get())).m_206416_(Character.valueOf('X'), Tags.Items.STONE).m_126130_("X X").m_126130_("X X").m_126130_(" X ").m_142284_("has_stone", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.STONE)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.IMBUER.get())).m_206416_(Character.valueOf('X'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('L'), ItemTags.f_13182_).m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50225_).m_126130_("X X").m_126130_("LSL").m_142284_("has_chiseled_stone_bricks", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Blocks.f_50225_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.MUNDANE_STANDING_STONE.get())).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('B'), (ItemLike)Blocks.f_50222_).m_206416_(Character.valueOf('L'), Tags.Items.STORAGE_BLOCKS_LAPIS).m_126130_("SBS").m_126130_("BLB").m_126130_("SBS").m_142284_("has_lapis_block", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.STORAGE_BLOCKS_LAPIS)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get())).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_206416_(Character.valueOf('N'), Tags.Items.INGOTS_NETHER_BRICK).m_206416_(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).m_126130_("SNS").m_126130_("NDN").m_126130_("SNS").m_142284_("has_diamond", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.BRAZIER.get())).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42544_).m_206416_(Character.valueOf('X'), Tags.Items.RODS_WOODEN).m_126130_("ISI").m_126130_("ICI").m_126130_("IXI").m_142284_("has_cauldron", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42544_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.ALTAR.get())).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_41940_).m_126127_(Character.valueOf('B'), (ItemLike)RootsRegistry.VERDANT_SPRIG.get()).m_206416_(Character.valueOf('G'), Tags.Items.STORAGE_BLOCKS_GOLD).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50225_).m_126130_("BFB").m_126130_("SGS").m_126130_(" C ").m_142284_("has_gold_block", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.BARK_KNIFE.get())).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('V'), ItemTags.f_13180_).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126130_(" VV").m_126130_("VPV").m_126130_("SV ").m_142284_("has_sapling", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13180_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)RootsRegistry.RUNIC_TABLET.get())).m_206416_(Character.valueOf('S'), Tags.Items.SEEDS_WHEAT).m_206416_(Character.valueOf('B'), Tags.Items.STONE).m_126127_(Character.valueOf('R'), (ItemLike)RootsRegistry.OLD_ROOT.get()).m_126130_(" R ").m_126130_("SBS").m_126130_(" S ").m_142284_("has_old_root", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.OLD_ROOT.get()))).m_176498_(consumer);
            ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)RootsRegistry.GROWTH_POWDER.get()), (int)4).m_206419_(Tags.Items.SEEDS_WHEAT).m_126209_((ItemLike)Items.f_41864_).m_206419_(Tags.Items.DUSTS_REDSTONE).m_126209_((ItemLike)RootsRegistry.PESTLE.get()).m_142284_("has_pestle", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.PESTLE.get()))).m_176498_(consumer);
            ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)RootsRegistry.MUTATING_POWDER.get())).m_126209_((ItemLike)RootsRegistry.GROWTH_POWDER.get()).m_126209_((ItemLike)RootsRegistry.GROWTH_POWDER.get()).m_126209_((ItemLike)RootsRegistry.GROWTH_POWDER.get()).m_126209_((ItemLike)RootsRegistry.GROWTH_POWDER.get()).m_206419_(Tags.Items.NETHER_STARS).m_206419_(Tags.Items.CROPS_NETHER_WART).m_126209_((ItemLike)RootsRegistry.PESTLE.get()).m_142284_("has_pestle", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.PESTLE.get()))).m_176498_(consumer);
            ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)RootsRegistry.ROOTY_STEW.get())).m_206419_(Tags.Items.CROPS_WHEAT).m_126209_((ItemLike)Items.f_42399_).m_126209_((ItemLike)RootsRegistry.OLD_ROOT.get()).m_142284_("has_bowl", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42399_)).m_176498_(consumer);
            ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)RootsRegistry.FRUIT_SALAD.get())).m_126209_((ItemLike)Items.f_42028_).m_126209_((ItemLike)Items.f_42028_).m_126209_((ItemLike)Items.f_42028_).m_126209_((ItemLike)Items.f_42410_).m_126209_((ItemLike)Items.f_42399_).m_126209_((ItemLike)RootsRegistry.ELDERBERRY.get()).m_126209_((ItemLike)RootsRegistry.WHITECURRANT.get()).m_126209_((ItemLike)RootsRegistry.BLACKCURRANT.get()).m_126209_((ItemLike)RootsRegistry.REDCURRANT.get()).m_142284_("has_bowl", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42399_)).m_176498_(consumer);
            ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)RootsRegistry.HEALING_POULTICE.get()), (int)2).m_126209_((ItemLike)RootsRegistry.REDCURRANT.get()).m_126209_((ItemLike)Items.f_42516_).m_126209_((ItemLike)RootsRegistry.PESTLE.get()).m_126209_((ItemLike)RootsRegistry.VERDANT_SPRIG.get()).m_142284_("has_pestle", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.PESTLE.get()))).m_176498_(consumer);
            SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RootsRegistry.DRAGONS_EYE.get()}), (ItemLike)Items.f_42584_, (float)1.0f, (int)200).m_142284_("has_dragons_eye", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.DRAGONS_EYE.get()))).m_176500_(consumer, "rootsclassic:ender_pearl");
        }
    }

    private static class GLMProvider
    extends GlobalLootModifierProvider {
        public GLMProvider(DataGenerator gen) {
            super(gen, "rootsclassic");
        }

        protected void start() {
            this.add("rootsclassic_drops", (GlobalLootModifierSerializer)DropModifier.ROOTSCLASSIC_DROPS.get(), (IGlobalLootModifier)new DropModifier.BlockDropModifier(new LootItemCondition[]{InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS))).m_6409_()}));
        }
    }

    public static class RootsBlockTags
    extends BlockTagsProvider {
        public RootsBlockTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "rootsclassic", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(RootsTags.NEEDS_LIVING_TOOL);
            this.m_206424_(RootsTags.NEEDS_ENGRAVED_TOOL);
        }
    }

    public static class RootsItemTags
    extends ItemTagsProvider {
        public RootsItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagsProvider, "rootsclassic", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(RootsTags.BERRIES).m_126584_((Object[])new Item[]{(Item)RootsRegistry.NIGHTSHADE.get(), (Item)RootsRegistry.BLACKCURRANT.get(), (Item)RootsRegistry.REDCURRANT.get(), (Item)RootsRegistry.WHITECURRANT.get(), (Item)RootsRegistry.ELDERBERRY.get()});
            this.addBark((Item)RootsRegistry.ACACIA_BARK.get(), "acacia");
            this.addBark((Item)RootsRegistry.BIRCH_BARK.get(), "birch");
            this.addBark((Item)RootsRegistry.DARK_OAK_BARK.get(), "dark_oak");
            this.addBark((Item)RootsRegistry.JUNGLE_BARK.get(), "jungle");
            this.addBark((Item)RootsRegistry.OAK_BARK.get(), "oak");
            this.addBark((Item)RootsRegistry.SPRUCE_BARK.get(), "spruce");
        }

        private void addBark(Item item, String treeType) {
            TagKey barkTypeTag = ItemTags.create((ResourceLocation)new ResourceLocation("rootsclassic", "barks/" + treeType));
            this.m_206424_(RootsTags.BARKS).m_206428_(barkTypeTag);
            this.m_206424_(barkTypeTag).m_126582_((Object)item);
        }
    }
}

