/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.lootmodifiers;

import com.google.gson.JsonObject;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.registry.RootsTags;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DropModifier {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"rootsclassic");
    public static final RegistryObject<BlockDropModifier.Serializer> ROOTSCLASSIC_DROPS = GLM.register("rootsclassic_drops", BlockDropModifier.Serializer::new);

    public static class BlockDropModifier
    extends LootModifier {
        public BlockDropModifier(LootItemCondition[] lootConditions) {
            super(lootConditions);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (context.m_78936_(LootContextParams.f_81461_)) {
                BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
                Block block = state.m_60734_();
                Random rand = context.m_78933_();
                if (block instanceof TallGrassBlock && (Integer)RootsConfig.COMMON.oldRootDropChance.get() > 0 && rand.nextInt((Integer)RootsConfig.COMMON.oldRootDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((ItemLike)RootsRegistry.OLD_ROOT.get(), 1));
                }
                if ((block == Blocks.f_50092_ || block == Blocks.f_50249_ || block == Blocks.f_50250_ || block == Blocks.f_50444_) && ((CropBlock)block).m_52307_(state) && (Integer)RootsConfig.COMMON.verdantSprigDropChance.get() > 0 && rand.nextInt((Integer)RootsConfig.COMMON.verdantSprigDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((ItemLike)RootsRegistry.VERDANT_SPRIG.get(), 1));
                }
                if (block == Blocks.f_50200_ && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) == 3 && (Integer)RootsConfig.COMMON.infernalStemDropChance.get() > 0 && rand.nextInt((Integer)RootsConfig.COMMON.infernalStemDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((ItemLike)RootsRegistry.INFERNAL_BULB.get(), 1));
                }
                if (block == Blocks.f_50491_ && (Integer)RootsConfig.COMMON.dragonsEyeDropChance.get() > 0 && rand.nextInt((Integer)RootsConfig.COMMON.dragonsEyeDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((ItemLike)RootsRegistry.DRAGONS_EYE.get(), 1));
                }
                if (block instanceof LeavesBlock && !generatedLoot.stream().anyMatch(stack -> stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() == block) && (Integer)RootsConfig.COMMON.berriesDropChance.get() > 0 && rand.nextInt((Integer)RootsConfig.COMMON.berriesDropChance.get()) == 0) {
                    Item berry = (Item)RootsRegistry.ELDERBERRY.get();
                    berry = ForgeRegistries.ITEMS.tags().getTag(RootsTags.BERRIES).getRandomElement(rand).orElse(berry);
                    generatedLoot.add(new ItemStack((ItemLike)berry));
                }
            }
            return generatedLoot;
        }

        protected static class Serializer
        extends GlobalLootModifierSerializer<BlockDropModifier> {
            protected Serializer() {
            }

            public BlockDropModifier read(ResourceLocation location, JsonObject jsonObject, LootItemCondition[] lootConditions) {
                return new BlockDropModifier(lootConditions);
            }

            public JsonObject write(BlockDropModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }
}

