/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ModelArmorBase
extends HumanoidModel<LivingEntity> {
    public final EquipmentSlot slot;
    public float armorScale = 1.05f;
    public final ModelPart rightFoot;
    public final ModelPart leftFoot;

    public ModelArmorBase(ModelPart root, EquipmentSlot slot) {
        super(root);
        this.rightFoot = root.m_171324_("right_foot");
        this.leftFoot = root.m_171324_("left_foot");
        this.slot = slot;
        this.f_102610_ = false;
    }

    public static MeshDefinition createArmorMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("right_foot", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partdefinition.m_171599_("left_foot", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return meshdefinition;
    }

    public void m_6973_(LivingEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entityIn instanceof ArmorStand)) {
            super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        if (entityIn instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entityIn;
            this.f_102808_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123156_();
            this.f_102808_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123157_();
            this.f_102808_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123158_();
            this.f_102808_.m_104227_(0.0f, 1.0f, 0.0f);
            this.f_102810_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123156_();
            this.f_102810_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123157_();
            this.f_102810_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123158_();
            this.f_102812_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123156_();
            this.f_102812_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123157_();
            this.f_102812_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123158_();
            this.f_102811_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123156_();
            this.f_102811_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123157_();
            this.f_102811_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123158_();
            this.f_102814_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123156_();
            this.f_102814_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123157_();
            this.f_102814_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123158_();
            this.f_102814_.m_104227_(1.9f, 11.0f, 0.0f);
            this.f_102813_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123156_();
            this.f_102813_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123157_();
            this.f_102813_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123158_();
            this.f_102813_.m_104227_(-1.9f, 11.0f, 0.0f);
            this.f_102809_.m_104315_(this.f_102808_);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_85841_(this.armorScale, this.armorScale, this.armorScale);
        this.setHeadRotation();
        this.setChestRotation();
        this.setLegsRotation();
        this.setBootRotation();
        this.f_102808_.f_104207_ = this.slot == EquipmentSlot.HEAD;
        this.f_102810_.f_104207_ = this.slot == EquipmentSlot.CHEST;
        this.f_102811_.f_104207_ = this.slot == EquipmentSlot.CHEST;
        this.f_102812_.f_104207_ = this.slot == EquipmentSlot.CHEST;
        this.f_102813_.f_104207_ = this.slot == EquipmentSlot.LEGS;
        this.f_102814_.f_104207_ = this.slot == EquipmentSlot.LEGS;
        this.rightFoot.f_104207_ = this.slot == EquipmentSlot.FEET;
        boolean bl = this.leftFoot.f_104207_ = this.slot == EquipmentSlot.FEET;
        if (this.f_102610_) {
            float f = 2.0f;
            poseStack.m_85836_();
            poseStack.m_85841_(1.5f / f, 1.5f / f, 1.5f / f);
            poseStack.m_85837_(0.0, 16.0, 0.0);
            this.f_102808_.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f / f, 1.0f / f, 1.0f / f);
            poseStack.m_85837_(0.0, 24.0, 0.0);
            this.f_102810_.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            poseStack.m_85849_();
        } else {
            this.f_102808_.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            if (this.f_102817_) {
                poseStack.m_85837_(0.0, (double)0.2f, 0.0);
            }
            this.f_102810_.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            poseStack.m_85836_();
            if (this.f_102817_) {
                poseStack.m_85837_(0.0, (double)-0.15f, 0.0);
            }
            this.f_102811_.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.f_102812_.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            poseStack.m_85849_();
        }
        poseStack.m_85837_(0.0, 1.25, 0.0);
        if (this.f_102817_) {
            poseStack.m_85837_(0.0, (double)-0.15f, (double)0.05f);
        }
        this.f_102813_.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.f_102814_.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.rightFoot.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.leftFoot.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public void setHeadRotation() {
        ModelArmorBase.setRotation(this.f_102808_, this.f_102808_.f_104203_, this.f_102808_.f_104204_, this.f_102808_.f_104205_);
    }

    public void setChestRotation() {
        this.f_102810_.f_104201_ -= 1.0f;
        this.f_102811_.f_104200_ += 5.0f;
        this.f_102811_.f_104201_ -= 1.0f;
        this.f_102811_.f_104202_ = this.f_102811_.f_104202_;
        this.f_102812_.f_104200_ -= 5.0f;
        this.f_102812_.f_104201_ -= 1.0f;
        this.f_102812_.f_104202_ = this.f_102812_.f_104202_;
        ModelArmorBase.setRotation(this.f_102810_, this.f_102810_.f_104203_, this.f_102810_.f_104204_, this.f_102810_.f_104205_);
        ModelArmorBase.setRotation(this.f_102811_, this.f_102811_.f_104203_, this.f_102811_.f_104204_, this.f_102811_.f_104205_);
        ModelArmorBase.setRotation(this.f_102812_, this.f_102812_.f_104203_, this.f_102812_.f_104204_, this.f_102812_.f_104205_);
    }

    public void setLegsRotation() {
        this.f_102813_.f_104200_ += 2.0f;
        this.f_102813_.f_104201_ -= 22.0f;
        this.f_102814_.f_104200_ -= 2.0f;
        this.f_102814_.f_104201_ -= 22.0f;
        ModelArmorBase.setRotation(this.f_102813_, this.f_102813_.f_104203_, this.f_102813_.f_104204_, this.f_102813_.f_104205_);
        ModelArmorBase.setRotation(this.f_102814_, this.f_102814_.f_104203_, this.f_102814_.f_104204_, this.f_102814_.f_104205_);
    }

    public void setBootRotation() {
        this.rightFoot.f_104201_ = this.f_102813_.f_104201_ - 0.0f;
        this.rightFoot.f_104202_ = this.f_102813_.f_104202_;
        this.leftFoot.f_104201_ = this.f_102814_.f_104201_ - 0.0f;
        this.leftFoot.f_104202_ = this.f_102814_.f_104202_;
        ModelArmorBase.setRotation(this.rightFoot, this.f_102813_.f_104203_, this.f_102813_.f_104204_, this.f_102813_.f_104205_);
        ModelArmorBase.setRotation(this.leftFoot, this.f_102814_.f_104203_, this.f_102814_.f_104204_, this.f_102814_.f_104205_);
    }

    public static void setRotation(ModelPart model, float x, float y, float z) {
        model.f_104203_ = x;
        model.f_104204_ = y;
        model.f_104205_ = z;
    }
}

