/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import elucent.rootsclassic.Const;
import elucent.rootsclassic.client.ClientInfo;
import elucent.rootsclassic.client.screen.ScreenSlotInstance;
import elucent.rootsclassic.client.screen.ScreenTextInstance;
import elucent.rootsclassic.client.screen.TabletScreen;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.research.EnumPageType;
import elucent.rootsclassic.research.ResearchBase;
import elucent.rootsclassic.research.ResearchGroup;
import elucent.rootsclassic.research.ResearchPage;
import elucent.rootsclassic.util.RootsUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class TabletPageScreen
extends Screen {
    private int currentPage = 0;
    private ResearchBase research = null;
    private ResearchGroup group = null;
    private boolean showRightArrow = false;
    private boolean showLeftArrow = true;
    private final Player player;
    private int matchingStacksCurrent = 0;
    private int matchingStacksMax = 0;
    private int matchingStacks2Current = 0;
    private int matchingStacks2Max = 0;

    public TabletPageScreen(ResearchGroup g, ResearchBase r, Player player) {
        super((Component)Component.m_237119_());
        this.player = player;
        this.group = g;
        this.research = r;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.f_96541_.m_91152_((Screen)new TabletScreen(this.player));
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237119_(), button -> {}).m_252987_(20, 20, 20, 60).m_253136_());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        float basePosX = (float)this.f_96543_ / 2.0f - 96.0f;
        float basePosY = (float)this.f_96544_ / 2.0f - 128.0f;
        if (this.showLeftArrow && mouseX >= (double)(basePosX + 16.0f) && mouseX < (double)(basePosX + 48.0f) && mouseY >= (double)(basePosY + 224.0f) && mouseY < (double)(basePosY + 240.0f)) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            --this.currentPage;
        }
        if (this.showRightArrow && mouseX >= (double)(basePosX + 144.0f) && mouseX < (double)(basePosX + 176.0f) && mouseY >= (double)(basePosY + 224.0f) && mouseY < (double)(basePosY + 240.0f)) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            ++this.currentPage;
        }
        List<ResearchPage> researchInfo = this.research.getInfo();
        if (this.player.f_19853_.f_46443_ && mouseX >= (double)((float)this.f_96543_ / 2.0f - 110.0f) && mouseX < (double)((float)this.f_96543_ / 2.0f + 40.0f) && mouseY >= (double)((float)this.f_96544_ / 2.0f - 138.0f) && mouseY < (double)((float)this.f_96544_ / 2.0f - 40.0f)) {
            if (researchInfo.get((int)this.currentPage).recipe == EnumPageType.TYPE_MORTAR) {
                this.player.m_213846_((Component)Component.m_237115_((String)researchInfo.get((int)this.currentPage).mortarRecipe.toString()));
            } else if (researchInfo.get((int)this.currentPage).recipe == EnumPageType.TYPE_ALTAR) {
                this.player.m_213846_((Component)Component.m_237115_((String)researchInfo.get((int)this.currentPage).altarRecipe.toString()));
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private String makeTitle() {
        return I18n.m_118938_((String)("rootsclassic.research." + this.group.getName() + "." + this.research.getName() + ".page" + (this.currentPage + 1) + "title"), (Object[])new Object[0]);
    }

    private String makeInfo() {
        return I18n.m_118938_((String)("rootsclassic.research." + this.group.getName() + "." + this.research.getName() + ".page" + (this.currentPage + 1) + "info"), (Object[])new Object[0]);
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        List<ResearchPage> researchInfo = this.research.getInfo();
        this.showLeftArrow = this.currentPage != 0;
        this.showRightArrow = this.currentPage != researchInfo.size() - 1;
        int basePosX = (int)((float)this.f_96543_ / 2.0f - 96.0f);
        int basePosY = (int)((float)this.f_96544_ / 2.0f - 128.0f);
        if (this.research == null || researchInfo == null || researchInfo.size() <= this.currentPage) {
            return;
        }
        ArrayList<ScreenSlotInstance> slots = new ArrayList<ScreenSlotInstance>();
        ArrayList<ScreenTextInstance> textLines = new ArrayList<ScreenTextInstance>();
        ResearchPage page = researchInfo.get(this.currentPage);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (page.recipe) {
            case TYPE_NULL: {
                int i;
                RenderSystem.m_157456_((int)0, (ResourceLocation)Const.tabletGui);
                this.m_93228_(poseStack, basePosX, basePosY, 64, 0, 192, 256);
                List<String> info = page.makeLines(this.makeInfo());
                for (i = 0; i < info.size(); ++i) {
                    textLines.add(new ScreenTextInstance(info.get(i), basePosX + 16, basePosY + 32 + i * 11));
                }
                Object title = this.makeTitle();
                textLines.add(new ScreenTextInstance((String)title, (float)(basePosX + 96) - (float)this.f_96547_.m_92895_((String)title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
                break;
            }
            case TYPE_SMELTING: {
                int i;
                RenderSystem.m_157456_((int)0, (ResourceLocation)Const.tabletSmelting);
                this.m_93228_(poseStack, basePosX, basePosY, 0, 0, 192, 256);
                slots.add(new ScreenSlotInstance(page.smeltingRecipe.get(0), basePosX + 56, basePosY + 40));
                slots.add(new ScreenSlotInstance(page.smeltingRecipe.get(1), basePosX + 144, basePosY + 56));
                List<String> info = page.makeLines(this.makeInfo());
                for (i = 0; i < info.size(); ++i) {
                    textLines.add(new ScreenTextInstance(info.get(i), basePosX + 16, basePosY + 104 + i * 11, RootsUtil.intColor(255, 255, 255)));
                }
                Object title = this.makeTitle();
                textLines.add(new ScreenTextInstance((String)title, (float)(basePosX + 96) - (float)this.f_96547_.m_92895_((String)title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
                break;
            }
            case TYPE_DISPLAY: {
                int i;
                RenderSystem.m_157456_((int)0, (ResourceLocation)Const.tabletDisplay);
                this.m_93228_(poseStack, basePosX, basePosY, 0, 0, 192, 256);
                slots.add(new ScreenSlotInstance(page.displayItem, basePosX + 88, basePosY + 48));
                List<String> info = page.makeLines(this.makeInfo());
                for (i = 0; i < info.size(); ++i) {
                    textLines.add(new ScreenTextInstance(info.get(i), basePosX + 16, basePosY + 80 + i * 11, RootsUtil.intColor(255, 255, 255)));
                }
                Object title = this.makeTitle();
                textLines.add(new ScreenTextInstance((String)title, (float)(basePosX + 96) - (float)this.f_96547_.m_92895_((String)title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
                break;
            }
            case TYPE_ALTAR: {
                int i;
                RenderSystem.m_157456_((int)0, (ResourceLocation)Const.tabletAltar);
                this.m_93228_(poseStack, basePosX, basePosY, 0, 0, 192, 256);
                for (i = 0; i < page.altarRecipe.getBlocks().size(); ++i) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)Const.tabletAltar);
                    int u = 192;
                    int v = 240;
                    int xShift = 0;
                    int yShift = 0;
                    this.m_93228_(poseStack, basePosX + 93, basePosY + 153, 192, 32, 16, 16);
                    if (page.altarRecipe.getBlocks().get(i).equals(RootsRegistry.MUNDANE_STANDING_STONE.get())) {
                        v = 48;
                        xShift = 8 * page.altarRecipe.getPositionsRelative().get(i).m_123341_();
                        yShift = 8 * page.altarRecipe.getPositionsRelative().get(i).m_123343_();
                    }
                    if (page.altarRecipe.getBlocks().get(i).equals(RootsRegistry.ATTUNED_STANDING_STONE.get())) {
                        v = 64;
                        xShift = 8 * page.altarRecipe.getPositionsRelative().get(i).m_123341_();
                        yShift = 8 * page.altarRecipe.getPositionsRelative().get(i).m_123343_();
                    }
                    this.m_93228_(poseStack, basePosX + 93 + xShift, basePosY + 153 + yShift, u, v, 16, 16);
                }
                for (i = 0; i < page.altarRecipe.getIngredients().size(); ++i) {
                    slots.add(new ScreenSlotInstance(page.altarRecipe.getIngredients().get(i), basePosX + 64 + 24 * i, basePosY + 56));
                }
                for (i = 0; i < page.altarRecipe.getIncenses().size(); ++i) {
                    slots.add(new ScreenSlotInstance(page.altarRecipe.getIncenses().get(i), basePosX + 76 + 16 * i, basePosY + 88));
                }
                Object title = this.makeTitle();
                textLines.add(new ScreenTextInstance((String)title, (float)(basePosX + 96) - (float)this.f_96547_.m_92895_((String)title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
                break;
            }
            case TYPE_MORTAR: {
                int i;
                List<String> info;
                RenderSystem.m_157456_((int)0, (ResourceLocation)Const.tabletMortar);
                this.m_93228_(poseStack, basePosX, basePosY, 0, 0, 192, 256);
                Object title = this.makeTitle();
                if (page.mortarRecipe != null) {
                    for (i = 0; i < page.mortarRecipe.m_7527_().size(); ++i) {
                        Ingredient ingredient = (Ingredient)page.mortarRecipe.m_7527_().get(i);
                        if (ingredient.m_43947_()) {
                            slots.add(new ScreenSlotInstance(new ItemStack((ItemLike)Items.f_42127_), basePosX + 24 + i * 16, basePosY + 56));
                            continue;
                        }
                        slots.add(new ScreenSlotInstance(this.getStackFromIngredient(ingredient), basePosX + 24 + i * 16, basePosY + 56));
                    }
                    slots.add(new ScreenSlotInstance(page.mortarRecipe.m_5874_(null), basePosX + 144, basePosY + 56));
                    info = page.makeLines(this.makeInfo());
                    for (i = 0; i < info.size(); ++i) {
                        textLines.add(new ScreenTextInstance(info.get(i), basePosX + 16, basePosY + 96 + i * 11, RootsUtil.intColor(255, 255, 255)));
                    }
                } else {
                    title = ChatFormatting.RED + I18n.m_118938_((String)"rootsclassic.research.disabled", (Object[])new Object[0]);
                }
                textLines.add(new ScreenTextInstance((String)title, (float)(basePosX + 96) - (float)this.f_96547_.m_92895_((String)title) / 2.0f, basePosY + 12, RootsUtil.intColor(255, 255, 255)));
            }
        }
        for (ScreenSlotInstance s : slots) {
            this.f_96542_.m_115123_(s.getStack(), s.getX(), s.getY());
        }
        for (ScreenTextInstance line : textLines) {
            if (line.isShadow()) {
                this.f_96547_.m_92750_(poseStack, line.getLine(), line.getX(), line.getY(), line.getColor());
                continue;
            }
            this.f_96547_.m_92883_(poseStack, line.getLine(), (float)((int)line.getX()), (float)((int)line.getY()), line.getColor());
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)Const.tabletGui);
        if (this.showLeftArrow) {
            if (mouseX >= basePosX + 16 && mouseX < basePosX + 48 && mouseY >= basePosY + 224 && mouseY < basePosY + 240) {
                this.m_93228_(poseStack, basePosX + 16, basePosY + 224, 32, 80, 32, 16);
            } else {
                this.m_93228_(poseStack, basePosX + 16, basePosY + 224, 32, 64, 32, 16);
            }
        }
        if (this.showRightArrow) {
            if (mouseX >= basePosX + 144 && mouseX < basePosX + 176 && mouseY >= basePosY + 224 && mouseY < basePosY + 240) {
                this.m_93228_(poseStack, basePosX + 144, basePosY + 224, 0, 80, 32, 16);
            } else {
                this.m_93228_(poseStack, basePosX + 144, basePosY + 224, 0, 64, 32, 16);
            }
        }
        for (ScreenSlotInstance s : slots) {
            if (!s.isMouseover(mouseX, mouseY)) continue;
            this.m_6057_(poseStack, s.getStack(), mouseX, mouseY);
        }
        poseStack.m_85849_();
    }

    public ItemStack getStackFromIngredient(Ingredient ingredient) {
        ItemStack[] matchingStacks = ingredient.m_43908_();
        if (this.matchingStacksMax != matchingStacks.length) {
            this.matchingStacksMax = matchingStacks.length;
        }
        if (ClientInfo.ticksInGame % 20 == 0) {
            ++this.matchingStacksCurrent;
        }
        if (this.matchingStacksCurrent >= this.matchingStacksMax - 1) {
            this.matchingStacksCurrent = 0;
        }
        return matchingStacks[this.matchingStacksCurrent];
    }

    public ItemStack getStackFrom2ndIngredient(Ingredient ingredient) {
        ItemStack[] matchingStacks = ingredient.m_43908_();
        if (this.matchingStacks2Max != matchingStacks.length) {
            this.matchingStacks2Max = matchingStacks.length;
        }
        if (ClientInfo.ticksInGame % 20 == 0) {
            ++this.matchingStacks2Current;
        }
        if (this.matchingStacks2Current >= this.matchingStacks2Max - 1) {
            this.matchingStacks2Current = 0;
        }
        return matchingStacks[this.matchingStacks2Current];
    }
}

