/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.datagen;

import elucent.rootsclassic.block.AttunedStandingStoneBlock;
import elucent.rootsclassic.lootmodifiers.DropModifier;
import elucent.rootsclassic.registry.RootsEntities;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.registry.RootsTags;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RootsDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new GLMProvider(packOutput));
            RootsBlockTags provider = new RootsBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(event.includeServer(), (DataProvider)provider);
            generator.addProvider(event.includeServer(), (DataProvider)new RootsItemTags(packOutput, lookupProvider, (TagsProvider<Block>)provider, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(RootsBlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(RootsEntityLoot::new, LootContextParamSets.f_81415_)));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private static class RootsEntityLoot
        extends EntityLootSubProvider {
            protected RootsEntityLoot() {
                super(FeatureFlags.f_244280_.m_247355_());
            }

            public void m_246942_() {
                this.m_245309_((EntityType)RootsEntities.PHANTOM_SKELETON.get(), LootTable.m_79147_());
            }

            protected boolean m_245552_(EntityType<?> entityType) {
                return entityType.m_20674_() != MobCategory.MISC;
            }

            protected Stream<EntityType<?>> getKnownEntityTypes() {
                return RootsEntities.ENTITY_TYPES.getEntries().stream().map(RegistryObject::get);
            }
        }

        private static class RootsBlockLoot
        extends BlockLootSubProvider {
            protected RootsBlockLoot() {
                super(Set.of(), FeatureFlags.f_244280_.m_247355_());
            }

            public void m_245660_() {
                this.m_245724_((Block)RootsRegistry.MORTAR.get());
                this.m_245724_((Block)RootsRegistry.ALTAR.get());
                this.m_245724_((Block)RootsRegistry.BRAZIER.get());
                this.m_245724_((Block)RootsRegistry.IMBUER.get());
                this.m_245724_((Block)RootsRegistry.MUNDANE_STANDING_STONE.get());
                this.m_245724_((Block)RootsRegistry.MIDNIGHT_BLOOM.get());
                this.m_245724_((Block)RootsRegistry.FLARE_ORCHID.get());
                this.m_245724_((Block)RootsRegistry.RADIANT_DAISY.get());
                this.m_246481_((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), this::registerStandingStone);
                this.m_246481_((Block)RootsRegistry.VACUUM_STANDING_STONE.get(), this::registerStandingStone);
                this.m_246481_((Block)RootsRegistry.REPULSOR_STANDING_STONE.get(), this::registerStandingStone);
                this.m_246481_((Block)RootsRegistry.ACCELERATOR_STANDING_STONE.get(), this::registerStandingStone);
                this.m_246481_((Block)RootsRegistry.AESTHETIC_STANDING_STONE.get(), this::registerStandingStone);
                this.m_246481_((Block)RootsRegistry.ENTANGLER_STANDING_STONE.get(), this::registerStandingStone);
                this.m_246481_((Block)RootsRegistry.IGNITER_STANDING_STONE.get(), this::registerStandingStone);
                this.m_246481_((Block)RootsRegistry.GROWER_STANDING_STONE.get(), this::registerStandingStone);
                this.m_246481_((Block)RootsRegistry.HEALER_STANDING_STONE.get(), this::registerStandingStone);
            }

            public LootTable.Builder registerStandingStone(Block standingStone) {
                return this.m_245178_(standingStone, (Property)AttunedStandingStoneBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
            }

            protected Iterable<Block> getKnownBlocks() {
                return RootsRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput) {
            super(packOutput);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.PESTLE.get())).m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50228_).m_126145_("pestle").m_126130_("X  ").m_126130_(" XX").m_126130_(" XX").m_126132_("has_diorite", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Blocks.f_50228_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.PESTLE.get())).m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50228_).m_126145_("pestle").m_126130_("  X").m_126130_("XX ").m_126130_("XX ").m_126132_("has_diorite", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Blocks.f_50228_)).m_176500_(consumer, ForgeRegistries.ITEMS.getKey((Object)((Item)RootsRegistry.PESTLE.get())) + "2");
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.MORTAR.get())).m_206416_(Character.valueOf('X'), Tags.Items.STONE).m_126130_("X X").m_126130_("X X").m_126130_(" X ").m_126132_("has_stone", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.STONE)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.IMBUER.get())).m_206416_(Character.valueOf('X'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('L'), ItemTags.f_13182_).m_126127_(Character.valueOf('S'), (ItemLike)Blocks.f_50225_).m_126130_("X X").m_126130_("LSL").m_126132_("has_chiseled_stone_bricks", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Blocks.f_50225_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.MUNDANE_STANDING_STONE.get())).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('B'), (ItemLike)Blocks.f_50222_).m_206416_(Character.valueOf('L'), Tags.Items.STORAGE_BLOCKS_LAPIS).m_126130_("SBS").m_126130_("BLB").m_126130_("SBS").m_126132_("has_lapis_block", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.STORAGE_BLOCKS_LAPIS)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.ATTUNED_STANDING_STONE.get())).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_206416_(Character.valueOf('N'), Tags.Items.INGOTS_NETHER_BRICK).m_206416_(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).m_126130_("SNS").m_126130_("NDN").m_126130_("SNS").m_126132_("has_diamond", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.BRAZIER.get())).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42544_).m_206416_(Character.valueOf('X'), Tags.Items.RODS_WOODEN).m_126130_("ISI").m_126130_("ICI").m_126130_("IXI").m_126132_("has_cauldron", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42544_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.ALTAR.get())).m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_41940_).m_126127_(Character.valueOf('B'), (ItemLike)RootsRegistry.VERDANT_SPRIG.get()).m_206416_(Character.valueOf('G'), Tags.Items.STORAGE_BLOCKS_GOLD).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50225_).m_126130_("BFB").m_126130_("SGS").m_126130_(" C ").m_126132_("has_gold_block", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RootsRegistry.BARK_KNIFE.get())).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('V'), ItemTags.f_13180_).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126130_(" VV").m_126130_("VPV").m_126130_("SV ").m_126132_("has_sapling", (CriterionTriggerInstance)Recipes.m_206406_((TagKey)ItemTags.f_13180_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.RUNIC_TABLET.get())).m_206416_(Character.valueOf('S'), Tags.Items.SEEDS_WHEAT).m_206416_(Character.valueOf('B'), Tags.Items.STONE).m_126127_(Character.valueOf('R'), (ItemLike)RootsRegistry.OLD_ROOT.get()).m_126130_(" R ").m_126130_("SBS").m_126130_(" S ").m_126132_("has_old_root", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.OLD_ROOT.get()))).m_176498_(consumer);
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.GROWTH_POWDER.get()), (int)4).m_206419_(Tags.Items.SEEDS_WHEAT).m_126209_((ItemLike)Items.f_41864_).m_206419_(Tags.Items.DUSTS_REDSTONE).m_126209_((ItemLike)RootsRegistry.PESTLE.get()).m_126132_("has_pestle", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.PESTLE.get()))).m_176498_(consumer);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.MUTATING_POWDER.get())).m_126209_((ItemLike)RootsRegistry.GROWTH_POWDER.get()).m_126209_((ItemLike)RootsRegistry.GROWTH_POWDER.get()).m_126209_((ItemLike)RootsRegistry.GROWTH_POWDER.get()).m_126209_((ItemLike)RootsRegistry.GROWTH_POWDER.get()).m_206419_(Tags.Items.NETHER_STARS).m_206419_(Tags.Items.CROPS_NETHER_WART).m_126209_((ItemLike)RootsRegistry.PESTLE.get()).m_126132_("has_pestle", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.PESTLE.get()))).m_176498_(consumer);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)RootsRegistry.ROOTY_STEW.get())).m_206419_(Tags.Items.CROPS_WHEAT).m_126209_((ItemLike)Items.f_42399_).m_126209_((ItemLike)RootsRegistry.OLD_ROOT.get()).m_126132_("has_bowl", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42399_)).m_176498_(consumer);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)RootsRegistry.FRUIT_SALAD.get())).m_126209_((ItemLike)Items.f_42028_).m_126209_((ItemLike)Items.f_42028_).m_126209_((ItemLike)Items.f_42028_).m_126209_((ItemLike)Items.f_42410_).m_126209_((ItemLike)Items.f_42399_).m_126209_((ItemLike)RootsRegistry.ELDERBERRY.get()).m_126209_((ItemLike)RootsRegistry.WHITECURRANT.get()).m_126209_((ItemLike)RootsRegistry.BLACKCURRANT.get()).m_126209_((ItemLike)RootsRegistry.REDCURRANT.get()).m_126132_("has_bowl", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42399_)).m_176498_(consumer);
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RootsRegistry.HEALING_POULTICE.get()), (int)2).m_126209_((ItemLike)RootsRegistry.REDCURRANT.get()).m_126209_((ItemLike)Items.f_42516_).m_126209_((ItemLike)RootsRegistry.PESTLE.get()).m_126209_((ItemLike)RootsRegistry.VERDANT_SPRIG.get()).m_126132_("has_pestle", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.PESTLE.get()))).m_176498_(consumer);
            SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RootsRegistry.DRAGONS_EYE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42584_, (float)1.0f, (int)200).m_126132_("has_dragons_eye", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)RootsRegistry.DRAGONS_EYE.get()))).m_176500_(consumer, "rootsclassic:ender_pearl");
        }
    }

    private static class GLMProvider
    extends GlobalLootModifierProvider {
        public GLMProvider(PackOutput packOutput) {
            super(packOutput, "rootsclassic");
        }

        protected void start() {
            this.add("rootsclassic_drops", (IGlobalLootModifier)new DropModifier.BlockDropModifier(new LootItemCondition[]{InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS))).m_6409_()}));
        }
    }

    public static class RootsBlockTags
    extends BlockTagsProvider {
        public RootsBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "rootsclassic", existingFileHelper);
        }

        public void m_6577_(HolderLookup.Provider lookupProvider) {
            this.m_206424_(RootsTags.NEEDS_LIVING_TOOL);
            this.m_206424_(RootsTags.NEEDS_ENGRAVED_TOOL);
        }
    }

    public static class RootsItemTags
    extends ItemTagsProvider {
        public RootsItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, TagsProvider<Block> blockTagProvider, ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, blockTagProvider, "rootsclassic", existingFileHelper);
        }

        public void m_6577_(HolderLookup.Provider lookupProvider) {
            this.m_206424_(RootsTags.BERRIES).m_255179_((Object[])new Item[]{(Item)RootsRegistry.NIGHTSHADE.get(), (Item)RootsRegistry.BLACKCURRANT.get(), (Item)RootsRegistry.REDCURRANT.get(), (Item)RootsRegistry.WHITECURRANT.get(), (Item)RootsRegistry.ELDERBERRY.get()});
            this.addBark((Item)RootsRegistry.ACACIA_BARK.get(), "acacia");
            this.addBark((Item)RootsRegistry.BIRCH_BARK.get(), "birch");
            this.addBark((Item)RootsRegistry.DARK_OAK_BARK.get(), "dark_oak");
            this.addBark((Item)RootsRegistry.JUNGLE_BARK.get(), "jungle");
            this.addBark((Item)RootsRegistry.OAK_BARK.get(), "oak");
            this.addBark((Item)RootsRegistry.SPRUCE_BARK.get(), "spruce");
        }

        private void addBark(Item item, String treeType) {
            TagKey barkTypeTag = ItemTags.create((ResourceLocation)new ResourceLocation("rootsclassic", "barks/" + treeType));
            this.m_206424_(RootsTags.BARKS).m_206428_(barkTypeTag);
            this.m_206424_(barkTypeTag).m_255245_((Object)item);
        }
    }
}

