/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import elucent.rootsclassic.client.ClientHandler;
import elucent.rootsclassic.client.model.WildwoodArmorModel;
import elucent.rootsclassic.util.RootsUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.DistExecutor;

public class WildwoodArmorItem
extends ArmorItem {
    private final LazyLoadedValue<HumanoidModel<?>> model = (LazyLoadedValue)DistExecutor.unsafeRunForDist(() -> () -> new LazyLoadedValue(() -> this.provideArmorModelForSlot(type)), () -> () -> null);

    public WildwoodArmorItem(ArmorMaterial materialIn, ArmorItem.Type type, Item.Properties builderIn) {
        super(materialIn, type, builderIn);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "rootsclassic:textures/models/armor/wildwood.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public HumanoidModel<?> provideArmorModelForSlot(ArmorItem.Type type) {
        return new WildwoodArmorModel(Minecraft.m_91087_().m_167973_().m_171103_(ClientHandler.WILDWOOD_ARMOR), type);
    }

    public void onArmorTick(ItemStack stack, Level levelAccessor, Player player) {
        RootsUtil.randomlyRepair(levelAccessor.f_46441_, stack);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelAccessor, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelAccessor, tooltip, flagIn);
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"rootsclassic.attribute.equipped").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"rootsclassic.attribute.increasedmanaregen")).m_130940_(ChatFormatting.BLUE));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return (HumanoidModel)WildwoodArmorItem.this.model.m_13971_();
            }
        });
    }
}

