/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.client;

import elucent.rootsclassic.client.model.SylvanArmorModel;
import elucent.rootsclassic.client.model.WildwoodArmorModel;
import elucent.rootsclassic.client.particles.MagicAltarLineParticleData;
import elucent.rootsclassic.client.particles.MagicAltarParticleData;
import elucent.rootsclassic.client.particles.MagicAuraParticleData;
import elucent.rootsclassic.client.particles.MagicLineParticleData;
import elucent.rootsclassic.client.particles.MagicParticleData;
import elucent.rootsclassic.client.renderer.block.AltarBER;
import elucent.rootsclassic.client.renderer.block.BrazierBER;
import elucent.rootsclassic.client.renderer.block.ImbuerBER;
import elucent.rootsclassic.client.renderer.block.MortarBER;
import elucent.rootsclassic.client.renderer.entity.AcceleratorRenderer;
import elucent.rootsclassic.client.renderer.entity.PhantomSkeletonRenderer;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentBaseRegistry;
import elucent.rootsclassic.item.CrystalStaffItem;
import elucent.rootsclassic.item.StaffItem;
import elucent.rootsclassic.registry.ParticleRegistry;
import elucent.rootsclassic.registry.RootsEntities;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.util.RootsUtil;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientHandler {
    public static final ModelLayerLocation SYLVAN_ARMOR = new ModelLayerLocation(new ResourceLocation("rootsclassic", "main"), "sylvan_armor");
    public static final ModelLayerLocation WILDWOOD_ARMOR = new ModelLayerLocation(new ResourceLocation("rootsclassic", "main"), "wildwood_armor");

    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)RootsRegistry.STAFF.get()), (ResourceLocation)new ResourceLocation("imbued"), (stack, world, livingEntity, unused) -> stack.m_41783_() != null && stack.m_41783_().m_128441_("rootsclassic:effect") ? 1.0f : 0.0f);
    }

    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)RootsRegistry.MORTAR_TILE.get(), MortarBER::new);
        event.registerBlockEntityRenderer((BlockEntityType)RootsRegistry.IMBUER_TILE.get(), ImbuerBER::new);
        event.registerBlockEntityRenderer((BlockEntityType)RootsRegistry.ALTAR_TILE.get(), AltarBER::new);
        event.registerBlockEntityRenderer((BlockEntityType)RootsRegistry.BRAZIER_TILE.get(), BrazierBER::new);
        event.registerEntityRenderer((EntityType)RootsEntities.PHANTOM_SKELETON.get(), PhantomSkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)RootsEntities.ENTITY_ACCELERATOR.get(), AcceleratorRenderer::new);
        event.registerEntityRenderer((EntityType)RootsEntities.TILE_ACCELERATOR.get(), AcceleratorRenderer::new);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SYLVAN_ARMOR, SylvanArmorModel::createArmorDefinition);
        event.registerLayerDefinition(WILDWOOD_ARMOR, WildwoodArmorModel::createArmorDefinition);
    }

    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            ComponentBase comp;
            CompoundTag tag;
            ResourceLocation compName;
            if (stack.m_41782_() && stack.m_41720_() instanceof StaffItem && (compName = ResourceLocation.m_135820_((String)(tag = stack.m_41783_()).m_128461_("rootsclassic:effect"))) != null && (comp = (ComponentBase)ComponentBaseRegistry.COMPONENTS.get().getValue(compName)) != null) {
                if (tintIndex == 2) {
                    return RootsUtil.intColor((int)comp.primaryColor.f_82479_, (int)comp.primaryColor.f_82480_, (int)comp.primaryColor.f_82481_);
                }
                if (tintIndex == 1) {
                    return RootsUtil.intColor((int)comp.secondaryColor.f_82479_, (int)comp.secondaryColor.f_82480_, (int)comp.secondaryColor.f_82481_);
                }
            }
            return RootsUtil.intColor(255, 255, 255);
        }, new ItemLike[]{(ItemLike)RootsRegistry.STAFF.get()});
        event.register((stack, tintIndex) -> {
            ComponentBase comp;
            ResourceLocation compName;
            String effect;
            if (stack.m_41720_() instanceof CrystalStaffItem && stack.m_41782_() && (effect = CrystalStaffItem.getEffect(stack)) != null && (compName = ResourceLocation.m_135820_((String)effect)) != null && (comp = (ComponentBase)ComponentBaseRegistry.COMPONENTS.get().getValue(compName)) != null) {
                if (tintIndex == 2) {
                    return RootsUtil.intColor((int)comp.primaryColor.f_82479_, (int)comp.primaryColor.f_82480_, (int)comp.primaryColor.f_82481_);
                }
                if (tintIndex == 1) {
                    return RootsUtil.intColor((int)comp.secondaryColor.f_82479_, (int)comp.secondaryColor.f_82480_, (int)comp.secondaryColor.f_82481_);
                }
            }
            return RootsUtil.intColor(255, 255, 255);
        }, new ItemLike[]{(ItemLike)RootsRegistry.CRYSTAL_STAFF.get()});
    }

    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.MAGIC_TYPE.get(), MagicParticleData::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.MAGIC_AURA_TYPE.get(), MagicAuraParticleData::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.MAGIC_ALTAR_TYPE.get(), MagicAltarParticleData::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.MAGIC_ALTAR_LINE_TYPE.get(), MagicAltarLineParticleData::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.MAGIC_LINE_TYPE.get(), MagicLineParticleData::new);
    }
}

